/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.aerospike.data;

import com.aerospike.client.IAerospikeClient;
import org.springframework.boot.aerospike.data.AerospikeDataConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.aerospike.AerospikeAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.IsClientOnly;
import org.springframework.boot.autoconfigure.condition.IsNotClientOnly;
import org.springframework.boot.autoconfigure.data.aerospike.AerospikeDataProperties;
import org.springframework.boot.client.autoconfigure.AerospikeClientConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Import;
import org.springframework.data.aerospike.repository.AerospikeRepository;

@AutoConfiguration
@ConditionalOnClass(value={IAerospikeClient.class, AerospikeRepository.class})
@AutoConfigureAfter(value={AerospikeAutoConfiguration.class})
public class AerospikeDataAutoConfiguration {

    @Conditional(value={IsClientOnly.class})
    @Import(value={AerospikeClientConfiguration.class})
    static class ClientConfigurationImport {
        ClientConfigurationImport() {
        }
    }

    @Conditional(value={IsNotClientOnly.class})
    @EnableConfigurationProperties(value={AerospikeDataProperties.class})
    @Import(value={AerospikeDataConfiguration.class})
    static class DataConfigurationImport {
        DataConfigurationImport() {
        }
    }
}

