/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.convert;

import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.aerospike.mapping.AerospikeMetadataBin;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.util.Assert;

public class AerospikeData
implements Serializable {
    private static final long serialVersionUID = 5008392909263724861L;
    private static final String AEROSPIKE_BIN_DATA_LIST = "AerospikeBinDataList";
    private static final String AEROSPIKE_BIN_RECORD_MAP = "AerospikeBinRecordMap";
    private static final String AEROSPIKE_KEY = "Aerospike_Key";
    public static final String SPRING_ID_BIN = "SpringID";
    private Key key;
    private Record record;
    private final String namespace;
    private final List<Bin> bins;
    private AerospikeMetadataBin metaData;

    private AerospikeData(Key key, Record record, String namespace, List<Bin> bins, String[] binNames) {
        this.key = key;
        this.record = record;
        this.namespace = namespace;
        this.bins = bins;
        this.metaData = new AerospikeMetadataBin();
    }

    public static AerospikeData forRead(Key key, String[] binNames) {
        return new AerospikeData(key, null, key.namespace, Collections.emptyList(), binNames);
    }

    public static AerospikeData forWrite(String namespace) {
        return new AerospikeData(null, null, namespace, new ArrayList<Bin>(), null);
    }

    public Key getKey() {
        return this.key;
    }

    public void setID(byte[] ID) {
        this.key = new Key(this.getNamespace(), this.getSetName(), ID);
    }

    public void setID(String ID) {
        this.key = new Key(this.getNamespace(), this.getSetName(), ID);
    }

    public void setID(long ID) {
        this.key = new Key(this.getNamespace(), this.getSetName(), ID);
    }

    public void setID(int ID) {
        this.key = new Key(this.getNamespace(), this.getSetName(), ID);
    }

    public void setID(Value ID) {
        this.key = new Key(this.getNamespace(), this.getSetName(), ID);
    }

    public void setID(Serializable id) {
        this.setID(id.toString());
    }

    public Record getRecord() {
        return this.record;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSetName() {
        return this.key != null ? this.key.setName : null;
    }

    public List<Bin> getBins() {
        return this.bins;
    }

    public Bin[] getBinsAsArray() {
        return this.getBins().toArray(new Bin[this.bins.size()]);
    }

    public void add(List<Bin> bins) {
        this.bins.addAll(bins);
    }

    public void add(Bin bin) {
        this.bins.add(bin);
    }

    public void addMetaDataToBin() {
        this.add(this.getMetaData().getAerospikeMetaDataBin());
    }

    public void setMetaData(Bin bin) {
    }

    public void addMetaDataItem(String key, Object value) {
        Assert.notNull((Object)key, (String)"key must not be null");
        this.getMetaData().addKeyValuetoAerospikeMetaData(key, value);
    }

    public String[] getBinNames() {
        if (this.bins == null || this.bins.size() == 0) {
            return null;
        }
        String[] binAsStringArray = new String[this.bins.size()];
        int i = 0;
        for (Bin bin : this.bins) {
            binAsStringArray[i] = bin.name;
            ++i;
        }
        return binAsStringArray;
    }

    public void setRecord(Record record) {
        if (record != null) {
            this.getMetaData().addMap((HashMap)record.getValue("ASpikeMetaData"));
        }
        this.record = record;
    }

    public void setSetName(String setName) {
        this.key = new Key(this.getNamespace(), setName, this.key.userKey);
    }

    public Object getSpringId() {
        HashMap aerospikeMetaData = (HashMap)this.record.getValue("ASpikeMetaData");
        return aerospikeMetaData == null ? null : aerospikeMetaData.get(SPRING_ID_BIN);
    }

    public AerospikeMetadataBin getMetaData() {
        return this.metaData;
    }

    public void setMetaData(AerospikeMetadataBin metaData) {
        this.metaData = metaData;
    }

    public static Map convertToMap(AerospikeData aerospikeData, SimpleTypeHolder simpleTypeHolder) {
        HashMap<String, Object> map = new HashMap<String, Object>(aerospikeData.bins.size() + 2);
        map.put("spring_class", aerospikeData.getMetaData().getAerospikeMetaDataUsingKey("spring_class"));
        map.put(SPRING_ID_BIN, aerospikeData.getMetaData().getAerospikeMetaDataUsingKey(SPRING_ID_BIN));
        ArrayList binDatas = new ArrayList();
        List<Bin> bins = aerospikeData.getBins();
        Object binData = null;
        for (Bin bin : bins) {
            if (bin.name.equals("ASpikeMetaData")) continue;
            map.put(bin.name, bin.value.getObject());
        }
        return map;
    }

    public static AerospikeData convertToAerospikeData(Map binMap) {
        Record record = null;
        List<String> ignore = Arrays.asList("spring_class", SPRING_ID_BIN, "ASpikeMetaData", AEROSPIKE_BIN_DATA_LIST, AEROSPIKE_BIN_RECORD_MAP, SPRING_ID_BIN);
        HashMap map = (HashMap)binMap;
        if (map == null) {
            return null;
        }
        Key key = (Key)map.get(AEROSPIKE_KEY);
        if (key == null) {
            key = new Key("namespace", "setname", "key");
        }
        AerospikeData aerospikeData = AerospikeData.forRead(key, null);
        HashMap recordBins = new HashMap(aerospikeData.bins.size());
        for (Map.Entry binEntry : map.entrySet()) {
            String property = (String)binEntry.getKey();
            if (ignore.contains(property)) continue;
            recordBins.put(property, binEntry.getValue());
        }
        record = new Record(recordBins, 0, 0);
        aerospikeData.setRecord(record);
        return aerospikeData;
    }
}

