/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.convert;

import com.aerospike.client.Bin;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.aerospike.convert.AerospikeConverter;
import org.springframework.data.aerospike.convert.AerospikeData;
import org.springframework.data.aerospike.convert.EnumToStringConverterFactory;
import org.springframework.data.aerospike.convert.LocalDateTimeToStringConverter;
import org.springframework.data.aerospike.convert.LongToBoolean;
import org.springframework.data.aerospike.convert.StringToEnumConverterFactory;
import org.springframework.data.aerospike.convert.StringToLocalDateTimeConverter;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.AerospikeSimpleTypes;
import org.springframework.data.aerospike.mapping.CachingAerospikePersistentProperty;
import org.springframework.data.convert.DefaultTypeMapper;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.convert.TypeAliasAccessor;
import org.springframework.data.convert.TypeMapper;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class MappingAerospikeConverter
implements AerospikeConverter {
    private final AerospikeMappingContext mappingContext;
    private final SimpleTypeHolder simpleTypeHolder;
    private final ConversionService conversionService;
    private final EntityInstantiators entityInstantiators;
    private final TypeMapper<AerospikeData> typeMapper;
    public static final String SPRING_ID_BIN = "SpringID";
    protected ApplicationContext applicationContext;
    protected final SpelExpressionParser spelExpressionParser = new SpelExpressionParser();

    public MappingAerospikeConverter() {
        this.mappingContext = new AerospikeMappingContext();
        DefaultConversionService defaultConversionService = new DefaultConversionService();
        defaultConversionService.addConverter((Converter)new LongToBoolean());
        defaultConversionService.addConverter(new StringToLocalDateTimeConverter());
        defaultConversionService.addConverter(new LocalDateTimeToStringConverter());
        defaultConversionService.addConverterFactory(new EnumToStringConverterFactory());
        defaultConversionService.addConverterFactory((ConverterFactory)new StringToEnumConverterFactory());
        this.conversionService = defaultConversionService;
        this.entityInstantiators = new EntityInstantiators();
        this.simpleTypeHolder = AerospikeSimpleTypes.HOLDER;
        this.typeMapper = new DefaultTypeMapper((TypeAliasAccessor)AerospikeTypeAliasAccessor.INSTANCE);
    }

    public MappingContext<? extends AerospikePersistentEntity<?>, AerospikePersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public <R> R read(Class<R> type, final AerospikeData data) {
        TypeInformation readType = this.typeMapper.readType((Object)data, (TypeInformation)ClassTypeInformation.from(type));
        TypeInformation typeToUse = type.isAssignableFrom(readType.getType()) ? readType : ClassTypeInformation.from(type);
        final AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getPersistentEntity(typeToUse);
        final RecordReadingPropertyValueProvider recordReadingPropertyValueProvider = new RecordReadingPropertyValueProvider(data.getRecord(), this.getConversionService(), this.simpleTypeHolder);
        EntityInstantiator instantiator = this.entityInstantiators.getInstantiatorFor((PersistentEntity)entity);
        Object instance = instantiator.createInstance((PersistentEntity)entity, (ParameterValueProvider)new PersistentEntityParameterValueProvider((PersistentEntity)entity, (PropertyValueProvider)recordReadingPropertyValueProvider, null));
        if (data.getRecord() != null) {
            final PersistentPropertyAccessor accessor = entity.getPropertyAccessor(instance);
            entity.doWithProperties((PropertyHandler)new PropertyHandler<AerospikePersistentProperty>(){

                public void doWithPersistentProperty(AerospikePersistentProperty persistentProperty) {
                    PreferredConstructor constructor = entity.getPersistenceConstructor();
                    Record record = data.getRecord();
                    if (record == null) {
                        return;
                    }
                    Object propertyObject = record.getValue(((CachingAerospikePersistentProperty)persistentProperty).getFieldName());
                    if (propertyObject instanceof HashMap && ((Map)propertyObject).containsKey(MappingAerospikeConverter.SPRING_ID_BIN)) {
                        AerospikeData aerospikeData = AerospikeData.convertToAerospikeData((Map)propertyObject);
                        if (aerospikeData == null) {
                            return;
                        }
                        accessor.setProperty((PersistentProperty)persistentProperty, MappingAerospikeConverter.this.read(persistentProperty.getType(), aerospikeData));
                        return;
                    }
                    if (constructor.isConstructorParameter((PersistentProperty)persistentProperty)) {
                        return;
                    }
                    if (persistentProperty.isIdProperty()) {
                        Object value = recordReadingPropertyValueProvider.getPropertyValue(persistentProperty, data.getSpringId());
                        if (value != null) {
                            accessor.setProperty((PersistentProperty)persistentProperty, value);
                        }
                        return;
                    }
                    Object value = recordReadingPropertyValueProvider.getPropertyValue(persistentProperty);
                    if (value != null) {
                        accessor.setProperty((PersistentProperty)persistentProperty, value);
                    }
                }
            });
        } else {
            instance = null;
        }
        return (R)instance;
    }

    public <R> R read(Object instance, final AerospikeData data) {
        TypeInformation readType;
        Class<?> type = instance.getClass();
        TypeInformation typeToUse = type.isAssignableFrom((readType = this.typeMapper.readType((Object)data, (TypeInformation)ClassTypeInformation.from(type))).getType()) ? readType : ClassTypeInformation.from(type);
        final AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getPersistentEntity(typeToUse);
        final RecordReadingPropertyValueProvider recordReadingPropertyValueProvider = new RecordReadingPropertyValueProvider(data.getRecord(), this.getConversionService(), this.simpleTypeHolder);
        if (data.getRecord() != null) {
            final PersistentPropertyAccessor accessor = entity.getPropertyAccessor(instance);
            entity.doWithProperties((PropertyHandler)new PropertyHandler<AerospikePersistentProperty>(){

                public void doWithPersistentProperty(AerospikePersistentProperty persistentProperty) {
                    PreferredConstructor constructor = entity.getPersistenceConstructor();
                    if (constructor.isConstructorParameter((PersistentProperty)persistentProperty)) {
                        return;
                    }
                    if (persistentProperty.isIdProperty()) {
                        Object value = recordReadingPropertyValueProvider.getPropertyValue(persistentProperty, data.getSpringId());
                        if (value != null) {
                            accessor.setProperty((PersistentProperty)persistentProperty, value);
                        }
                        return;
                    }
                    Object value = recordReadingPropertyValueProvider.getPropertyValue(persistentProperty);
                    if (value != null) {
                        accessor.setProperty((PersistentProperty)persistentProperty, value);
                    }
                }
            });
        } else {
            instance = null;
        }
        return (R)instance;
    }

    public void write(Object source, AerospikeData data) {
        if (null == source) {
            return;
        }
        ArrayList<Bin> bins = new ArrayList<Bin>();
        Class<?> entityType = source.getClass();
        ClassTypeInformation type = ClassTypeInformation.from(entityType);
        this.writeInternal(source, data, (TypeInformation<?>)type, (List<Bin>)bins);
        data.add(bins);
        data.addMetaDataToBin();
    }

    protected void writeInternal(Object obj, AerospikeData data, TypeInformation<?> type, List<Bin> bins) {
        if (null == obj) {
            return;
        }
        Class<?> entityType = obj.getClass();
        if (Map.class.isAssignableFrom(entityType)) {
            return;
        }
        if (Collection.class.isAssignableFrom(entityType)) {
            return;
        }
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getPersistentEntity(entityType);
        this.writeInternal(obj, data, entity, bins);
        this.typeMapper.writeType(entity.getTypeInformation(), (Object)data);
        if (data.getSetName() == null) {
            data.setSetName(entity.getSetName());
        }
    }

    protected void writeInternal(Object obj, final AerospikeData data, AerospikePersistentEntity<?> entity, final List<Bin> bins) {
        if (obj == null) {
            return;
        }
        if (null == entity) {
            throw new MappingException("No mapping metadata found for entity of type " + obj.getClass().getName());
        }
        final PersistentPropertyAccessor accessor = entity.getPropertyAccessor(obj);
        final CachingAerospikePersistentProperty idProperty = (CachingAerospikePersistentProperty)entity.getIdProperty();
        if (idProperty != null) {
            Object id = accessor.getProperty((PersistentProperty)idProperty);
            data.setID(id != null ? id.toString() : null);
            data.addMetaDataItem(SPRING_ID_BIN, id);
            data.addMetaDataItem(idProperty.getFieldName(), idProperty.getType());
            bins.add(new Bin(idProperty.getFieldName(), accessor.getProperty((PersistentProperty)idProperty)));
        }
        entity.doWithProperties((PropertyHandler)new PropertyHandler<AerospikePersistentProperty>(){

            public void doWithPersistentProperty(AerospikePersistentProperty persistentProperty) {
                if (persistentProperty.equals(idProperty) || !persistentProperty.isWritable()) {
                    return;
                }
                Object propertyObj = accessor.getProperty((PersistentProperty)persistentProperty);
                if (propertyObj == null || MappingAerospikeConverter.this.simpleTypeHolder.isSimpleType(propertyObj.getClass())) {
                    MappingAerospikeConverter.this.writeSimpleInternal(propertyObj, data, persistentProperty, accessor, bins);
                } else {
                    MappingAerospikeConverter.this.writePropertyInternal(propertyObj, data, persistentProperty, accessor, bins);
                }
            }
        });
    }

    protected void writePropertyInternal(Object propertyObj, AerospikeData data, AerospikePersistentProperty persistentProperty, PersistentPropertyAccessor accessor, List<Bin> bins) {
        if (propertyObj == null) {
            return;
        }
        ClassTypeInformation valueType = ClassTypeInformation.from(propertyObj.getClass());
        String fieldName = ((CachingAerospikePersistentProperty)persistentProperty).getFieldName();
        data.addMetaDataItem(fieldName, valueType.getType());
        if (valueType.isCollectionLike()) {
            List<?> collection = MappingAerospikeConverter.asList(accessor.getProperty((PersistentProperty)persistentProperty));
            ArrayList propertyList = new ArrayList();
            this.writeCollectionInternal((Collection<?>)collection, (TypeInformation<?>)valueType, propertyList);
            Bin collectionBin = new Bin(fieldName, propertyList);
            bins.add(collectionBin);
        } else if (valueType.isMap()) {
            data.addMetaDataItem(fieldName, propertyObj.getClass());
            Value.MapValue value = new Value.MapValue((Map)accessor.getProperty((PersistentProperty)persistentProperty));
            bins.add(new Bin(fieldName, (Value)value));
        } else if (Value.class.isAssignableFrom(valueType.getType())) {
            bins.add(new Bin(fieldName, propertyObj));
        } else if (this.conversionService.canConvert(propertyObj.getClass(), String.class)) {
            Value.StringValue value = new Value.StringValue((String)this.conversionService.convert(propertyObj, String.class));
            bins.add(new Bin(fieldName, (Value)value));
        } else {
            AerospikePersistentEntity childEntity = (AerospikePersistentEntity)this.mappingContext.getPersistentEntity(propertyObj.getClass());
            AerospikeData childData = AerospikeData.forWrite(data.getNamespace());
            ArrayList<Bin> childBins = new ArrayList<Bin>();
            this.writeInternal(propertyObj, childData, childEntity, childBins);
            this.typeMapper.writeType(childEntity.getTypeInformation(), (Object)childData);
            if (data.getSetName() == null) {
                data.setSetName(childEntity.getSetName());
            }
            childData.add(childBins);
            childData.addMetaDataToBin();
            bins.add(new Bin(fieldName, AerospikeData.convertToMap(childData, this.simpleTypeHolder)));
        }
    }

    private static List<?> asList(Object source) {
        if (source instanceof Collection) {
            return new ArrayList((Collection)source);
        }
        return null;
    }

    private static Collection<?> asCollection(Object source) {
        if (source instanceof Collection) {
            return (Collection)source;
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
    }

    protected void writeSimpleInternal(Object propertyObj, AerospikeData data, AerospikePersistentProperty persistentProperty, PersistentPropertyAccessor accessor, List<Bin> bins) {
        String fieldName = ((CachingAerospikePersistentProperty)persistentProperty).getFieldName();
        data.addMetaDataItem(fieldName, persistentProperty.getType());
        bins.add(new Bin(fieldName, accessor.getProperty((PersistentProperty)persistentProperty)));
    }

    protected <T> void writeCollectionInternal(Collection<?> collection, TypeInformation<?> type, List<T> propertyList) {
        Map map = null;
        for (Object element : collection) {
            if (element == null) continue;
            Class<?> elementType = element == null ? null : element.getClass();
            AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getPersistentEntity(elementType);
            if (elementType == null || this.simpleTypeHolder.isSimpleType(elementType)) {
                propertyList.add(element);
                continue;
            }
            if (element instanceof Collection || elementType.isArray()) continue;
            AerospikeData childData = AerospikeData.forWrite(entity.getSetName());
            ArrayList<Bin> childBins = new ArrayList<Bin>();
            this.writeInternal(element, childData, entity, childBins);
            this.typeMapper.writeType(entity.getTypeInformation(), (Object)childData);
            childData.add(childBins);
            childData.addMetaDataToBin();
            map = AerospikeData.convertToMap(childData, this.simpleTypeHolder);
            propertyList.add(map);
        }
    }

    protected void writeMapInternal(Map<Object, Object> obj, AerospikeData data, TypeInformation<?> propertyType, List<Bin> bins) {
    }

    @Override
    public Object convertToAerospikeType(Object obj) {
        return null;
    }

    @Override
    public Object convertToAerospikeType(Object obj, TypeInformation<?> typeInformation) {
        return null;
    }

    @Override
    public AerospikeData toAerospikeData(Object object, AerospikePersistentProperty referingProperty) {
        return null;
    }

    private static enum AerospikeTypeAliasAccessor implements TypeAliasAccessor<AerospikeData>
    {
        INSTANCE;

        private static final String TYPE_BIN_NAME = "spring_class";

        public Object readAliasFrom(AerospikeData source) {
            Assert.notNull((Object)source);
            if (source.getRecord() == null) {
                return null;
            }
            return source.getMetaData() == null ? null : source.getMetaData().getAerospikeMetaDataUsingKey(TYPE_BIN_NAME);
        }

        public void writeTypeTo(AerospikeData sink, Object alias) {
            sink.addMetaDataItem(TYPE_BIN_NAME, alias.toString());
        }
    }

    private static class RecordReadingPropertyValueProvider
    implements PropertyValueProvider<AerospikePersistentProperty> {
        private final Record record;
        private final ConversionService conversionService;
        private final SimpleTypeHolder simpleTypeHolder;

        public RecordReadingPropertyValueProvider(Record record, ConversionService conversionService, SimpleTypeHolder simpleTypeHolder) {
            this.record = record;
            this.conversionService = conversionService;
            this.simpleTypeHolder = simpleTypeHolder;
        }

        public <T> T getPropertyValue(AerospikePersistentProperty property) {
            Object value = null;
            if (this.record == null) {
                return (T)value;
            }
            Object propertyObject = this.record.getValue(((CachingAerospikePersistentProperty)property).getFieldName());
            if (propertyObject != null) {
                value = this.conversionService.convert(propertyObject, TypeDescriptor.valueOf(propertyObject.getClass()), TypeDescriptor.valueOf((Class)property.getType()));
            }
            return (T)value;
        }

        public <T> T getPropertyValue(AerospikePersistentProperty property, Object propertyObject) {
            Object value = null;
            if (this.record == null) {
                return (T)value;
            }
            if (propertyObject != null) {
                value = this.conversionService.convert(propertyObject, TypeDescriptor.valueOf(propertyObject.getClass()), TypeDescriptor.valueOf((Class)property.getType()));
            }
            return (T)value;
        }
    }
}

