/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.RecordSet;
import com.aerospike.client.query.Statement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.data.aerospike.convert.AerospikeConverter;
import org.springframework.data.aerospike.convert.AerospikeData;
import org.springframework.data.aerospike.utility.Utils;
import org.springframework.data.keyvalue.core.AbstractKeyValueAdapter;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.util.CloseableIterator;

public class AerospikeKeyValueAdapter
extends AbstractKeyValueAdapter {
    private final AerospikeConverter converter;
    private final AerospikeClient client;
    private String namespace;
    private final WritePolicy insertPolicy;
    private final WritePolicy updatePolicy;

    public AerospikeKeyValueAdapter(AerospikeClient client, AerospikeConverter converter, String namespace) {
        this.client = client;
        this.converter = converter;
        this.namespace = namespace;
        this.insertPolicy = new WritePolicy(this.client.writePolicyDefault);
        this.updatePolicy = new WritePolicy(this.client.writePolicyDefault);
        this.insertPolicy.recordExistsAction = RecordExistsAction.CREATE_ONLY;
        this.updatePolicy.recordExistsAction = RecordExistsAction.UPDATE_ONLY;
    }

    public Object put(Serializable id, Object item, Serializable keyspace) {
        AerospikeData data = AerospikeData.forWrite(this.namespace);
        this.converter.write(item, data);
        this.client.put(null, data.getKey(), data.getBinsAsArray());
        return item;
    }

    public boolean contains(Serializable id, Serializable keyspace) {
        return this.client.exists(null, this.makeKey(keyspace.toString(), id.toString()));
    }

    public Object get(Serializable id, Serializable keyspace) {
        Key key = this.makeKey(keyspace.toString(), id.toString());
        Record record = this.client.get(null, key);
        AerospikeData data = AerospikeData.forRead(key, null);
        data.setRecord(record);
        return this.converter.read(Object.class, data);
    }

    public Object delete(Serializable id, Serializable keyspace) {
        Key key = new Key(this.namespace, keyspace.toString(), id.toString());
        Object object = this.get(id, keyspace);
        if (object != null) {
            WritePolicy wp = new WritePolicy();
            wp.recordExistsAction = RecordExistsAction.UPDATE_ONLY;
            this.client.delete(wp, key);
        }
        return object;
    }

    public Collection<?> getAllOf(Serializable keyspace) {
        Statement statement = new Statement();
        statement.setNamespace(this.namespace);
        statement.setSetName(keyspace.toString());
        ArrayList result = new ArrayList();
        RecordSet recordSet = this.client.query(null, statement);
        while (recordSet.next()) {
        }
        return result;
    }

    public void deleteAllOf(Serializable keyspace) {
        Utils.infoAll(this.client, "set-config:context=namespace;id=" + this.namespace + ";set=" + keyspace.toString() + ";set-delete=true;");
    }

    public void clear() {
    }

    public void destroy() throws Exception {
    }

    private Key makeKey(String set, Object keyValue) {
        return new Key(this.namespace, set, Value.get((Object)keyValue));
    }

    public Collection<?> find(KeyValueQuery<?> query, Serializable keyspace) {
        return super.find(query, keyspace);
    }

    public CloseableIterator<Map.Entry<Serializable, Object>> entries(Serializable keyspace) {
        return null;
    }

    public long count(Serializable keyspace) {
        return 0L;
    }
}

