/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Info;
import com.aerospike.client.Key;
import com.aerospike.client.Log;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.ScanCallback;
import com.aerospike.client.Value;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.IndexType;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.ResultSet;
import com.aerospike.client.query.Statement;
import com.aerospike.client.task.IndexTask;
import com.aerospike.helper.query.KeyRecordIterator;
import com.aerospike.helper.query.Qualifier;
import com.aerospike.helper.query.QueryEngine;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.support.PropertyComparator;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.aerospike.convert.AerospikeData;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.AerospikeOperations;
import org.springframework.data.aerospike.core.DefaultAerospikeExceptionTranslator;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.AerospikeSimpleTypes;
import org.springframework.data.aerospike.mapping.BasicAerospikePersistentEntity;
import org.springframework.data.aerospike.repository.query.AerospikeQueryCreator;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.keyvalue.core.KeyValueCallback;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.util.CloseableIterator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.comparator.CompoundComparator;

public class AerospikeTemplate
implements AerospikeOperations {
    private static final MappingAerospikeConverter DEFAULT_CONVERTER = new MappingAerospikeConverter();
    private static final AerospikeExceptionTranslator DEFAULT_EXCEPTION_TRANSLATOR = new DefaultAerospikeExceptionTranslator();
    private final MappingContext<BasicAerospikePersistentEntity<?>, AerospikePersistentProperty> mappingContext;
    private final AerospikeClient client;
    private final MappingAerospikeConverter converter;
    private final String namespace;
    private final QueryEngine queryEngine;
    private AerospikeExceptionTranslator exceptionTranslator;
    private WritePolicy insertPolicy;
    private WritePolicy updatePolicy;

    public AerospikeTemplate(AerospikeClient client, String namespace) {
        Assert.notNull((Object)client, (String)"Aerospike client must not be null!");
        Assert.notNull((Object)namespace, (String)"Namespace cannot be null");
        Assert.hasLength((String)namespace);
        this.client = client;
        this.converter = DEFAULT_CONVERTER;
        this.exceptionTranslator = DEFAULT_EXCEPTION_TRANSLATOR;
        this.namespace = namespace;
        this.mappingContext = new AerospikeMappingContext();
        this.insertPolicy = new WritePolicy(this.client.writePolicyDefault);
        this.updatePolicy = new WritePolicy(this.client.writePolicyDefault);
        this.insertPolicy.recordExistsAction = RecordExistsAction.CREATE_ONLY;
        this.updatePolicy.recordExistsAction = RecordExistsAction.UPDATE_ONLY;
        this.queryEngine = new QueryEngine(this.client);
        this.loggerSetup();
    }

    private void loggerSetup() {
        final Logger log = LoggerFactory.getLogger(AerospikeQueryCreator.class);
        Log.setCallback((Log.Callback)new Log.Callback(){

            public void log(Log.Level level, String message) {
                switch (level) {
                    case INFO: {
                        log.info("AS:" + message);
                        break;
                    }
                    case DEBUG: {
                        log.debug("AS:" + message);
                        break;
                    }
                    case ERROR: {
                        log.error("AS:" + message);
                        break;
                    }
                    case WARN: {
                        log.warn("AS:" + message);
                    }
                }
            }
        });
    }

    @Override
    public void insert(Serializable id, Object objectToInsert) {
        this.insert(id, objectToInsert, null);
    }

    @Override
    public void insert(Serializable id, Object objectToInsert, WritePolicy policy) {
        try {
            AerospikeData data = AerospikeData.forWrite(this.namespace);
            this.converter.write(objectToInsert, data);
            data.setID(id);
            Key key = data.getKey();
            Bin[] bins = data.getBinsAsArray();
            this.client.put(policy == null ? this.insertPolicy : policy, key, bins);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
    }

    @Override
    public <T> void createIndex(Class<T> domainType, String indexName, String binName, IndexType indexType) {
        IndexTask task = this.client.createIndex(null, this.namespace, domainType.getSimpleName(), indexName, binName, indexType);
        task.waitTillComplete();
    }

    @Override
    public <T> void save(Serializable id, Object objectToInsert, Class<T> domainType) {
        this.save(id, objectToInsert, domainType, null);
    }

    @Override
    public <T> void save(Serializable id, Object objectToInsert, Class<T> domainType, WritePolicy policy) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(domainType, (String)"Domain Type must not be null!");
        Assert.notNull((Object)objectToInsert, (String)"Object to insert must not be null!");
        try {
            AerospikeData data = AerospikeData.forWrite(this.namespace);
            this.converter.write(objectToInsert, data);
            data.setID(id);
            data.setSetName(AerospikeSimpleTypes.getColletionName(domainType));
            Key key = data.getKey();
            Bin[] bins = data.getBinsAsArray();
            this.client.put(policy, key, bins);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
    }

    @Override
    public <T> T findById(Serializable id, Class<T> type, Class<T> domainType) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(type, (String)"Class Type must not be null!");
        try {
            Key key = new Key(this.namespace, domainType.getSimpleName(), id.toString());
            AerospikeData data = AerospikeData.forRead(key, null);
            Record record = this.client.get(null, key);
            data.setRecord(record);
            return this.converter.read(type, data);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
    }

    @Override
    public void save(Serializable id, Object objectToInsert) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull((Object)objectToInsert, (String)"Object to insert must not be null!");
        try {
            AerospikeData data = AerospikeData.forWrite(this.namespace);
            this.converter.write(objectToInsert, data);
            data.setID(id);
            Key key = data.getKey();
            Bin[] bins = data.getBinsAsArray();
            this.client.put(null, key, bins);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
    }

    @Override
    public void save(Serializable id, Object objectToInsert, WritePolicy policy) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull((Object)objectToInsert, (String)"Object to insert must not be null!");
        try {
            AerospikeData data = AerospikeData.forWrite(this.namespace);
            this.converter.write(objectToInsert, data);
            data.setID(id);
            Key key = data.getKey();
            Bin[] bins = data.getBinsAsArray();
            this.client.put(policy, key, bins);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
    }

    public <T> void insertAll(Collection<? extends T> objectsToSave) {
        for (T element : objectsToSave) {
            if (element == null) continue;
            this.insert(element);
        }
    }

    @Override
    public <T> T insert(T objectToInsert) {
        return this.insert(objectToInsert, null);
    }

    @Override
    public <T> T insert(T objectToInsert, WritePolicy policy) {
        Assert.notNull(objectToInsert, (String)"Object to insert must not be null!");
        try {
            AerospikeData data = AerospikeData.forWrite(this.namespace);
            this.converter.write(objectToInsert, data);
            Key key = data.getKey();
            Bin[] bins = data.getBinsAsArray();
            this.client.put(policy == null ? this.insertPolicy : policy, key, bins);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
        return null;
    }

    @Override
    public void update(Object objectToUpdate) {
        this.update(objectToUpdate, null);
    }

    @Override
    public void update(Object objectToUpdate, WritePolicy policy) {
        Assert.notNull((Object)objectToUpdate, (String)"Object to update must not be null!");
        try {
            AerospikeData data = AerospikeData.forWrite(this.namespace);
            this.converter.write(objectToUpdate, data);
            Key key = data.getKey();
            Bin[] bins = data.getBinsAsArray();
            this.client.put(policy == null ? this.updatePolicy : policy, key, bins);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
    }

    @Override
    public void update(Serializable id, Object objectToUpdate) {
        this.update(id, objectToUpdate, null);
    }

    @Override
    public void update(Serializable id, Object objectToUpdate, WritePolicy policy) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull((Object)objectToUpdate, (String)"Object to update must not be null!");
        try {
            AerospikeData data = AerospikeData.forWrite(this.namespace);
            this.converter.write(objectToUpdate, data);
            data.setID(id);
            this.client.put(policy == null ? this.updatePolicy : policy, data.getKey(), data.getBinsAsArray());
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
    }

    @Override
    public void delete(Class<?> type) {
        try {
            ScanPolicy scanPolicy = new ScanPolicy();
            scanPolicy.includeBinData = false;
            final AtomicLong count = new AtomicLong();
            this.client.scanAll(scanPolicy, this.namespace, type.getSimpleName(), new ScanCallback(){

                public void scanCallback(Key key, Record record) throws AerospikeException {
                    if (AerospikeTemplate.this.client.delete(null, key)) {
                        count.addAndGet(1L);
                    }
                    if (count.get() % 10000L == 0L) {
                        System.out.println("Deleted " + count.get());
                    }
                }
            }, new String[0]);
            System.out.println("Deleted " + count + " records from set " + type.getSimpleName());
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
    }

    @Override
    public <T> T delete(Serializable id, Class<T> type) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        try {
            AerospikeData data = AerospikeData.forWrite(this.namespace);
            data.setID(id);
            data.setSetName(AerospikeSimpleTypes.getColletionName(type));
            this.client.delete(null, data.getKey());
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
        return null;
    }

    @Override
    public <T> T delete(T objectToDelete) {
        Assert.notNull(objectToDelete, (String)"Object to delete must not be null!");
        try {
            AerospikeData data = AerospikeData.forWrite(this.namespace);
            this.converter.write(objectToDelete, data);
            this.client.delete(null, data.getKey());
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> findAll(Class<T> type) {
        ArrayList<T> scanList = new ArrayList<T>();
        Iterable<T> results = this.findAllUsingQuery(type, null, null);
        try (Iterator<T> iterator = results.iterator();){
            while (iterator.hasNext()) {
                scanList.add(iterator.next());
            }
        }
        return scanList;
    }

    @Override
    public <T> T findOne(Serializable id, Class<T> type) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        return this.findById(id, type);
    }

    @Override
    public <T> T findById(Serializable id, Class<T> type) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        try {
            AerospikePersistentEntity entity = (AerospikePersistentEntity)this.converter.getMappingContext().getPersistentEntity(type);
            Key key = new Key(this.namespace, entity.getSetName(), id.toString());
            AerospikeData data = AerospikeData.forRead(key, null);
            Record record = this.client.get(null, key);
            data.setRecord(record);
            return this.converter.read(type, data);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
    }

    @Override
    public <T> Iterable<T> aggregate(Filter filter, Class<T> outputType, String module, String function, List<Value> arguments) {
        Assert.notNull(outputType, (String)"Output type must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.converter.getMappingContext().getPersistentEntity(outputType);
        Statement statement = new Statement();
        if (filter != null) {
            statement.setFilters(new Filter[]{filter});
        }
        statement.setSetName(entity.getSetName());
        statement.setNamespace(this.namespace);
        ResultSet resultSet = null;
        resultSet = arguments != null && arguments.size() > 0 ? this.client.queryAggregate(null, statement, module, function, arguments.toArray(new Value[0])) : this.client.queryAggregate(null, statement);
        return resultSet;
    }

    public void setExceptionTranslator(AerospikeExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator == null ? DEFAULT_EXCEPTION_TRANSLATOR : exceptionTranslator;
    }

    @Override
    public String getSetName(Class<?> entityClass) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.converter.getMappingContext().getPersistentEntity(entityClass);
        return entity.getSetName();
    }

    @Override
    public <T> Iterable<T> findAll(Sort sort, Class<T> type) {
        return null;
    }

    private String resolveKeySpace(Class<?> type) {
        return ((BasicAerospikePersistentEntity)this.mappingContext.getPersistentEntity(type)).getSetName();
    }

    private static boolean typeCheck(Class<?> requiredType, Object candidate) {
        return candidate == null ? true : ClassUtils.isAssignable(requiredType, candidate.getClass());
    }

    public boolean exists(Query<?> query, Class<?> entityClass) {
        if (query == null) {
            throw new InvalidDataAccessApiUsageException("Query passed in to exist can't be null");
        }
        Iterator<?> iterator = this.find(query, entityClass).iterator();
        return iterator.hasNext();
    }

    @Override
    public <T> T execute(KeyValueCallback<T> action) {
        Assert.notNull(action, (String)"KeyValueCallback must not be null!");
        return (T)action.doInKeyValue(null);
    }

    @Override
    public int count(Query<?> query, Class<?> type) {
        Assert.notNull(query, (String)"Query must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        int i = 0;
        Iterator<?> iterator = this.find(query, type).iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        return i;
    }

    @Override
    public <T> Iterable<T> find(Query<?> query, Class<T> type) {
        Assert.notNull(query, (String)"Query must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        List<Qualifier> qualifiers = null;
        Filter secondaryFilter = null;
        qualifiers = query.getQueryObject();
        if (qualifiers != null && qualifiers.size() > 0 && (secondaryFilter = qualifiers.get(0).asFilter()) != null) {
            qualifiers.remove(0);
        }
        Iterable<T> results = this.findAllUsingQuery(type, secondaryFilter, qualifiers.toArray(new Qualifier[qualifiers.size()]));
        List returnedList = IterableConverter.toList(results);
        if (results != null && query.getSort() != null) {
            Comparator<?> comparator = this.aerospikePropertyComparator(query);
            Collections.sort(returnedList, comparator);
        }
        return returnedList;
    }

    public Comparator<?> aerospikePropertyComparator(Query<?> query) {
        if (query == null || query.getSort() == null) {
            return null;
        }
        CompoundComparator compoundComperator = new CompoundComparator();
        for (Sort.Order order : query.getSort()) {
            if (Sort.Direction.DESC.equals((Object)order.getDirection())) {
                compoundComperator.addComparator((Comparator)new PropertyComparator(order.getProperty(), true, false));
                continue;
            }
            compoundComperator.addComparator((Comparator)new PropertyComparator(order.getProperty(), true, true));
        }
        return compoundComperator;
    }

    @Override
    public MappingContext<?, ?> getMappingContext() {
        return this.mappingContext;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public <T> Iterable<T> findInRange(int offset, int rows, Sort sort, Class<T> type) {
        Assert.notNull(type, (String)"Type for count must not be null!");
        final long rowCount = rows;
        final AtomicLong count = new AtomicLong(0L);
        Iterable<T> results = this.findAllUsingQuery(type, null, null);
        final Iterator<T> iterator = results.iterator();
        for (int skip = 0; skip < offset; ++skip) {
            if (!iterator.hasNext()) continue;
            iterator.next();
        }
        Iterable returnList = new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        if (count.get() == rowCount) {
                            ((EntityIterator)((Object)iterator)).close();
                            return false;
                        }
                        return iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        if (count.addAndGet(1L) <= rowCount) {
                            return iterator.next();
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
        return returnList;
    }

    @Override
    public long count(Class<?> type) {
        Assert.notNull(type, (String)"Type for count must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.converter.getMappingContext().getPersistentEntity(type);
        return this.count(type, entity.getSetName());
    }

    @Override
    public long count(Class<?> type, String setName) {
        Assert.notNull(type, (String)"Type for count must not be null!");
        Node[] nodes = this.client.getNodes();
        int replicationCount = 2;
        int nodeCount = nodes.length;
        int n_objects = 0;
        for (Node node : nodes) {
            String infoString = Info.request((Node)node, (String)("sets/" + this.namespace + "/" + setName));
            String n_objectsString = infoString.substring(infoString.indexOf("=") + 1, infoString.indexOf(":"));
            n_objects = Integer.parseInt(n_objectsString);
        }
        return nodeCount > 1 ? (long)(n_objects / replicationCount) : (long)n_objects;
    }

    protected <T> Iterable<T> findAllUsingQuery(Class<T> type, Filter filter, Qualifier ... qualifiers) {
        final Class<T> classType = type;
        Statement stmt = new Statement();
        stmt.setNamespace(this.namespace);
        stmt.setSetName(this.getSetName(type));
        Iterable results = null;
        final KeyRecordIterator recIterator = this.queryEngine.select(this.namespace, this.getSetName(type), filter, qualifiers);
        results = new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new EntityIterator(classType, AerospikeTemplate.this.converter, recIterator);
            }
        };
        return results;
    }

    @Override
    public <T> T prepend(T objectToPrependTo, String fieldName, String value) {
        Assert.notNull(objectToPrependTo, (String)"Object to prepend to must not be null!");
        T result = null;
        try {
            AerospikeData data = AerospikeData.forWrite(this.namespace);
            this.converter.write(objectToPrependTo, data);
            Record record = this.client.operate(null, data.getKey(), new Operation[]{Operation.prepend((Bin)new Bin(fieldName, value)), Operation.get((String)fieldName)});
            data.setRecord(record);
            result = (T)this.converter.read(objectToPrependTo, data);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
        return result;
    }

    @Override
    public <T> T prepend(T objectToPrependTo, Map<String, String> values) {
        Assert.notNull(objectToPrependTo, (String)"Object to prepend to must not be null!");
        T result = null;
        try {
            AerospikeData data = AerospikeData.forWrite(this.namespace);
            this.converter.write(objectToPrependTo, data);
            Operation[] ops = new Operation[values.size() + 1];
            int x = 0;
            for (Map.Entry<String, String> entry : values.entrySet()) {
                Bin newBin = new Bin(entry.getKey(), entry.getValue());
                ops[x] = Operation.prepend((Bin)newBin);
                ++x;
            }
            ops[x] = Operation.get();
            Record record = this.client.operate(null, data.getKey(), ops);
            data.setRecord(record);
            result = (T)this.converter.read(objectToPrependTo, data);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
        return result;
    }

    @Override
    public <T> T append(T objectToAppendTo, Map<String, String> values) {
        Assert.notNull(objectToAppendTo, (String)"Object to append to must not be null!");
        T result = null;
        try {
            AerospikeData data = AerospikeData.forWrite(this.namespace);
            this.converter.write(objectToAppendTo, data);
            Operation[] ops = new Operation[values.size() + 1];
            int x = 0;
            for (Map.Entry<String, String> entry : values.entrySet()) {
                Bin newBin = new Bin(entry.getKey(), entry.getValue());
                ops[x] = Operation.append((Bin)newBin);
                ++x;
            }
            ops[x] = Operation.get();
            Record record = this.client.operate(null, data.getKey(), ops);
            data.setRecord(record);
            result = (T)this.converter.read(objectToAppendTo, data);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
        return result;
    }

    @Override
    public <T> T append(T objectToAppendTo, String binName, String value) {
        Assert.notNull(objectToAppendTo, (String)"Object to append to must not be null!");
        T result = null;
        try {
            AerospikeData data = AerospikeData.forWrite(this.namespace);
            this.converter.write(objectToAppendTo, data);
            Record record = this.client.operate(null, data.getKey(), new Operation[]{Operation.append((Bin)new Bin(binName, value)), Operation.get((String)binName)});
            data.setRecord(record);
            result = (T)this.converter.read(objectToAppendTo, data);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
        return result;
    }

    @Override
    public <T> T add(T objectToAddTo, Map<String, Long> values) {
        Assert.notNull(objectToAddTo, (String)"Object to add to must not be null!");
        T result = null;
        try {
            AerospikeData data = AerospikeData.forWrite(this.namespace);
            this.converter.write(objectToAddTo, data);
            Operation[] operations = new Operation[values.size() + 1];
            int x = 0;
            for (Map.Entry<String, Long> entry : values.entrySet()) {
                Bin newBin = new Bin(entry.getKey(), (Object)entry.getValue());
                operations[x] = Operation.add((Bin)newBin);
                ++x;
            }
            operations[x] = Operation.get();
            Record record = this.client.operate(null, data.getKey(), operations);
            data.setRecord(record);
            result = (T)this.converter.read(objectToAddTo, data);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
        return result;
    }

    @Override
    public <T> T add(T objectToAddTo, String binName, int value) {
        Assert.notNull(objectToAddTo, (String)"Object to add to must not be null!");
        T result = null;
        try {
            AerospikeData data = AerospikeData.forWrite(this.namespace);
            this.converter.write(objectToAddTo, data);
            Record record = this.client.operate(null, data.getKey(), new Operation[]{Operation.add((Bin)new Bin(binName, value)), Operation.get()});
            data.setRecord(record);
            result = (T)this.converter.read(objectToAddTo, data);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
        return result;
    }

    public class EntityIterator<T>
    implements CloseableIterator<T> {
        private KeyRecordIterator keyRecordIterator;
        private MappingAerospikeConverter converter;
        private Class<T> type;

        public EntityIterator(Class<T> type, MappingAerospikeConverter converter, KeyRecordIterator keyRecordIterator) {
            this.converter = converter;
            this.type = type;
            this.keyRecordIterator = keyRecordIterator;
        }

        public boolean hasNext() {
            return this.keyRecordIterator.hasNext();
        }

        public T next() {
            KeyRecord keyRecord = this.keyRecordIterator.next();
            AerospikeData data = AerospikeData.forRead(keyRecord.key, null);
            data.setRecord(keyRecord.record);
            return this.converter.read(this.type, data);
        }

        public void close() {
            try {
                this.keyRecordIterator.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void remove() {
        }
    }
}

