/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.RecoverableDataAccessException;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.keyvalue.core.UncategorizedKeyValueException;

class DefaultAerospikeExceptionTranslator
implements AerospikeExceptionTranslator {
    DefaultAerospikeExceptionTranslator() {
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException cause) {
        if (cause instanceof AerospikeException) {
            int resultCode = ((AerospikeException)((Object)cause)).getResultCode();
            String msg = ((AerospikeException)((Object)cause)).getMessage();
            switch (resultCode) {
                case 5: {
                    return new DuplicateKeyException(msg, (Throwable)cause);
                }
            }
            return new RecoverableDataAccessException("Aerospike Error: " + cause.getMessage(), (Throwable)cause);
        }
        return new UncategorizedKeyValueException("Unexpected Aerospike Exception", (Throwable)cause);
    }
}

