/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.example;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.query.IndexType;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.data.aerospike.core.AerospikeOperations;
import org.springframework.data.aerospike.core.AerospikeTemplate;
import org.springframework.data.aerospike.example.PersonRepository;
import org.springframework.data.aerospike.example.config.TestRepositoryConfig;
import org.springframework.data.aerospike.example.data.Person;

public class RepositoryExample {
    @Autowired
    protected PersonRepository repository;
    @Autowired
    AerospikeOperations aerospikeOperations;
    @Autowired
    AerospikeClient client;

    public RepositoryExample(ApplicationContext ctx) {
        this.aerospikeOperations = (AerospikeOperations)ctx.getBean(AerospikeTemplate.class);
        this.repository = (PersonRepository)ctx.getBean("personRepository");
        this.client = (AerospikeClient)ctx.getBean(AerospikeClient.class);
    }

    protected void setUp() {
        this.repository.deleteAll();
        Person dave = new Person("Dave-01", "Matthews", 42);
        Person donny = new Person("Dave-02", "Macintire", 39);
        Person oliver = new Person("Oliver-01", "Matthews", 4);
        Person carter = new Person("Carter-01", "Beauford", 49);
        Person boyd = new Person("Boyd-01", "Tinsley", 45);
        Person stefan = new Person("Stefan-01", "Lessard", 34);
        Person leroi = new Person("Leroi-01", "Moore", 41);
        Person leroi2 = new Person("Leroi-02", "Moore", 25);
        Person alicia = new Person("Alicia-01", "Keys", 30);
        this.repository.createIndex(Person.class, "person_name_index", "name", IndexType.STRING);
        this.repository.save(Arrays.asList(oliver, dave, donny, carter, boyd, stefan, leroi, leroi2, alicia));
    }

    protected void cleanUp() {
        this.repository.deleteAll();
    }

    protected void executeRepositoryCall() {
        System.out.println("Results for name startting with letter 'M'");
        List<Person> resultPartial = this.repository.findByNameStartsWith("M");
        for (Person person : resultPartial) {
            System.out.println(person.toString());
        }
        List<Person> result = this.repository.findByName("Beauford");
        System.out.println("Results for exact match of 'Beauford'");
        for (Person person : result) {
            System.out.println(person.toString());
        }
    }

    public static void main(String[] args) {
        AnnotationConfigApplicationContext ctx = new AnnotationConfigApplicationContext(new Class[]{TestRepositoryConfig.class});
        RepositoryExample repositoryExample = new RepositoryExample((ApplicationContext)ctx);
        repositoryExample.executeRepositoryCall();
        repositoryExample.cleanUp();
    }
}

