/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.mapping;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.BasicAerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.CachingAerospikePersistentProperty;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;

public class AerospikeMappingContext
extends AbstractMappingContext<BasicAerospikePersistentEntity<?>, AerospikePersistentProperty>
implements ApplicationContextAware {
    private static final FieldNamingStrategy DEFAULT_NAMING_STRATEGY = PropertyNameFieldNamingStrategy.INSTANCE;
    private FieldNamingStrategy fieldNamingStrategy = DEFAULT_NAMING_STRATEGY;
    private ApplicationContext context;

    public void setFieldNamingStrategy(FieldNamingStrategy fieldNamingStrategy) {
        this.fieldNamingStrategy = fieldNamingStrategy == null ? DEFAULT_NAMING_STRATEGY : fieldNamingStrategy;
    }

    protected <T> BasicAerospikePersistentEntity<?> createPersistentEntity(TypeInformation<T> typeInformation) {
        BasicAerospikePersistentEntity<T> entity = new BasicAerospikePersistentEntity<T>(typeInformation);
        return entity;
    }

    protected AerospikePersistentProperty createPersistentProperty(Field field, PropertyDescriptor descriptor, BasicAerospikePersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        return new CachingAerospikePersistentProperty(field, descriptor, owner, simpleTypeHolder, this.fieldNamingStrategy);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

