/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.mapping;

import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.Field;
import org.springframework.data.annotation.Id;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.util.StringUtils;

public class BasicAerospikePersistentProperty
extends AnnotationBasedPersistentProperty<AerospikePersistentProperty>
implements AerospikePersistentProperty {
    private static final Logger LOG = LoggerFactory.getLogger(BasicAerospikePersistentProperty.class);
    private static final String ID_FIELD_NAME = "_id";
    private static final Set<Class<?>> SUPPORTED_ID_TYPES = new HashSet();
    private static final Set<String> SUPPORTED_ID_PROPERTY_NAMES = new HashSet<String>();
    private final FieldNamingStrategy fieldNamingStrategy;

    public BasicAerospikePersistentProperty(java.lang.reflect.Field field, PropertyDescriptor propertyDescriptor, PersistentEntity<?, AerospikePersistentProperty> owner, SimpleTypeHolder simpleTypeHolder, FieldNamingStrategy fieldNamingStrategy) {
        super(field, propertyDescriptor, owner, simpleTypeHolder);
        Object object = this.fieldNamingStrategy = fieldNamingStrategy == null ? PropertyNameFieldNamingStrategy.INSTANCE : fieldNamingStrategy;
        if (this.isIdProperty() && this.getFieldName() != ID_FIELD_NAME) {
            LOG.warn("Customizing field name for id property not allowed! Custom name will not be considered!");
        }
    }

    public boolean isIdProperty() {
        if (super.isIdProperty()) {
            return true;
        }
        return SUPPORTED_ID_PROPERTY_NAMES.contains(this.getName()) && !this.hasExplicitFieldName();
    }

    @Override
    public boolean isExplicitIdProperty() {
        return this.isAnnotationPresent(Id.class);
    }

    public String getFieldName() {
        if (this.isIdProperty()) {
            if (this.owner == null) {
                return ID_FIELD_NAME;
            }
            if (this.owner.getIdProperty() == null) {
                return ID_FIELD_NAME;
            }
            if (this.owner.isIdProperty((PersistentProperty)this)) {
                return ID_FIELD_NAME;
            }
        }
        if (this.hasExplicitFieldName()) {
            return this.getAnnotatedFieldName();
        }
        String fieldName = this.fieldNamingStrategy.getFieldName((PersistentProperty)this);
        if (!StringUtils.hasText((String)fieldName)) {
            throw new MappingException(String.format("Invalid (null or empty) field name returned for property %s by %s!", this, this.fieldNamingStrategy.getClass()));
        }
        return fieldName;
    }

    protected boolean hasExplicitFieldName() {
        return StringUtils.hasText((String)this.getAnnotatedFieldName());
    }

    private String getAnnotatedFieldName() {
        Field annotation = (Field)this.findAnnotation(Field.class);
        if (annotation != null && StringUtils.hasText((String)annotation.value())) {
            return annotation.value();
        }
        return null;
    }

    protected Association<AerospikePersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    static {
        SUPPORTED_ID_TYPES.add(String.class);
        SUPPORTED_ID_TYPES.add(Integer.class);
        SUPPORTED_ID_TYPES.add(Long.class);
        SUPPORTED_ID_TYPES.add(byte[].class);
        SUPPORTED_ID_TYPES.add(Map.class);
        SUPPORTED_ID_TYPES.add(List.class);
        SUPPORTED_ID_PROPERTY_NAMES.add("id");
        SUPPORTED_ID_PROPERTY_NAMES.add(ID_FIELD_NAME);
    }
}

