/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import java.lang.reflect.Constructor;
import org.springframework.beans.BeanUtils;
import org.springframework.data.aerospike.core.AerospikeOperations;
import org.springframework.data.aerospike.repository.query.Criteria;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.util.ClassUtils;

public class AerospikePartTreeQuery
implements RepositoryQuery {
    private final EvaluationContextProvider evaluationContextProvider;
    private final QueryMethod queryMethod;
    private final AerospikeOperations aerospikeOperations;
    private final Class<? extends AbstractQueryCreator<?, ?>> queryCreator;
    private Query<?> query;

    public AerospikePartTreeQuery(QueryMethod queryMethod, EvaluationContextProvider evalContextProvider, AerospikeOperations aerospikeOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        this.queryMethod = queryMethod;
        this.aerospikeOperations = aerospikeOperations;
        this.evaluationContextProvider = evalContextProvider;
        this.queryCreator = queryCreator;
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    public Object execute(Object[] parameters) {
        Query<?> query = this.prepareQuery(parameters);
        if (this.queryMethod.isPageQuery() || this.queryMethod.isSliceQuery()) {
            Pageable page = (Pageable)parameters[this.queryMethod.getParameters().getPageableIndex()];
            query.setOffset(page.getOffset());
            query.setRows(page.getPageSize());
            Iterable result = this.aerospikeOperations.find(query, this.queryMethod.getEntityInformation().getJavaType());
            long count = this.queryMethod.isSliceQuery() ? 0L : (long)this.aerospikeOperations.count(query, this.queryMethod.getEntityInformation().getJavaType());
            return new PageImpl(IterableConverter.toList(result), page, count);
        }
        if (this.queryMethod.isCollectionQuery()) {
            return this.aerospikeOperations.find(query, this.queryMethod.getEntityInformation().getJavaType());
        }
        if (this.queryMethod.isQueryForEntity()) {
            Iterable result = this.aerospikeOperations.find(query, this.queryMethod.getEntityInformation().getJavaType());
            return result.iterator().hasNext() ? result.iterator().next() : null;
        }
        throw new UnsupportedOperationException("Query method not supported.");
    }

    private Query<?> prepareQuery(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
        this.query = this.createQuery(accessor);
        Criteria criteria = (Criteria)this.query.getCritieria();
        Query q = new Query(criteria);
        if (accessor.getPageable() != null) {
            q.setOffset(accessor.getPageable().getOffset());
            q.setRows(accessor.getPageable().getPageSize());
        } else {
            q.setOffset(-1);
            q.setRows(-1);
        }
        if (accessor.getSort() != null) {
            q.setSort(accessor.getSort());
        } else {
            q.setSort(this.query.getSort());
        }
        if (q.getCritieria() instanceof SpelExpression) {
            EvaluationContext context = this.evaluationContextProvider.getEvaluationContext(this.getQueryMethod().getParameters(), parameters);
            ((SpelExpression)q.getCritieria()).setEvaluationContext(context);
        }
        return q;
    }

    public Query<?> createQuery(ParametersParameterAccessor accessor) {
        PartTree tree = new PartTree(this.getQueryMethod().getName(), this.getQueryMethod().getEntityInformation().getJavaType());
        Constructor constructor = ClassUtils.getConstructorIfAvailable(this.queryCreator, (Class[])new Class[]{PartTree.class, ParameterAccessor.class});
        return (Query)((AbstractQueryCreator)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{tree, accessor})).createQuery();
    }
}

