/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.CachingAerospikePersistentProperty;
import org.springframework.data.aerospike.repository.query.Criteria;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class AerospikeQueryCreator
extends AbstractQueryCreator<Query<?>, Criteria> {
    private static final Logger LOG = LoggerFactory.getLogger(AerospikeQueryCreator.class);
    private MappingContext<?, AerospikePersistentProperty> context;

    public AerospikeQueryCreator(PartTree tree, ParameterAccessor parameters) {
        super(tree, parameters);
        this.context = new AerospikeMappingContext();
    }

    public AerospikeQueryCreator(PartTree tree, ParameterAccessor parameters, MappingContext<?, AerospikePersistentProperty> context) {
        super(tree, parameters);
        this.context = context;
    }

    protected Criteria create(Part part, Iterator<Object> iterator) {
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        AerospikePersistentProperty property = (AerospikePersistentProperty)path.getLeafProperty();
        Criteria criteria = this.from(part, property, Criteria.where(path.toDotPath()), iterator);
        return criteria;
    }

    private Criteria from(Part part, AerospikePersistentProperty property, Criteria criteria, Iterator<?> parameters) {
        Part.Type type = part.getType();
        String fieldName = ((CachingAerospikePersistentProperty)property).getFieldName();
        Part.IgnoreCaseType ignoreCase = part.shouldIgnoreCase();
        switch (type) {
            case AFTER: 
            case GREATER_THAN: {
                return criteria.gt(parameters.next(), fieldName);
            }
            case GREATER_THAN_EQUAL: {
                return criteria.gte(parameters.next(), fieldName);
            }
            case BEFORE: 
            case LESS_THAN: {
                return criteria.lt(parameters.next(), fieldName);
            }
            case LESS_THAN_EQUAL: {
                return criteria.lte(parameters.next(), fieldName);
            }
            case BETWEEN: {
                return criteria.between(parameters.next(), parameters.next(), fieldName);
            }
            case IS_NOT_NULL: {
                return criteria.ne(null);
            }
            case IS_NULL: 
            case NOT_IN: {
                return null;
            }
            case IN: {
                return criteria.in(parameters.next());
            }
            case LIKE: 
            case STARTING_WITH: {
                return criteria.startingWith(parameters.next(), fieldName, ignoreCase);
            }
            case ENDING_WITH: {
                return null;
            }
            case CONTAINING: {
                return criteria.containing(parameters.next(), fieldName, ignoreCase);
            }
            case NOT_CONTAINING: {
                return null;
            }
            case REGEX: {
                return null;
            }
            case EXISTS: {
                return null;
            }
            case TRUE: 
            case FALSE: 
            case NEAR: {
                return null;
            }
            case WITHIN: {
                return criteria.geo_within(parameters.next(), parameters.next(), parameters.next(), fieldName);
            }
            case SIMPLE_PROPERTY: {
                return criteria.is(parameters.next(), fieldName);
            }
            case NEGATING_SIMPLE_PROPERTY: {
                return criteria.ne(parameters.next());
            }
        }
        throw new IllegalArgumentException("Unsupported keyword!");
    }

    protected Criteria and(Part part, Criteria base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, (Iterator)iterator);
        }
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        AerospikePersistentProperty property = (AerospikePersistentProperty)path.getLeafProperty();
        return this.from(part, property, base.and(path.toDotPath()), iterator);
    }

    protected Criteria or(Criteria base, Criteria criteria) {
        Criteria result = new Criteria();
        return result.orOperator(base, criteria);
    }

    protected Query<?> complete(Criteria criteria, Sort sort) {
        Query<?> query = (criteria == null ? new Query() : new Query(criteria)).with(sort);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created query " + query);
        }
        return query;
    }

    private boolean isSimpleComparisionPossible(Part part) {
        switch (part.shouldIgnoreCase()) {
            case NEVER: {
                return true;
            }
            case WHEN_POSSIBLE: {
                return part.getProperty().getType() != String.class;
            }
            case ALWAYS: {
                return false;
            }
        }
        return true;
    }
}

