/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import com.aerospike.helper.query.Qualifier;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.aerospike.InvalidAerospikeDataAccessApiUsageException;
import org.springframework.data.aerospike.repository.query.CriteriaDefinition;
import org.springframework.data.domain.Sort;

public class Query<T> {
    private Sort sort;
    private int offset = -1;
    private int rows = -1;
    private final Map<String, CriteriaDefinition> criteria = new LinkedHashMap<String, CriteriaDefinition>();

    public Query() {
    }

    public Query(CriteriaDefinition criteria) {
        this.addCriteria(criteria);
    }

    public Query<?> addCriteria(CriteriaDefinition criteriaDefinition) {
        CriteriaDefinition existing = this.criteria.get(criteriaDefinition.getKey());
        String key = criteriaDefinition.getKey();
        if (existing != null) {
            throw new InvalidAerospikeDataAccessApiUsageException("Due to limitations of the Filter, you can't add a second '" + key + "' criteria. " + "Query already contains '" + existing.getCriteriaObject() + "'.");
        }
        this.criteria.put(key, criteriaDefinition);
        return this;
    }

    public Query(Sort sort) {
        this.sort = sort;
    }

    public T getCritieria() {
        CriteriaDefinition value = null;
        for (Map.Entry<String, CriteriaDefinition> entry : this.criteria.entrySet()) {
            value = entry.getValue();
        }
        return (T)value;
    }

    public Sort getSort() {
        return this.sort;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getRows() {
        return this.rows;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public Query<T> orderBy(Sort sort) {
        if (sort == null) {
            return this;
        }
        if (this.sort != null) {
            this.sort.and(sort);
        } else {
            this.sort = sort;
        }
        return this;
    }

    public Query<T> skip(int offset) {
        this.setOffset(offset);
        return this;
    }

    public Query<T> limit(int rows) {
        this.setRows(rows);
        return this;
    }

    public Query<?> with(Sort sort) {
        if (sort == null) {
            return this;
        }
        for (Sort.Order order : sort) {
            if (!order.isIgnoreCase()) continue;
            throw new IllegalArgumentException(String.format("Given sort contained an Order for %s with ignore case! Aerospike does not support sorting ignoreing case currently!", order.getProperty()));
        }
        this.sort = this.sort == null ? sort : this.sort.and(sort);
        return this;
    }

    public List<Qualifier> getQueryObject() {
        List<Qualifier> qualifiers = null;
        for (String k : this.criteria.keySet()) {
            CriteriaDefinition c = this.criteria.get(k);
            qualifiers = c.getCriteriaObject();
        }
        return qualifiers;
    }
}

