/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.data.aerospike.core.AerospikeOperations;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.repository.query.AerospikePartTreeQuery;
import org.springframework.data.aerospike.repository.query.AerospikeQueryCreator;
import org.springframework.data.keyvalue.repository.support.QuerydslKeyValueRepository;
import org.springframework.data.keyvalue.repository.support.SimpleKeyValueRepository;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.QueryDslUtils;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.PersistentEntityInformation;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.util.Assert;

public class AerospikeRepositoryFactory
extends RepositoryFactorySupport {
    private static final Class<AerospikeQueryCreator> DEFAULT_QUERY_CREATOR = AerospikeQueryCreator.class;
    private final AerospikeOperations aerospikeOperations;
    private final MappingContext<? extends AerospikePersistentEntity<?>, AerospikePersistentProperty> context;
    private final Class<? extends AbstractQueryCreator<?, ?>> queryCreator;

    public AerospikeRepositoryFactory(AerospikeOperations aerospikeOperations) {
        this(aerospikeOperations, DEFAULT_QUERY_CREATOR);
    }

    public AerospikeRepositoryFactory(AerospikeOperations aerospikeOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        Assert.notNull((Object)aerospikeOperations, (String)"AerospikeOperations must not be null!");
        Assert.notNull(queryCreator, (String)"Query creator type must not be null!");
        this.queryCreator = queryCreator;
        this.aerospikeOperations = aerospikeOperations;
        this.context = aerospikeOperations.getMappingContext();
    }

    public <T, ID extends Serializable> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.context.getPersistentEntity(domainClass);
        if (entity == null) {
            throw new MappingException(String.format("Could not lookup mapping metadata for domain class %s!", domainClass.getName()));
        }
        return new PersistentEntityInformation((PersistentEntity)entity);
    }

    protected Object getTargetRepository(RepositoryInformation repositoryInformation) {
        EntityInformation entityInformation = this.getEntityInformation(repositoryInformation.getDomainType());
        return super.getTargetRepositoryViaReflection(repositoryInformation, new Object[]{entityInformation, this.aerospikeOperations});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return AerospikeRepositoryFactory.isQueryDslRepository(metadata.getRepositoryInterface()) ? QuerydslKeyValueRepository.class : SimpleKeyValueRepository.class;
    }

    private static boolean isQueryDslRepository(Class<?> repositoryInterface) {
        return QueryDslUtils.QUERY_DSL_PRESENT && QueryDslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key, EvaluationContextProvider evaluationContextProvider) {
        return new AerospikeQueryLookupStrategy(key, evaluationContextProvider, this.aerospikeOperations, this.queryCreator);
    }

    private static class AerospikeQueryLookupStrategy
    implements QueryLookupStrategy {
        private EvaluationContextProvider evaluationContextProvider;
        private AerospikeOperations aerospikeOperations;
        private Class<? extends AbstractQueryCreator<?, ?>> queryCreator;

        public AerospikeQueryLookupStrategy(QueryLookupStrategy.Key key, EvaluationContextProvider evaluationContextProvider, AerospikeOperations aerospikeOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
            Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null!");
            Assert.notNull((Object)aerospikeOperations, (String)"AerospikeOperations must not be null!");
            Assert.notNull(queryCreator, (String)"Query creator type must not be null!");
            this.evaluationContextProvider = evaluationContextProvider;
            this.aerospikeOperations = aerospikeOperations;
            this.queryCreator = queryCreator;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory pfactory, NamedQueries nquery) {
            QueryMethod queryMethod = new QueryMethod(method, metadata, pfactory);
            return new AerospikePartTreeQuery(queryMethod, this.evaluationContextProvider, this.aerospikeOperations, this.queryCreator);
        }
    }
}

