/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.support;

import com.aerospike.client.query.IndexType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.data.aerospike.core.AerospikeOperations;
import org.springframework.data.aerospike.repository.AerospikeRepository;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.util.Assert;

public class SimpleAerospikeRepository<T, ID extends Serializable>
implements AerospikeRepository<T, ID> {
    private final AerospikeOperations operations;
    private final EntityInformation<T, ID> entityInformation;

    public SimpleAerospikeRepository(EntityInformation<T, ID> metadata, AerospikeOperations operations) {
        this.entityInformation = metadata;
        this.operations = operations;
    }

    public T findOne(ID id) {
        return this.operations.findById((Serializable)id, this.entityInformation.getJavaType(), this.getDomainClass());
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity);
        this.operations.save(this.entityInformation.getId(entity), entity, this.getDomainClass());
        return entity;
    }

    public <S extends T> List<S> save(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null!");
        List<S> result = SimpleAerospikeRepository.convertIterableToList(entities);
        for (S entity : result) {
            this.save(entity);
        }
        return result;
    }

    public void delete(T entity) {
        this.operations.delete(entity);
    }

    public Class<T> getDomainClass() {
        return this.entityInformation.getJavaType();
    }

    static <T> List<T> convertIterableToList(Iterable<T> entities) {
        if (entities instanceof List) {
            return (List)entities;
        }
        int capacity = SimpleAerospikeRepository.tryDetermineRealSizeOrReturn(entities, 10);
        if (capacity == 0 || entities == null) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>(capacity);
        for (T entity : entities) {
            list.add(entity);
        }
        return list;
    }

    private static int tryDetermineRealSizeOrReturn(Iterable<?> iterable, int defaultSize) {
        return iterable == null ? 0 : (iterable instanceof Collection ? ((Collection)iterable).size() : defaultSize);
    }

    public Iterable<T> findAll(Sort sort) {
        return this.operations.findAll(sort, this.entityInformation.getJavaType());
    }

    public Page<T> findAll(Pageable pageable) {
        if (pageable == null) {
            Iterable result = this.findAll();
            return new PageImpl((List)result, null, (long)result.size());
        }
        Iterable content = this.operations.findInRange(pageable.getOffset(), pageable.getPageSize(), pageable.getSort(), this.entityInformation.getJavaType());
        return new PageImpl(IterableConverter.toList(content), pageable, this.operations.count(this.entityInformation.getJavaType(), this.getDomainClass().getSimpleName()));
    }

    public boolean exists(ID id) {
        return this.findOne(id) != null;
    }

    public List<T> findAll() {
        return IterableConverter.toList(this.operations.findAll(this.entityInformation.getJavaType()));
    }

    public Iterable<T> findAll(Iterable<ID> ids) {
        ArrayList<T> result = new ArrayList<T>();
        for (Serializable id : ids) {
            T candidate = this.findOne(id);
            if (candidate == null) continue;
            result.add(candidate);
        }
        return result;
    }

    public long count() {
        return this.operations.count(this.entityInformation.getJavaType());
    }

    public void delete(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        this.operations.delete((Serializable)id, this.entityInformation.getJavaType());
    }

    public void delete(Iterable<? extends T> entities) {
        for (T entity : entities) {
            this.delete((ID)entity);
        }
    }

    public void deleteAll() {
        this.operations.delete(this.entityInformation.getJavaType());
    }

    @Override
    public <T> void createIndex(Class<T> domainType, String indexName, String binName, IndexType indexType) {
        this.operations.createIndex(domainType, indexName, binName, indexType);
    }
}

