/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.convert;

import com.aerospike.client.Bin;
import com.aerospike.client.Value;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;

abstract class AerospikeConverters {
    private AerospikeConverters() {
    }

    public static enum StringToAerospikeGeoJSONValueConverter implements Converter<String, Value.GeoJSONValue>
    {
        INSTANCE;


        public Value.GeoJSONValue convert(String source) {
            return new Value.GeoJSONValue(source);
        }
    }

    public static enum BytesToValueConverter implements Converter<Byte[], Value>
    {
        INSTANCE;


        public Value convert(Byte[] source) {
            return source == null ? null : Value.get((Object)source);
        }
    }

    public static enum MapToValueConverter implements Converter<Map<?, ?>, Value>
    {
        INSTANCE;


        public Value convert(Map<?, ?> source) {
            return source == null ? null : Value.get(source);
        }
    }

    public static enum ListToValueConverter implements Converter<List<?>, Value>
    {
        INSTANCE;


        public Value convert(List<?> source) {
            return source == null ? null : Value.get(source);
        }
    }

    public static enum BinToStringConverter implements Converter<Bin, String>
    {
        INSTANCE;


        public String convert(Bin source) {
            return source.value.toString();
        }
    }

    public static enum StringToValueConverter implements Converter<String, Value>
    {
        INSTANCE;


        public Value convert(String source) {
            return source == null ? null : Value.get((String)source);
        }
    }

    public static enum BinToLongConverter implements Converter<Bin, Long>
    {
        INSTANCE;


        public Long convert(Bin source) {
            return source.value.toLong();
        }
    }

    public static enum LongToValueConverter implements Converter<Long, Value>
    {
        INSTANCE;


        public Value convert(Long source) {
            return source == null ? null : Value.get((Object)source);
        }
    }
}

