/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.convert;

import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.util.Assert;

class ConverterRegistration {
    private final SimpleTypeHolder simpleTypeHolder;
    private final GenericConverter.ConvertiblePair convertiblePair;
    private final boolean reading;
    private final boolean writing;

    public ConverterRegistration(SimpleTypeHolder simpleTypeHolder, GenericConverter.ConvertiblePair convertiblePair, boolean isReading, boolean isWriting) {
        this.simpleTypeHolder = simpleTypeHolder;
        Assert.notNull((Object)convertiblePair, (String)"ConvertiblePair must not be null!");
        this.convertiblePair = convertiblePair;
        this.reading = isReading;
        this.writing = isWriting;
    }

    public ConverterRegistration(SimpleTypeHolder simpleTypeHolder, Class<?> source, Class<?> target, boolean isReading, boolean isWriting) {
        this(simpleTypeHolder, new GenericConverter.ConvertiblePair(source, target), isReading, isWriting);
    }

    public boolean isWriting() {
        return this.writing || !this.reading && this.isSimpleTargetType();
    }

    public boolean isReading() {
        return this.reading || !this.writing && this.isSimpleSourceType();
    }

    public GenericConverter.ConvertiblePair getConvertiblePair() {
        return this.convertiblePair;
    }

    public boolean isSimpleSourceType() {
        return this.isAerospikeBasicType(this.convertiblePair.getSourceType());
    }

    public boolean isSimpleTargetType() {
        return this.isAerospikeBasicType(this.convertiblePair.getTargetType());
    }

    private boolean isAerospikeBasicType(Class<?> type) {
        return this.simpleTypeHolder.isSimpleType(type);
    }
}

