/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.convert;

import java.util.Arrays;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.aerospike.convert.AerospikeConverter;
import org.springframework.data.aerospike.convert.AerospikeReadData;
import org.springframework.data.aerospike.convert.AerospikeTypeAliasAccessor;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.convert.CustomConversions;
import org.springframework.data.aerospike.convert.MappingAerospikeReadConverter;
import org.springframework.data.aerospike.convert.MappingAerospikeWriteConverter;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.convert.DefaultTypeMapper;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.convert.SimpleTypeInformationMapper;
import org.springframework.data.convert.TypeAliasAccessor;
import org.springframework.data.convert.TypeMapper;
import org.springframework.data.mapping.context.MappingContext;

public class MappingAerospikeConverter
implements InitializingBean,
AerospikeConverter {
    private final CustomConversions conversions;
    private final GenericConversionService conversionService;
    private final MappingAerospikeReadConverter readConverter;
    private final MappingAerospikeWriteConverter writeConverter;

    public MappingAerospikeConverter(AerospikeMappingContext mappingContext, CustomConversions conversions, AerospikeTypeAliasAccessor aerospikeTypeAliasAccessor) {
        this.conversions = conversions;
        this.conversionService = new DefaultConversionService();
        EntityInstantiators entityInstantiators = new EntityInstantiators();
        DefaultTypeMapper typeMapper = new DefaultTypeMapper((TypeAliasAccessor)aerospikeTypeAliasAccessor, (MappingContext)mappingContext, Arrays.asList(new SimpleTypeInformationMapper()));
        this.writeConverter = new MappingAerospikeWriteConverter((TypeMapper<Map<String, Object>>)typeMapper, mappingContext, conversions, this.conversionService);
        this.readConverter = new MappingAerospikeReadConverter(entityInstantiators, (TypeMapper<Map<String, Object>>)typeMapper, mappingContext, conversions, this.conversionService);
    }

    public void afterPropertiesSet() {
        this.conversions.registerConvertersIn(this.conversionService);
    }

    @Override
    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public <R> R read(Class<R> type, AerospikeReadData data) {
        return this.readConverter.read(type, data);
    }

    public void write(Object source, AerospikeWriteData sink) {
        this.writeConverter.write(source, sink);
    }
}

