/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.convert;

import com.aerospike.client.Key;
import com.aerospike.client.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.aerospike.convert.AerospikeReadData;
import org.springframework.data.aerospike.convert.CustomConversions;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.utility.TimeUtils;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.convert.EntityReader;
import org.springframework.data.convert.TypeMapper;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class MappingAerospikeReadConverter
implements EntityReader<Object, AerospikeReadData> {
    private final EntityInstantiators entityInstantiators;
    private final TypeMapper<Map<String, Object>> typeMapper;
    private final AerospikeMappingContext mappingContext;
    private final CustomConversions conversions;
    private final GenericConversionService conversionService;

    public MappingAerospikeReadConverter(EntityInstantiators entityInstantiators, TypeMapper<Map<String, Object>> typeMapper, AerospikeMappingContext mappingContext, CustomConversions conversions, GenericConversionService conversionService) {
        this.entityInstantiators = entityInstantiators;
        this.typeMapper = typeMapper;
        this.mappingContext = mappingContext;
        this.conversions = conversions;
        this.conversionService = conversionService;
    }

    public <R> R read(Class<R> targetClass, AerospikeReadData data) {
        AerospikePersistentProperty expirationProperty;
        if (data == null) {
            return null;
        }
        Map<String, Object> record = data.getRecord();
        TypeInformation typeToUse = this.typeMapper.readType(record, (TypeInformation)ClassTypeInformation.from(targetClass));
        Class rawType = typeToUse.getType();
        if (this.conversions.hasCustomReadTarget(AerospikeReadData.class, rawType)) {
            return (R)this.conversionService.convert((Object)data, rawType);
        }
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getPersistentEntity(typeToUse);
        RecordReadingPropertyValueProvider propertyValueProvider = new RecordReadingPropertyValueProvider(data.getKey(), record);
        ConvertingPropertyAccessor accessor = this.getConvertingPropertyAccessor(entity, propertyValueProvider);
        AerospikePersistentProperty idProperty = (AerospikePersistentProperty)entity.getIdProperty();
        if (idProperty != null) {
            Object value = this.getIdValue(data.getKey(), record, idProperty);
            if (!idProperty.isImmutable() || !entity.isConstructorArgument(idProperty)) {
                accessor.setProperty((PersistentProperty)idProperty, value);
            }
        }
        if ((expirationProperty = entity.getExpirationProperty()) != null) {
            Object value = this.getExpiration(data, expirationProperty);
            accessor.setProperty((PersistentProperty)expirationProperty, value);
        }
        return this.convertProperties(entity, propertyValueProvider, (PersistentPropertyAccessor)accessor);
    }

    private <T> T getIdValue(Key key, Map<String, Object> data, AerospikePersistentProperty property) {
        Value userKey = key.userKey;
        Object value = userKey == null ? data.get("@user_key") : userKey.getObject();
        Assert.notNull((Object)value, (String)"Id must not be null!");
        return (T)this.convertIfNeeded(value, property.getType());
    }

    private <R> R convertProperties(AerospikePersistentEntity<?> entity, RecordReadingPropertyValueProvider propertyValueProvider, PersistentPropertyAccessor accessor) {
        entity.doWithProperties(persistentProperty -> {
            PreferredConstructor constructor = entity.getPersistenceConstructor();
            if (this.isNotReadable((PreferredConstructor<?, AerospikePersistentProperty>)constructor, (AerospikePersistentProperty)persistentProperty)) {
                return;
            }
            Object value = propertyValueProvider.getPropertyValue((AerospikePersistentProperty)persistentProperty);
            if (persistentProperty.getType().isPrimitive() && value == null) {
                return;
            }
            accessor.setProperty(persistentProperty, value);
        });
        return (R)accessor.getBean();
    }

    private boolean isNotReadable(PreferredConstructor<?, AerospikePersistentProperty> constructor, AerospikePersistentProperty property) {
        return constructor.isConstructorParameter((PersistentProperty)property) || property.isIdProperty() || property.isExpirationProperty();
    }

    private <T> T readValue(Object source, TypeInformation<?> propertyType) {
        Assert.notNull(propertyType, (String)"Target type must not be null!");
        if (source == null) {
            return null;
        }
        Class targetClass = propertyType.getType();
        if (this.conversions.hasCustomReadTarget(source.getClass(), targetClass)) {
            return (T)this.conversionService.convert(source, targetClass);
        }
        if (propertyType.isCollectionLike()) {
            return (T)this.convertCollection((Collection)source, propertyType);
        }
        if (propertyType.isMap()) {
            return (T)this.convertMap((Map)source, propertyType);
        }
        if (source instanceof Map) {
            return this.convertCustomType((Map)source, propertyType);
        }
        return (T)this.convertIfNeeded(source, targetClass);
    }

    private <T> T convertCustomType(Map<String, Object> source, TypeInformation<?> propertyType) {
        TypeInformation typeToUse = this.typeMapper.readType(source, propertyType);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getPersistentEntity(typeToUse);
        RecordReadingPropertyValueProvider propertyValueProvider = new RecordReadingPropertyValueProvider(source);
        ConvertingPropertyAccessor persistentPropertyAccessor = this.getConvertingPropertyAccessor(entity, propertyValueProvider);
        return (T)this.convertProperties(entity, propertyValueProvider, (PersistentPropertyAccessor)persistentPropertyAccessor);
    }

    private <R> R convertMap(Map<String, Object> source, TypeInformation<?> propertyType) {
        Class mapClass = propertyType.getType();
        TypeInformation keyType = propertyType.getComponentType();
        Class keyClass = keyType == null ? null : keyType.getType();
        TypeInformation mapValueType = propertyType.getMapValueType();
        Map converted = CollectionFactory.createMap((Class)mapClass, (Class)keyClass, (int)source.keySet().size());
        source.entrySet().forEach(e -> {
            Object key = keyClass != null ? this.conversionService.convert(e.getKey(), keyClass) : e.getKey();
            Object value = this.readValue(e.getValue(), mapValueType);
            converted.put(key, value);
        });
        return (R)this.convertIfNeeded(converted, propertyType.getType());
    }

    private <R> R convertCollection(Collection source, TypeInformation<?> propertyType) {
        Class collectionClass = propertyType.getType();
        TypeInformation elementType = propertyType.getComponentType();
        Class elementClass = elementType == null ? null : elementType.getType();
        ArrayList items = collectionClass.isArray() ? new ArrayList() : CollectionFactory.createCollection((Class)collectionClass, (Class)elementClass, (int)source.size());
        source.forEach(item -> items.add(this.readValue(item, elementType)));
        return (R)this.convertIfNeeded(items, propertyType.getType());
    }

    private Object convertIfNeeded(Object value, Class<?> targetClass) {
        if (Enum.class.isAssignableFrom(targetClass)) {
            return Enum.valueOf(targetClass, value.toString());
        }
        return targetClass.isAssignableFrom(value.getClass()) ? value : this.conversionService.convert(value, targetClass);
    }

    private ConvertingPropertyAccessor getConvertingPropertyAccessor(AerospikePersistentEntity<?> entity, RecordReadingPropertyValueProvider recordReadingPropertyValueProvider) {
        EntityInstantiator instantiator = this.entityInstantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, (ParameterValueProvider)new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)recordReadingPropertyValueProvider, null));
        return new ConvertingPropertyAccessor(entity.getPropertyAccessor(instance), (ConversionService)this.conversionService);
    }

    private Object getExpiration(AerospikeReadData data, AerospikePersistentProperty expirationProperty) {
        if (expirationProperty.isExpirationSpecifiedAsUnixTime()) {
            return TimeUtils.offsetInSecondsToUnixTime(data.getExpiration());
        }
        return data.getExpiration();
    }

    private class RecordReadingPropertyValueProvider
    implements PropertyValueProvider<AerospikePersistentProperty> {
        private final Key key;
        private final Map<String, Object> source;

        public RecordReadingPropertyValueProvider(Key key, Map<String, Object> source) {
            this.key = key;
            this.source = source;
        }

        public RecordReadingPropertyValueProvider(Map<String, Object> source) {
            this(null, source);
        }

        public <T> T getPropertyValue(AerospikePersistentProperty property) {
            if (this.key != null && property.isIdProperty()) {
                return (T)MappingAerospikeReadConverter.this.getIdValue(this.key, this.source, property);
            }
            Object value = this.source.get(property.getFieldName());
            return (T)MappingAerospikeReadConverter.this.readValue(value, property.getTypeInformation());
        }
    }
}

