/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Info;
import com.aerospike.client.Key;
import com.aerospike.client.Log;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.GenerationPolicy;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.IndexType;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.ResultSet;
import com.aerospike.client.query.Statement;
import com.aerospike.client.task.IndexTask;
import com.aerospike.helper.query.KeyRecordIterator;
import com.aerospike.helper.query.Qualifier;
import com.aerospike.helper.query.QueryEngine;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.support.PropertyComparator;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.aerospike.convert.AerospikeReadData;
import org.springframework.data.aerospike.convert.AerospikeTypeAliasAccessor;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.convert.CustomConversions;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.AerospikeOperations;
import org.springframework.data.aerospike.core.DefaultAerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.OperationUtils;
import org.springframework.data.aerospike.core.WritePolicyBuilder;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.AerospikeSimpleTypes;
import org.springframework.data.aerospike.mapping.BasicAerospikePersistentEntity;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.util.StreamUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.comparator.CompoundComparator;

public class AerospikeTemplate
implements AerospikeOperations {
    private static final Logger log = LoggerFactory.getLogger(AerospikeTemplate.class);
    private final MappingContext<BasicAerospikePersistentEntity<?>, AerospikePersistentProperty> mappingContext;
    private final AerospikeClient client;
    private final MappingAerospikeConverter converter;
    private final String namespace;
    private final QueryEngine queryEngine;
    private final AerospikeExceptionTranslator exceptionTranslator;

    public AerospikeTemplate(AerospikeClient client, String namespace, MappingAerospikeConverter converter, AerospikeMappingContext mappingContext, AerospikeExceptionTranslator exceptionTranslator) {
        Assert.notNull((Object)client, (String)"Aerospike client must not be null!");
        Assert.notNull((Object)namespace, (String)"Namespace cannot be null");
        Assert.hasLength((String)namespace, (String)"Namespace cannot be empty");
        this.client = client;
        this.converter = converter;
        this.exceptionTranslator = exceptionTranslator;
        this.namespace = namespace;
        this.mappingContext = mappingContext;
        this.queryEngine = new QueryEngine(this.client);
        this.loggerSetup();
    }

    @Deprecated
    public AerospikeTemplate(AerospikeClient client, String namespace) {
        Assert.notNull((Object)client, (String)"Aerospike client must not be null!");
        Assert.notNull((Object)namespace, (String)"Namespace cannot be null");
        Assert.hasLength((String)namespace, (String)"Namespace cannot be empty");
        CustomConversions customConversions = new CustomConversions(Collections.emptyList(), AerospikeSimpleTypes.HOLDER);
        AerospikeMappingContext asContext = new AerospikeMappingContext();
        asContext.setDefaultNameSpace(namespace);
        this.client = client;
        this.converter = new MappingAerospikeConverter(asContext, customConversions, new AerospikeTypeAliasAccessor());
        this.exceptionTranslator = new DefaultAerospikeExceptionTranslator();
        this.namespace = namespace;
        this.mappingContext = asContext;
        this.queryEngine = new QueryEngine(this.client);
        this.converter.afterPropertiesSet();
        this.loggerSetup();
    }

    private void loggerSetup() {
        Logger log = LoggerFactory.getLogger((String)"com.aerospike.client");
        Log.setCallback((level, message) -> {
            switch (level) {
                case INFO: {
                    log.info("{}", (Object)message);
                    break;
                }
                case DEBUG: {
                    log.debug("{}", (Object)message);
                    break;
                }
                case ERROR: {
                    log.error("{}", (Object)message);
                    break;
                }
                case WARN: {
                    log.warn("{}", (Object)message);
                }
            }
        });
    }

    @Override
    public <T> void createIndex(Class<T> domainType, String indexName, String binName, IndexType indexType) {
        try {
            String setName = this.getSetName(domainType);
            IndexTask task = this.client.createIndex(null, this.namespace, setName, indexName, binName, indexType);
            if (task != null) {
                task.waitTillComplete();
            }
            this.queryEngine.refreshIndexes();
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    @Override
    public <T> void deleteIndex(Class<T> domainType, String indexName) {
        try {
            String setName = this.getSetName(domainType);
            IndexTask task = this.client.dropIndex(null, this.namespace, setName, indexName);
            if (task != null) {
                task.waitTillComplete();
            }
            this.queryEngine.refreshIndexes();
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    @Override
    public boolean indexExists(String indexName) {
        try {
            Node[] nodes = this.client.getNodes();
            if (nodes.length == 0) {
                throw new AerospikeException(-8, "Command failed because cluster is empty.");
            }
            Node node = nodes[0];
            String response = Info.request((Node)node, (String)("sindex/" + this.namespace + '/' + indexName));
            return !response.startsWith("FAIL:201");
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    @Override
    public void save(Object document) {
        Assert.notNull((Object)document, (String)"Object to insert must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            this.doPersistWithCas(document, entity);
        } else {
            WritePolicyBuilder builder = WritePolicyBuilder.builder(this.client.writePolicyDefault).sendKey(true).recordExistsAction(RecordExistsAction.UPDATE);
            this.doPersist(document, builder);
        }
    }

    @Override
    public void persist(Object document, WritePolicy policy) {
        Assert.notNull((Object)document, (String)"Document must not be null!");
        Assert.notNull((Object)policy, (String)"Policy must not be null!");
        try {
            AerospikeWriteData data = AerospikeWriteData.forWrite();
            this.converter.write(document, data);
            Key key = data.getKey();
            Bin[] bins = data.getBinsAsArray();
            this.client.put(policy, key, bins);
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    public <T> void insertAll(Collection<? extends T> documents) {
        Assert.notNull(documents, (String)"Documents must not be null!");
        documents.stream().filter(Objects::nonNull).forEach(this::insert);
    }

    @Override
    public void insert(Object document) {
        Assert.notNull((Object)document, (String)"Document must not be null!");
        WritePolicyBuilder writePolicyBuilder = WritePolicyBuilder.builder(this.client.writePolicyDefault).sendKey(true).recordExistsAction(RecordExistsAction.CREATE_ONLY);
        this.doPersist(document, writePolicyBuilder);
    }

    @Override
    public void update(Object document) {
        Assert.notNull((Object)document, (String)"Document must not be null!");
        WritePolicyBuilder writePolicyBuilder = WritePolicyBuilder.builder(this.client.writePolicyDefault).sendKey(true).recordExistsAction(RecordExistsAction.UPDATE_ONLY);
        this.doPersist(document, writePolicyBuilder);
    }

    @Override
    public void delete(Class<?> type) {
        try {
            String set = this.getSetName(type);
            this.client.truncate(null, this.getNamespace(), set, null);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
    }

    @Override
    public boolean delete(Object id, Class<?> type) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        try {
            AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
            Key key = this.getKey(id, entity);
            return this.client.delete(null, key);
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    @Override
    public boolean delete(Object objectToDelete) {
        Assert.notNull((Object)objectToDelete, (String)"Object to delete must not be null!");
        try {
            AerospikeWriteData data = AerospikeWriteData.forWrite();
            this.converter.write(objectToDelete, data);
            return this.client.delete(null, data.getKey());
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    @Override
    public boolean exists(Object id, Class<?> type) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        try {
            AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
            Key key = this.getKey(id, entity);
            Record record = this.client.operate(null, key, new Operation[]{Operation.getHeader()});
            return record != null;
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    @Override
    public <T> Stream<T> findAll(Class<T> type) {
        return this.findAllUsingQuery(type, null, null);
    }

    @Override
    public <T> T findById(Object id, Class<T> type) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        try {
            Record record;
            AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
            Key key = this.getKey(id, entity);
            if (entity.isTouchOnRead()) {
                Assert.state((!entity.hasExpirationProperty() ? 1 : 0) != 0, (String)"Touch on read is not supported for expiration property");
                record = this.getAndTouch(key, entity.getExpiration());
            } else {
                record = this.client.get(null, key);
            }
            return this.mapToEntity(key, type, record);
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    private Record getAndTouch(Key key, int expiration) {
        WritePolicy writePolicy = new WritePolicy(this.client.writePolicyDefault);
        writePolicy.expiration = expiration;
        if (this.client.exists(null, key)) {
            return this.client.operate(writePolicy, key, new Operation[]{Operation.touch(), Operation.get()});
        }
        return null;
    }

    @Override
    public <T> List<T> findByIds(Iterable<?> ids, Class<T> type) {
        Assert.notNull(ids, (String)"List of ids must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        return this.findByIdsInternal(IterableConverter.toList(ids), type);
    }

    private <T> List<T> findByIdsInternal(Collection<?> ids, Class<T> type) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
            Key[] keys = (Key[])ids.stream().map(id -> this.getKey(id, entity)).toArray(Key[]::new);
            Record[] records = this.client.get(null, keys);
            return IntStream.range(0, keys.length).filter(index -> records[index] != null).mapToObj(index -> this.mapToEntity(keys[index], type, records[index])).collect(Collectors.toList());
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    @Override
    public <T> Iterable<T> aggregate(Filter filter, Class<T> outputType, String module, String function, List<Value> arguments) {
        Assert.notNull(outputType, (String)"Output type must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(outputType);
        Statement statement = new Statement();
        if (filter != null) {
            statement.setFilter(filter);
        }
        statement.setSetName(entity.getSetName());
        statement.setNamespace(this.namespace);
        ResultSet resultSet = null;
        resultSet = arguments != null && arguments.size() > 0 ? this.client.queryAggregate(null, statement, module, function, arguments.toArray(new Value[0])) : this.client.queryAggregate(null, statement);
        return resultSet;
    }

    @Override
    public String getSetName(Class<?> entityClass) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        return entity.getSetName();
    }

    @Override
    public <T> Iterable<T> findAll(Sort sort, Class<T> type) {
        throw new UnsupportedOperationException("not implemented");
    }

    private static boolean typeCheck(Class<?> requiredType, Object candidate) {
        return candidate == null || ClassUtils.isAssignable(requiredType, candidate.getClass());
    }

    public boolean exists(Query query, Class<?> entityClass) {
        Assert.notNull((Object)query, (String)"Query passed in to exist can't be null");
        return this.find(query, entityClass).findAny().isPresent();
    }

    @Override
    public <T> T execute(Supplier<T> supplier) {
        Assert.notNull(supplier, (String)"Callback must not be null!");
        try {
            return supplier.get();
        }
        catch (RuntimeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible(e);
            throw translatedException == null ? e : translatedException;
        }
    }

    @Override
    public long count(Query query, Class<?> type) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        Qualifier qualifier = query.getCriteria().getCriteriaObject();
        Stream<KeyRecord> results = this.findAllRecordsUsingQuery(type, null, qualifier);
        return results.count();
    }

    @Override
    public <T> Stream<T> find(Query query, Class<T> type) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        if ((query.getSort() == null || query.getSort().isUnsorted()) && query.getOffset() > 0L) {
            throw new IllegalArgumentException("Unsorted query must not have offset value. For retrieving paged results use sorted query.");
        }
        Qualifier qualifier = query.getCriteria().getCriteriaObject();
        Stream<?> results = this.findAllUsingQuery(type, null, qualifier);
        if (query.getSort() != null && query.getSort().isSorted()) {
            Comparator<?> comparator = this.getComparator(query);
            results = results.sorted(comparator);
        }
        if (query.hasOffset()) {
            results = results.skip(query.getOffset());
        }
        if (query.hasRows()) {
            results = results.limit(query.getRows());
        }
        return results;
    }

    private Comparator<?> getComparator(Query query) {
        CompoundComparator compoundComperator = new CompoundComparator();
        for (Sort.Order order : query.getSort()) {
            if (Sort.Direction.DESC.equals((Object)order.getDirection())) {
                compoundComperator.addComparator((Comparator)new PropertyComparator(order.getProperty(), true, false));
                continue;
            }
            compoundComperator.addComparator((Comparator)new PropertyComparator(order.getProperty(), true, true));
        }
        return compoundComperator;
    }

    @Override
    public MappingContext<?, ?> getMappingContext() {
        return this.mappingContext;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public <T> Stream<T> findInRange(long offset, long limit, Sort sort, Class<T> type) {
        Assert.notNull(type, (String)"Type for count must not be null!");
        Stream<T> results = this.findAllUsingQuery(type, null, null);
        return results.skip(offset).limit(limit);
    }

    @Override
    public long count(Class<?> type) {
        Assert.notNull(type, (String)"Type for count must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
        return this.count(type, entity.getSetName());
    }

    @Override
    public AerospikeClient getAerospikeClient() {
        return this.client;
    }

    @Override
    public long count(Class<?> type, String setName) {
        Assert.notNull(type, (String)"Type for count must not be null!");
        Node[] nodes = this.client.getNodes();
        int replicationCount = 2;
        int nodeCount = nodes.length;
        int n_objects = 0;
        for (Node node : nodes) {
            String infoString = Info.request((Node)node, (String)("sets/" + this.namespace + "/" + setName));
            String n_objectsString = infoString.substring(infoString.indexOf("=") + 1, infoString.indexOf(":"));
            n_objects = Integer.parseInt(n_objectsString);
        }
        return nodeCount > 1 ? (long)(n_objects / replicationCount) : (long)n_objects;
    }

    protected <T> Stream<T> findAllUsingQuery(Class<T> type, Filter filter, Qualifier ... qualifiers) {
        return this.findAllRecordsUsingQuery(type, filter, qualifiers).map(keyRecord -> this.mapToEntity(keyRecord.key, type, keyRecord.record));
    }

    private <T> Stream<KeyRecord> findAllRecordsUsingQuery(Class<T> type, Filter filter, Qualifier ... qualifiers) {
        String setName = this.getSetName(type);
        KeyRecordIterator recIterator = this.queryEngine.select(this.namespace, setName, filter, qualifiers);
        return (Stream)StreamUtils.createStreamFromIterator((Iterator)recIterator).onClose(() -> {
            try {
                recIterator.close();
            }
            catch (Exception e) {
                log.error("Caught exception while closing query", (Throwable)e);
            }
        });
    }

    @Override
    public <T> T prepend(T objectToPrependTo, String fieldName, String value) {
        Assert.notNull(objectToPrependTo, (String)"Object to prepend to must not be null!");
        try {
            AerospikeWriteData data = AerospikeWriteData.forWrite();
            this.converter.write(objectToPrependTo, data);
            Record record = this.client.operate(null, data.getKey(), new Operation[]{Operation.prepend((Bin)new Bin(fieldName, value)), Operation.get((String)fieldName)});
            return (T)this.mapToEntity(data.getKey(), objectToPrependTo.getClass(), record);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
    }

    @Override
    public <T> T prepend(T objectToPrependTo, Map<String, String> values) {
        Assert.notNull(objectToPrependTo, (String)"Object to prepend to must not be null!");
        try {
            AerospikeWriteData data = AerospikeWriteData.forWrite();
            this.converter.write(objectToPrependTo, data);
            Operation[] ops = new Operation[values.size() + 1];
            int x = 0;
            for (Map.Entry<String, String> entry : values.entrySet()) {
                Bin newBin = new Bin(entry.getKey(), entry.getValue());
                ops[x] = Operation.prepend((Bin)newBin);
                ++x;
            }
            ops[x] = Operation.get();
            Record record = this.client.operate(null, data.getKey(), ops);
            return (T)this.mapToEntity(data.getKey(), objectToPrependTo.getClass(), record);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
    }

    @Override
    public <T> T append(T objectToAppendTo, Map<String, String> values) {
        Assert.notNull(objectToAppendTo, (String)"Object to append to must not be null!");
        try {
            AerospikeWriteData data = AerospikeWriteData.forWrite();
            this.converter.write(objectToAppendTo, data);
            Operation[] ops = new Operation[values.size() + 1];
            int x = 0;
            for (Map.Entry<String, String> entry : values.entrySet()) {
                Bin newBin = new Bin(entry.getKey(), entry.getValue());
                ops[x] = Operation.append((Bin)newBin);
                ++x;
            }
            ops[x] = Operation.get();
            Record record = this.client.operate(null, data.getKey(), ops);
            return (T)this.mapToEntity(data.getKey(), objectToAppendTo.getClass(), record);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
    }

    @Override
    public <T> T append(T objectToAppendTo, String binName, String value) {
        Assert.notNull(objectToAppendTo, (String)"Object to append to must not be null!");
        try {
            AerospikeWriteData data = AerospikeWriteData.forWrite();
            this.converter.write(objectToAppendTo, data);
            Record record = this.client.operate(null, data.getKey(), new Operation[]{Operation.append((Bin)new Bin(binName, value)), Operation.get((String)binName)});
            return (T)this.mapToEntity(data.getKey(), objectToAppendTo.getClass(), record);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
    }

    @Override
    public <T> T add(T objectToAddTo, Map<String, Long> values) {
        Assert.notNull(objectToAddTo, (String)"Object to add to must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        try {
            AerospikeWriteData data = AerospikeWriteData.forWrite();
            this.converter.write(objectToAddTo, data);
            Operation[] operations = new Operation[values.size() + 1];
            int x = 0;
            for (Map.Entry<String, Long> entry : values.entrySet()) {
                Bin newBin = new Bin(entry.getKey(), (Object)entry.getValue());
                operations[x] = Operation.add((Bin)newBin);
                ++x;
            }
            operations[x] = Operation.get();
            WritePolicy writePolicy = new WritePolicy(this.client.writePolicyDefault);
            writePolicy.expiration = data.getExpiration();
            Record record = this.client.operate(writePolicy, data.getKey(), operations);
            return (T)this.mapToEntity(data.getKey(), objectToAddTo.getClass(), record);
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    @Override
    public <T> T add(T objectToAddTo, String binName, long value) {
        Assert.notNull(objectToAddTo, (String)"Object to add to must not be null!");
        Assert.notNull((Object)binName, (String)"Bin name must not be null!");
        try {
            AerospikeWriteData data = AerospikeWriteData.forWrite();
            this.converter.write(objectToAddTo, data);
            WritePolicy writePolicy = new WritePolicy(this.client.writePolicyDefault);
            writePolicy.expiration = data.getExpiration();
            Record record = this.client.operate(writePolicy, data.getKey(), new Operation[]{Operation.add((Bin)new Bin(binName, value)), Operation.get()});
            return (T)this.mapToEntity(data.getKey(), objectToAddTo.getClass(), record);
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    private <T> T mapToEntity(Key key, Class<T> type, Record record) {
        if (record == null) {
            return null;
        }
        AerospikeReadData data = AerospikeReadData.forRead(key, record);
        T readEntity = this.converter.read(type, data);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
        if (entity.hasVersionProperty()) {
            ConvertingPropertyAccessor<T> accessor = this.getPropertyAccessor(entity, readEntity);
            accessor.setProperty(entity.getVersionProperty(), (Object)record.generation);
        }
        return readEntity;
    }

    private <T> ConvertingPropertyAccessor<T> getPropertyAccessor(AerospikePersistentEntity<?> entity, T source) {
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(source);
        return new ConvertingPropertyAccessor(accessor, this.converter.getConversionService());
    }

    private void doPersist(Object document, WritePolicyBuilder policyBuilder) {
        try {
            AerospikeWriteData data = AerospikeWriteData.forWrite();
            this.converter.write(document, data);
            Key key = data.getKey();
            Bin[] bins = data.getBinsAsArray();
            WritePolicy policy = policyBuilder.expiration(data.getExpiration()).build();
            this.client.put(policy, key, bins);
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    private void doPersistWithCas(Object document, AerospikePersistentEntity<?> entity) {
        try {
            AerospikeWriteData data = AerospikeWriteData.forWrite();
            this.converter.write(document, data);
            Key key = data.getKey();
            Bin[] bins = data.getBinsAsArray();
            ConvertingPropertyAccessor<Object> accessor = this.getPropertyAccessor(entity, document);
            WritePolicy policy = this.getCasAwareWritePolicy(data, entity, accessor);
            Operation[] operations = OperationUtils.operations(bins, Operation::put, Operation.getHeader());
            Record newRecord = this.client.operate(policy, key, operations);
            accessor.setProperty(entity.getVersionProperty(), (Object)newRecord.generation);
        }
        catch (AerospikeException e) {
            int code = e.getResultCode();
            if (code == 5 || code == 3) {
                throw new OptimisticLockingFailureException("Save document with version value failed", (Throwable)e);
            }
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    private WritePolicy getCasAwareWritePolicy(AerospikeWriteData data, AerospikePersistentEntity<?> entity, ConvertingPropertyAccessor<?> accessor) {
        boolean existingDocument;
        WritePolicyBuilder builder = WritePolicyBuilder.builder(this.client.writePolicyDefault).sendKey(true).generationPolicy(GenerationPolicy.EXPECT_GEN_EQUAL).expiration(data.getExpiration());
        Integer version = (Integer)accessor.getProperty(entity.getVersionProperty(), Integer.class);
        boolean bl = existingDocument = version != null && (long)version.intValue() > 0L;
        if (existingDocument) {
            builder.recordExistsAction(RecordExistsAction.REPLACE_ONLY).generation(version);
        } else {
            builder.recordExistsAction(RecordExistsAction.CREATE_ONLY);
        }
        return builder.build();
    }

    private Key getKey(Object id, AerospikePersistentEntity<?> entity) {
        return new Key(this.namespace, entity.getSetName(), id.toString());
    }
}

