/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.config;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.aerospike.repository.config.EnableAerospikeRepositories;
import org.springframework.data.aerospike.repository.query.AerospikeQueryCreator;
import org.springframework.data.keyvalue.repository.config.KeyValueRepositoryConfigurationExtension;
import org.springframework.data.keyvalue.repository.config.QueryCreatorType;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryBeanDefinitionRegistrarSupport;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;

public class AerospikeRepositoriesRegistrar
extends RepositoryBeanDefinitionRegistrarSupport {
    protected Class<? extends Annotation> getAnnotation() {
        return EnableAerospikeRepositories.class;
    }

    protected RepositoryConfigurationExtension getExtension() {
        return new AerospikeRepositoryConfigurationExtension();
    }

    private static Class<?> getQueryCreatorType(AnnotationRepositoryConfigurationSource config) {
        AnnotationMetadata metadata = config.getEnableAnnotationMetadata();
        Map queryCreatorFoo = metadata.getAnnotationAttributes(QueryCreatorType.class.getName());
        if (queryCreatorFoo == null) {
            return AerospikeQueryCreator.class;
        }
        AnnotationAttributes queryCreatorAttributes = new AnnotationAttributes(queryCreatorFoo);
        return queryCreatorAttributes.getClass("value");
    }

    private static class AerospikeRepositoryConfigurationExtension
    extends KeyValueRepositoryConfigurationExtension {
        private AerospikeRepositoryConfigurationExtension() {
        }

        public String getModuleName() {
            return "Aerospike";
        }

        protected String getModulePrefix() {
            return "aerospike";
        }

        protected String getDefaultKeyValueTemplateRef() {
            return "aerospikeTemplate";
        }

        public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
            AnnotationAttributes attributes = config.getAttributes();
            builder.addPropertyReference("operations", attributes.getString("keyValueTemplateRef"));
            builder.addPropertyValue("queryCreator", (Object)AerospikeRepositoriesRegistrar.getQueryCreatorType(config));
            builder.addPropertyReference("mappingContext", "keyValueMappingContext");
        }
    }
}

