/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import java.lang.reflect.Constructor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.BeanUtils;
import org.springframework.data.aerospike.core.AerospikeOperations;
import org.springframework.data.aerospike.repository.query.AerospikeCriteria;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.util.ClassUtils;

public class AerospikePartTreeQuery
implements RepositoryQuery {
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    private final QueryMethod queryMethod;
    private final AerospikeOperations aerospikeOperations;
    private final Class<? extends AbstractQueryCreator<?, ?>> queryCreator;

    public AerospikePartTreeQuery(QueryMethod queryMethod, QueryMethodEvaluationContextProvider evalContextProvider, AerospikeOperations aerospikeOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        this.queryMethod = queryMethod;
        this.aerospikeOperations = aerospikeOperations;
        this.evaluationContextProvider = evalContextProvider;
        this.queryCreator = queryCreator;
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        Query query = this.prepareQuery(parameters, accessor);
        if (this.queryMethod.isPageQuery() || this.queryMethod.isSliceQuery()) {
            Stream<?> result = this.findByQuery(query);
            long total = this.queryMethod.isSliceQuery() ? 0L : this.aerospikeOperations.count(query, this.queryMethod.getEntityInformation().getJavaType());
            return new PageImpl(result.collect(Collectors.toList()), accessor.getPageable(), total);
        }
        if (this.queryMethod.isStreamQuery()) {
            return this.findByQuery(query);
        }
        if (this.queryMethod.isCollectionQuery()) {
            return this.findByQuery(query).collect(Collectors.toList());
        }
        if (this.queryMethod.isQueryForEntity()) {
            Stream<?> result = this.findByQuery(query);
            return result.findFirst().orElse(null);
        }
        throw new UnsupportedOperationException("Query method " + this.queryMethod.getNamedQueryName() + " not supported.");
    }

    private Stream<?> findByQuery(Query query) {
        return this.aerospikeOperations.find(query, this.queryMethod.getEntityInformation().getJavaType());
    }

    private Query prepareQuery(Object[] parameters, ParametersParameterAccessor accessor) {
        Query query = this.createQuery(accessor);
        AerospikeCriteria criteria = (AerospikeCriteria)query.getCriteria();
        Query q = new Query(criteria);
        if (accessor.getPageable().isPaged()) {
            q.setOffset(accessor.getPageable().getOffset());
            q.setRows(accessor.getPageable().getPageSize());
        } else {
            q.setOffset(-1L);
            q.setRows(-1);
        }
        if (accessor.getSort().isSorted()) {
            q.setSort(accessor.getSort());
        } else {
            q.setSort(query.getSort());
        }
        if (q.getCriteria() instanceof SpelExpression) {
            EvaluationContext context = this.evaluationContextProvider.getEvaluationContext(this.queryMethod.getParameters(), parameters);
            ((SpelExpression)q.getCriteria()).setEvaluationContext(context);
        }
        return q;
    }

    public Query createQuery(ParametersParameterAccessor accessor) {
        PartTree tree = new PartTree(this.queryMethod.getName(), this.queryMethod.getEntityInformation().getJavaType());
        Constructor constructor = ClassUtils.getConstructorIfAvailable(this.queryCreator, (Class[])new Class[]{PartTree.class, ParameterAccessor.class});
        return (Query)((AbstractQueryCreator)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{tree, accessor})).createQuery();
    }
}

