/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import com.aerospike.client.Value;
import com.aerospike.helper.query.Qualifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.aerospike.InvalidAerospikeDataAccessApiUsageException;
import org.springframework.data.aerospike.repository.query.CriteriaDefinition;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.util.CollectionUtils;

public class Criteria
implements CriteriaDefinition {
    private static final Object NOT_SET = new Object();
    DefaultConversionService cs = new DefaultConversionService();
    private String key;
    private List<Criteria> criteriaChain;
    private LinkedHashMap<String, Object> criteria = new LinkedHashMap();
    private Object isValue = NOT_SET;

    public Criteria(String key) {
        this.criteriaChain = new ArrayList<Criteria>();
        this.criteriaChain.add(this);
        this.key = key;
    }

    protected Criteria(List<Criteria> criteriaChain, String key) {
        this.criteriaChain = criteriaChain;
        this.criteriaChain.add(this);
        this.key = key;
    }

    public Criteria() {
        this.criteriaChain = new ArrayList<Criteria>();
    }

    @Override
    public Qualifier getCriteriaObject() {
        if (this.criteriaChain.size() == 1) {
            return this.criteriaChain.get(0).getSingleCriteriaObject();
        }
        if (CollectionUtils.isEmpty(this.criteriaChain) && !CollectionUtils.isEmpty(this.criteria)) {
            return this.getSingleCriteriaObject();
        }
        Qualifier.FilterOperation op = Qualifier.FilterOperation.valueOf((String)this.key);
        ArrayList<Qualifier> qualifiers = new ArrayList<Qualifier>();
        for (Criteria c : this.criteriaChain) {
            qualifiers.add(c.getCriteriaObject());
        }
        return new Qualifier(op, qualifiers.toArray(new Qualifier[qualifiers.size()]));
    }

    protected Qualifier getSingleCriteriaObject() {
        Qualifier qualifier = null;
        for (String k : this.criteria.keySet()) {
            qualifier = (Qualifier)this.criteria.get(k);
        }
        return qualifier;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public static Criteria where(String key) {
        return new Criteria(key);
    }

    public Criteria and(String key) {
        return new Criteria(this.criteriaChain, key);
    }

    public Criteria gt(Object o, String propertyName) {
        Qualifier qualifier = new Qualifier(propertyName, Qualifier.FilterOperation.GT, Value.get((Object)o));
        this.isValue = o;
        this.criteria.put(Qualifier.FilterOperation.GT.name(), qualifier);
        return this;
    }

    public Criteria gte(Object o, String propertyName) {
        Qualifier qualifier = new Qualifier(propertyName, Qualifier.FilterOperation.GTEQ, Value.get((Object)o));
        this.isValue = o;
        this.criteria.put(Qualifier.FilterOperation.GTEQ.name(), qualifier);
        return this;
    }

    public Criteria lt(Object o, String propertyName) {
        Qualifier qualifier = new Qualifier(propertyName, Qualifier.FilterOperation.LT, Value.get((Object)o));
        this.isValue = o;
        this.criteria.put(Qualifier.FilterOperation.LT.name(), qualifier);
        return this;
    }

    public Criteria lte(Object o, String propertyName) {
        Qualifier qualifier = new Qualifier(propertyName, Qualifier.FilterOperation.LTEQ, Value.get((Object)o));
        this.isValue = o;
        this.criteria.put(Qualifier.FilterOperation.LTEQ.name(), qualifier);
        return this;
    }

    public Criteria ne(Object object) {
        return null;
    }

    private boolean lastOperatorWasNot() {
        return this.criteria.size() > 0 && "$not".equals(this.criteria.keySet().toArray()[this.criteria.size() - 1]);
    }

    private boolean lastOperatorWasNotEqual() {
        return this.criteria.size() > 0 && Qualifier.FilterOperation.EQ.name().equals(this.criteria.keySet().toArray()[this.criteria.size() - 1]);
    }

    private boolean lastOperatorWasNotRange() {
        return this.criteria.size() > 0 && Qualifier.FilterOperation.BETWEEN.name().equals(this.criteria.keySet().toArray()[this.criteria.size() - 1]);
    }

    public Criteria nin(Object nextAsArray) {
        return null;
    }

    public Criteria in(Object next) {
        return null;
    }

    public Criteria orOperator(Criteria ... criteria) {
        this.key = Qualifier.FilterOperation.OR.name();
        return this.registerCriteriaChainElement(criteria);
    }

    private Criteria registerCriteriaChainElement(Criteria ... criteria) {
        for (Criteria c : criteria) {
            if (this.lastOperatorWasNot()) {
                throw new IllegalArgumentException("operator $not is not allowed around criteria chain element: " + c.getCriteriaObject());
            }
            this.criteriaChain.add(c);
        }
        return this;
    }

    public List<Criteria> getCriteriaChain() {
        return this.criteriaChain;
    }

    public Criteria is(Object o, String propertyName) {
        if (!this.isValue.equals(NOT_SET)) {
            throw new InvalidAerospikeDataAccessApiUsageException("Multiple 'is' values declared. You need to use 'and' with multiple criteria");
        }
        if (this.lastOperatorWasNot()) {
            throw new InvalidAerospikeDataAccessApiUsageException("Invalid query: 'not' can't be used with 'is' - use 'ne' instead.");
        }
        if (this.lastOperatorWasNotRange()) {
            throw new InvalidAerospikeDataAccessApiUsageException("Invalid query: cannot combine range with is");
        }
        Qualifier qualifier = new Qualifier(propertyName, Qualifier.FilterOperation.EQ, Value.get((Object)o));
        this.isValue = o;
        this.criteria.put(Qualifier.FilterOperation.EQ.name(), qualifier);
        return this;
    }

    public Criteria between(Object o1, Object o2, String propertyName) {
        Qualifier qualifier = new Qualifier(propertyName, Qualifier.FilterOperation.BETWEEN, Value.get((Object)o1), Value.get((Object)o2));
        this.criteria.put(Qualifier.FilterOperation.BETWEEN.name(), qualifier);
        return this;
    }

    public Criteria startingWith(Object o, String propertyName, Part.IgnoreCaseType ignoreCase) {
        Qualifier qualifier = new Qualifier(propertyName, Qualifier.FilterOperation.START_WITH, Boolean.valueOf(ignoreCase == Part.IgnoreCaseType.ALWAYS), Value.get((Object)o));
        this.criteria.put(Qualifier.FilterOperation.START_WITH.name(), qualifier);
        return this;
    }

    public Criteria containing(Object o, String propertyName, Part.IgnoreCaseType ignoreCase) {
        Qualifier qualifier = new Qualifier(propertyName, Qualifier.FilterOperation.CONTAINING, Boolean.valueOf(ignoreCase == Part.IgnoreCaseType.ALWAYS), Value.get((Object)o));
        this.criteria.put(Qualifier.FilterOperation.CONTAINING.name(), qualifier);
        return this;
    }

    public Criteria geo_within(Object lng, Object lat, Object radius, String propertyName) {
        Qualifier qualifier = new Qualifier(propertyName, Qualifier.FilterOperation.GEO_WITHIN, Value.get((String)String.format("{ \"type\": \"AeroCircle\", \"coordinates\": [[%.8f, %.8f], %f] }", lng, lat, radius)));
        this.criteria.put(Qualifier.FilterOperation.GEO_WITHIN.name(), qualifier);
        return this;
    }
}

