/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.support;

import com.aerospike.client.query.IndexType;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.data.aerospike.core.AerospikeOperations;
import org.springframework.data.aerospike.repository.AerospikeRepository;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.util.Assert;

public class SimpleAerospikeRepository<T, ID>
implements AerospikeRepository<T, ID> {
    private final AerospikeOperations operations;
    private final EntityInformation<T, ID> entityInformation;

    public SimpleAerospikeRepository(EntityInformation<T, ID> metadata, AerospikeOperations operations) {
        this.entityInformation = metadata;
        this.operations = operations;
    }

    public Optional<T> findById(ID id) {
        return Optional.ofNullable(this.operations.findById(id, this.entityInformation.getJavaType()));
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"Cannot save NULL entity");
        this.operations.save(entity);
        return entity;
    }

    public <S extends T> List<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null!");
        List result = IterableConverter.toList(entities);
        for (Object entity : result) {
            this.save(entity);
        }
        return result;
    }

    public void delete(T entity) {
        this.operations.delete(entity);
    }

    public Iterable<T> findAll(Sort sort) {
        return this.operations.findAll(sort, this.entityInformation.getJavaType());
    }

    public Page<T> findAll(Pageable pageable) {
        if (pageable == null) {
            Iterable result = this.findAll();
            return new PageImpl((List)result, null, (long)result.size());
        }
        Class type = this.entityInformation.getJavaType();
        String setName = this.operations.getSetName(type);
        Stream content = this.operations.findInRange(pageable.getOffset(), pageable.getPageSize(), pageable.getSort(), type);
        long totalCount = this.operations.count(type, setName);
        return new PageImpl(content.collect(Collectors.toList()), pageable, totalCount);
    }

    public boolean existsById(ID id) {
        return this.operations.exists(id, this.entityInformation.getJavaType());
    }

    public List<T> findAll() {
        return this.operations.findAll(this.entityInformation.getJavaType()).collect(Collectors.toList());
    }

    public Iterable<T> findAllById(Iterable<ID> ids) {
        return this.operations.findByIds(ids, this.entityInformation.getJavaType());
    }

    public long count() {
        return this.operations.count(this.entityInformation.getJavaType());
    }

    public void deleteById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        this.operations.delete(id, this.entityInformation.getJavaType());
    }

    public void deleteAll(Iterable<? extends T> entities) {
        for (T entity : entities) {
            this.delete(entity);
        }
    }

    public void deleteAll() {
        this.operations.delete(this.entityInformation.getJavaType());
    }

    @Override
    public <T> void createIndex(Class<T> domainType, String indexName, String binName, IndexType indexType) {
        this.operations.createIndex(domainType, indexName, binName, indexType);
    }

    @Override
    public <T> void deleteIndex(Class<T> domainType, String indexName) {
        this.operations.deleteIndex(domainType, indexName);
    }

    @Override
    public boolean indexExists(String indexName) {
        return this.operations.indexExists(indexName);
    }
}

