/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.utility;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.Info;
import com.aerospike.client.cluster.Node;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    private Utils() {
    }

    public static String[] infoAll(AerospikeClient client, String infoString) {
        String[] messages = new String[client.getNodes().length];
        int index = 0;
        for (Node node : client.getNodes()) {
            messages[index] = Info.request((Node)node, (String)infoString);
        }
        return messages;
    }

    public static long sizeofSet(AerospikeClient client, String namespace, String set) {
        Pattern pattern = Pattern.compile("ns_name=" + namespace + ":set_name=" + set + ":n_objects=(\\d+)");
        String[] results = Utils.infoAll(client, "sets");
        long size = 0L;
        for (String info : results) {
            Matcher matcher = pattern.matcher(info);
            while (matcher.find()) {
                size += Long.parseLong(matcher.group(1));
            }
        }
        return size;
    }
}

