/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.convert;

import com.aerospike.client.Key;
import com.aerospike.client.Record;
import java.util.Map;
import org.springframework.util.Assert;

public class AerospikeReadData {
    private final Key key;
    private final Map<String, Object> record;
    private final int expiration;

    private AerospikeReadData(Key key, Map<String, Object> record, int expiration) {
        this.key = key;
        this.record = record;
        this.expiration = expiration;
    }

    public static AerospikeReadData forRead(Key key, Record record) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)record, (String)"Record must not be null");
        Assert.notNull((Object)record.bins, (String)"Record bins must not be null");
        return new AerospikeReadData(key, record.bins, record.getTimeToLive());
    }

    public Map<String, Object> getRecord() {
        return this.record;
    }

    public Key getKey() {
        return this.key;
    }

    public Object getValue(String key) {
        return this.record.get(key);
    }

    public int getExpiration() {
        return this.expiration;
    }
}

