/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Info;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.IndexType;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.ResultSet;
import com.aerospike.client.query.Statement;
import com.aerospike.client.task.IndexTask;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.AerospikeOperations;
import org.springframework.data.aerospike.core.BaseAerospikeTemplate;
import org.springframework.data.aerospike.core.OperationUtils;
import org.springframework.data.aerospike.core.WritePolicyBuilder;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class AerospikeTemplate
extends BaseAerospikeTemplate
implements AerospikeOperations {
    private static final Logger log = LoggerFactory.getLogger(AerospikeTemplate.class);

    public AerospikeTemplate(AerospikeClient client, String namespace, MappingAerospikeConverter converter, AerospikeMappingContext mappingContext, AerospikeExceptionTranslator exceptionTranslator) {
        super(client, namespace, converter, mappingContext, exceptionTranslator);
    }

    @Deprecated
    public AerospikeTemplate(AerospikeClient client, String namespace) {
        super(client, namespace);
    }

    @Override
    public <T> void createIndex(Class<T> domainType, String indexName, String binName, IndexType indexType) {
        try {
            String setName = this.getSetName((Class)domainType);
            IndexTask task = this.client.createIndex(null, this.namespace, setName, indexName, binName, indexType);
            if (task != null) {
                task.waitTillComplete();
            }
            this.queryEngine.refreshIndexes();
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    @Override
    public <T> void deleteIndex(Class<T> domainType, String indexName) {
        try {
            String setName = this.getSetName((Class)domainType);
            IndexTask task = this.client.dropIndex(null, this.namespace, setName, indexName);
            if (task != null) {
                task.waitTillComplete();
            }
            this.queryEngine.refreshIndexes();
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    @Override
    public boolean indexExists(String indexName) {
        try {
            Node[] nodes = this.client.getNodes();
            if (nodes.length == 0) {
                throw new AerospikeException(-8, "Command failed because cluster is empty.");
            }
            Node node = nodes[0];
            String response = Info.request((Node)node, (String)("sindex/" + this.namespace + '/' + indexName));
            return !response.startsWith("FAIL:201");
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    @Override
    public void save(Object document) {
        Assert.notNull((Object)document, (String)"Object to insert must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            this.doPersistWithCas(document, entity);
        } else {
            WritePolicyBuilder builder = WritePolicyBuilder.builder(this.client.writePolicyDefault).sendKey(true).recordExistsAction(RecordExistsAction.REPLACE);
            this.doPersist(document, builder);
        }
    }

    @Override
    public void persist(Object document, WritePolicy policy) {
        Assert.notNull((Object)document, (String)"Document must not be null!");
        Assert.notNull((Object)policy, (String)"Policy must not be null!");
        try {
            AerospikeWriteData data = AerospikeWriteData.forWrite();
            this.converter.write(document, data);
            Key key = data.getKey();
            Bin[] bins = data.getBinsAsArray();
            this.client.put(policy, key, bins);
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    public <T> void insertAll(Collection<? extends T> documents) {
        Assert.notNull(documents, (String)"Documents must not be null!");
        documents.stream().filter(Objects::nonNull).forEach(this::insert);
    }

    @Override
    public void insert(Object document) {
        Assert.notNull((Object)document, (String)"Document must not be null!");
        WritePolicyBuilder writePolicyBuilder = WritePolicyBuilder.builder(this.client.writePolicyDefault).sendKey(true).recordExistsAction(RecordExistsAction.CREATE_ONLY);
        this.doPersist(document, writePolicyBuilder);
    }

    @Override
    public void update(Object document) {
        Assert.notNull((Object)document, (String)"Document must not be null!");
        WritePolicyBuilder writePolicyBuilder = WritePolicyBuilder.builder(this.client.writePolicyDefault).sendKey(true).recordExistsAction(RecordExistsAction.UPDATE_ONLY);
        this.doPersist(document, writePolicyBuilder);
    }

    @Override
    public void delete(Class<?> type) {
        try {
            String set = this.getSetName((Class)type);
            this.client.truncate(null, this.getNamespace(), set, null);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
    }

    @Override
    public boolean delete(Object id, Class<?> type) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        try {
            AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
            Key key = this.getKey(id, entity);
            return this.client.delete(null, key);
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    @Override
    public boolean delete(Object objectToDelete) {
        Assert.notNull((Object)objectToDelete, (String)"Object to delete must not be null!");
        try {
            AerospikeWriteData data = AerospikeWriteData.forWrite();
            this.converter.write(objectToDelete, data);
            return this.client.delete(null, data.getKey());
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    @Override
    public boolean exists(Object id, Class<?> type) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        try {
            AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
            Key key = this.getKey(id, entity);
            Record record = this.client.operate(null, key, new Operation[]{Operation.getHeader()});
            return record != null;
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    @Override
    public <T> Stream<T> findAll(Class<T> type) {
        return this.findAllUsingQuery(type, null, null);
    }

    @Override
    public <T> T findById(Object id, Class<T> type) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        try {
            Record record;
            AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
            Key key = this.getKey(id, entity);
            if (entity.isTouchOnRead()) {
                Assert.state((!entity.hasExpirationProperty() ? 1 : 0) != 0, (String)"Touch on read is not supported for expiration property");
                record = this.getAndTouch(key, entity.getExpiration());
            } else {
                record = this.client.get(null, key);
            }
            return this.mapToEntity(key, type, record);
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    private Record getAndTouch(Key key, int expiration) {
        WritePolicy writePolicy = new WritePolicy(this.client.writePolicyDefault);
        writePolicy.expiration = expiration;
        if (this.client.exists(null, key)) {
            return this.client.operate(writePolicy, key, new Operation[]{Operation.touch(), Operation.get()});
        }
        return null;
    }

    @Override
    public <T> List<T> findByIds(Iterable<?> ids, Class<T> type) {
        Assert.notNull(ids, (String)"List of ids must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        return this.findByIdsInternal(IterableConverter.toList(ids), type);
    }

    private <T> List<T> findByIdsInternal(Collection<?> ids, Class<T> type) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
            Key[] keys = (Key[])ids.stream().map(id -> this.getKey(id, entity)).toArray(Key[]::new);
            Record[] records = this.client.get(null, keys);
            return IntStream.range(0, keys.length).filter(index -> records[index] != null).mapToObj(index -> this.mapToEntity(keys[index], type, records[index])).collect(Collectors.toList());
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    @Override
    public <T> Iterable<T> aggregate(Filter filter, Class<T> outputType, String module, String function, List<Value> arguments) {
        Assert.notNull(outputType, (String)"Output type must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(outputType);
        Statement statement = new Statement();
        if (filter != null) {
            statement.setFilter(filter);
        }
        statement.setSetName(entity.getSetName());
        statement.setNamespace(this.namespace);
        ResultSet resultSet = null;
        resultSet = arguments != null && arguments.size() > 0 ? this.client.queryAggregate(null, statement, module, function, arguments.toArray(new Value[0])) : this.client.queryAggregate(null, statement);
        return resultSet;
    }

    @Override
    public <T> Iterable<T> findAll(Sort sort, Class<T> type) {
        throw new UnsupportedOperationException("not implemented");
    }

    private static boolean typeCheck(Class<?> requiredType, Object candidate) {
        return candidate == null || ClassUtils.isAssignable(requiredType, candidate.getClass());
    }

    public boolean exists(Query query, Class<?> entityClass) {
        Assert.notNull((Object)query, (String)"Query passed in to exist can't be null");
        return this.find(query, entityClass).findAny().isPresent();
    }

    @Override
    public <T> T execute(Supplier<T> supplier) {
        Assert.notNull(supplier, (String)"Callback must not be null!");
        try {
            return supplier.get();
        }
        catch (RuntimeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible(e);
            throw translatedException == null ? e : translatedException;
        }
    }

    @Override
    public long count(Query query, Class<?> type) {
        Stream<KeyRecord> results = this.findAllRecordsUsingQuery(type, query);
        return results.count();
    }

    @Override
    public <T> Stream<T> find(Query query, Class<T> type) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        return this.findAllUsingQuery(type, query);
    }

    @Override
    public <T> Stream<T> findInRange(long offset, long limit, Sort sort, Class<T> type) {
        Assert.notNull(type, (String)"Type for count must not be null!");
        Stream<T> results = this.findAllUsingQuery(type, null, null);
        return results.skip(offset).limit(limit);
    }

    @Override
    public long count(Class<?> type) {
        Assert.notNull(type, (String)"Type for count must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
        return this.count(type, entity.getSetName());
    }

    @Override
    public AerospikeClient getAerospikeClient() {
        return this.client;
    }

    @Override
    public long count(Class<?> type, String setName) {
        Assert.notNull(type, (String)"Type for count must not be null!");
        Node[] nodes = this.client.getNodes();
        int replicationCount = 2;
        int nodeCount = nodes.length;
        int n_objects = 0;
        for (Node node : nodes) {
            String infoString = Info.request((Node)node, (String)("sets/" + this.namespace + "/" + setName));
            String n_objectsString = infoString.substring(infoString.indexOf("=") + 1, infoString.indexOf(":"));
            n_objects = Integer.parseInt(n_objectsString);
        }
        return nodeCount > 1 ? (long)(n_objects / replicationCount) : (long)n_objects;
    }

    @Override
    public <T> T prepend(T objectToPrependTo, String fieldName, String value) {
        Assert.notNull(objectToPrependTo, (String)"Object to prepend to must not be null!");
        try {
            AerospikeWriteData data = AerospikeWriteData.forWrite();
            this.converter.write(objectToPrependTo, data);
            Record record = this.client.operate(null, data.getKey(), new Operation[]{Operation.prepend((Bin)new Bin(fieldName, value)), Operation.get((String)fieldName)});
            return (T)this.mapToEntity(data.getKey(), objectToPrependTo.getClass(), record);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
    }

    @Override
    public <T> T prepend(T objectToPrependTo, Map<String, String> values) {
        Assert.notNull(objectToPrependTo, (String)"Object to prepend to must not be null!");
        try {
            AerospikeWriteData data = AerospikeWriteData.forWrite();
            this.converter.write(objectToPrependTo, data);
            Operation[] ops = new Operation[values.size() + 1];
            int x = 0;
            for (Map.Entry<String, String> entry : values.entrySet()) {
                Bin newBin = new Bin(entry.getKey(), entry.getValue());
                ops[x] = Operation.prepend((Bin)newBin);
                ++x;
            }
            ops[x] = Operation.get();
            Record record = this.client.operate(null, data.getKey(), ops);
            return (T)this.mapToEntity(data.getKey(), objectToPrependTo.getClass(), record);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
    }

    @Override
    public <T> T append(T objectToAppendTo, Map<String, String> values) {
        Assert.notNull(objectToAppendTo, (String)"Object to append to must not be null!");
        try {
            AerospikeWriteData data = AerospikeWriteData.forWrite();
            this.converter.write(objectToAppendTo, data);
            Operation[] ops = new Operation[values.size() + 1];
            int x = 0;
            for (Map.Entry<String, String> entry : values.entrySet()) {
                Bin newBin = new Bin(entry.getKey(), entry.getValue());
                ops[x] = Operation.append((Bin)newBin);
                ++x;
            }
            ops[x] = Operation.get();
            Record record = this.client.operate(null, data.getKey(), ops);
            return (T)this.mapToEntity(data.getKey(), objectToAppendTo.getClass(), record);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
    }

    @Override
    public <T> T append(T objectToAppendTo, String binName, String value) {
        Assert.notNull(objectToAppendTo, (String)"Object to append to must not be null!");
        try {
            AerospikeWriteData data = AerospikeWriteData.forWrite();
            this.converter.write(objectToAppendTo, data);
            Record record = this.client.operate(null, data.getKey(), new Operation[]{Operation.append((Bin)new Bin(binName, value)), Operation.get((String)binName)});
            return (T)this.mapToEntity(data.getKey(), objectToAppendTo.getClass(), record);
        }
        catch (AerospikeException o_O) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)o_O));
            throw translatedException == null ? o_O : translatedException;
        }
    }

    @Override
    public <T> T add(T objectToAddTo, Map<String, Long> values) {
        Assert.notNull(objectToAddTo, (String)"Object to add to must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        try {
            AerospikeWriteData data = AerospikeWriteData.forWrite();
            this.converter.write(objectToAddTo, data);
            Operation[] operations = new Operation[values.size() + 1];
            int x = 0;
            for (Map.Entry<String, Long> entry : values.entrySet()) {
                Bin newBin = new Bin(entry.getKey(), (Object)entry.getValue());
                operations[x] = Operation.add((Bin)newBin);
                ++x;
            }
            operations[x] = Operation.get();
            WritePolicy writePolicy = new WritePolicy(this.client.writePolicyDefault);
            writePolicy.expiration = data.getExpiration();
            Record record = this.client.operate(writePolicy, data.getKey(), operations);
            return (T)this.mapToEntity(data.getKey(), objectToAddTo.getClass(), record);
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    @Override
    public <T> T add(T objectToAddTo, String binName, long value) {
        Assert.notNull(objectToAddTo, (String)"Object to add to must not be null!");
        Assert.notNull((Object)binName, (String)"Bin name must not be null!");
        try {
            AerospikeWriteData data = AerospikeWriteData.forWrite();
            this.converter.write(objectToAddTo, data);
            WritePolicy writePolicy = new WritePolicy(this.client.writePolicyDefault);
            writePolicy.expiration = data.getExpiration();
            Record record = this.client.operate(writePolicy, data.getKey(), new Operation[]{Operation.add((Bin)new Bin(binName, value)), Operation.get()});
            return (T)this.mapToEntity(data.getKey(), objectToAddTo.getClass(), record);
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    private void doPersist(Object document, WritePolicyBuilder policyBuilder) {
        try {
            AerospikeWriteData data = AerospikeWriteData.forWrite();
            this.converter.write(document, data);
            Key key = data.getKey();
            Bin[] bins = data.getBinsAsArray();
            WritePolicy policy = policyBuilder.expiration(data.getExpiration()).build();
            this.client.put(policy, key, bins);
        }
        catch (AerospikeException e) {
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }

    private void doPersistWithCas(Object document, AerospikePersistentEntity<?> entity) {
        try {
            AerospikeWriteData data = AerospikeWriteData.forWrite();
            this.converter.write(document, data);
            Key key = data.getKey();
            Bin[] bins = data.getBinsAsArray();
            ConvertingPropertyAccessor<Object> accessor = this.getPropertyAccessor(entity, document);
            WritePolicy policy = this.getCasAwareWritePolicy(data, entity, accessor);
            Operation[] operations = OperationUtils.operations(bins, Operation::put, Operation.getHeader());
            Record newRecord = this.client.operate(policy, key, operations);
            accessor.setProperty(entity.getVersionProperty(), (Object)newRecord.generation);
        }
        catch (AerospikeException e) {
            int code = e.getResultCode();
            if (code == 5 || code == 3) {
                throw new OptimisticLockingFailureException("Save document with version value failed", (Throwable)e);
            }
            DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
            throw translatedException == null ? e : translatedException;
        }
    }
}

