/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.convert;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.aerospike.convert.ConverterRegistration;
import org.springframework.data.aerospike.convert.DateConverters;
import org.springframework.data.aerospike.convert.EnumToStringConverter;
import org.springframework.data.aerospike.convert.LongToBooleanConverter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.util.Assert;

public class CustomConversions {
    private final SimpleTypeHolder simpleTypeHolder;
    private final List<Object> converters;
    private final Set<GenericConverter.ConvertiblePair> readingPairs;
    private final Set<GenericConverter.ConvertiblePair> writingPairs;
    private final Set<Class<?>> customSimpleTypes;
    private final ConcurrentMap<GenericConverter.ConvertiblePair, CacheValue> customReadTargetTypes;

    public CustomConversions(List<?> converters, SimpleTypeHolder simpleTypeHolder) {
        Assert.notNull(converters, (String)"List of Converters must not be null!");
        this.readingPairs = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        this.writingPairs = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        this.customSimpleTypes = new HashSet();
        this.customReadTargetTypes = new ConcurrentHashMap<GenericConverter.ConvertiblePair, CacheValue>();
        this.converters = new ArrayList<Object>();
        this.converters.addAll(converters);
        this.converters.addAll(DateConverters.getConvertersToRegister());
        this.converters.add(new LongToBooleanConverter());
        this.converters.add(new EnumToStringConverter());
        this.simpleTypeHolder = simpleTypeHolder;
        for (Object converter : this.converters) {
            this.registerConversion(converter);
        }
    }

    public boolean isSimpleType(Class<?> type) {
        return this.simpleTypeHolder.isSimpleType(type);
    }

    public SimpleTypeHolder getSimpleTypeHolder() {
        return this.simpleTypeHolder;
    }

    public void registerConvertersIn(GenericConversionService conversionService) {
        for (Object converter : this.converters) {
            boolean added = false;
            if (converter instanceof Converter) {
                conversionService.addConverter((Converter)converter);
                added = true;
            }
            if (converter instanceof ConverterFactory) {
                conversionService.addConverterFactory((ConverterFactory)converter);
                added = true;
            }
            if (converter instanceof GenericConverter) {
                conversionService.addConverter((GenericConverter)converter);
                added = true;
            }
            if (added) continue;
            throw new IllegalArgumentException("Given set contains element that is neither Converter nor ConverterFactory!");
        }
    }

    private void registerConversion(Object converter) {
        Class<?> type = converter.getClass();
        boolean isWriting = type.isAnnotationPresent(WritingConverter.class);
        boolean isReading = type.isAnnotationPresent(ReadingConverter.class);
        if (converter instanceof GenericConverter) {
            GenericConverter genericConverter = (GenericConverter)converter;
            for (GenericConverter.ConvertiblePair pair : genericConverter.getConvertibleTypes()) {
                this.register(new ConverterRegistration(this.simpleTypeHolder, pair, isReading, isWriting));
            }
        } else if (converter instanceof Converter) {
            Class[] arguments = GenericTypeResolver.resolveTypeArguments(converter.getClass(), Converter.class);
            this.register(new ConverterRegistration(this.simpleTypeHolder, arguments[0], arguments[1], isReading, isWriting));
        } else {
            throw new IllegalArgumentException("Unsupported Converter type!");
        }
    }

    private void register(ConverterRegistration registration) {
        GenericConverter.ConvertiblePair pair = registration.getConvertiblePair();
        if (registration.isReading()) {
            this.readingPairs.add(pair);
        }
        if (registration.isWriting()) {
            this.writingPairs.add(pair);
            this.customSimpleTypes.add(pair.getSourceType());
        }
    }

    public Class<?> getCustomWriteTarget(Class<?> sourceType) {
        return this.getCustomWriteTarget(sourceType, null);
    }

    public Class<?> getCustomWriteTarget(Class<?> sourceType, Class<?> requestedTargetType) {
        Assert.notNull(sourceType, (String)"Source type must not be null!");
        return CustomConversions.getCustomTarget(sourceType, requestedTargetType, this.writingPairs);
    }

    public boolean hasCustomWriteTarget(Class<?> sourceType) {
        Assert.notNull(sourceType, (String)"Source type must not be null!");
        return this.hasCustomWriteTarget(sourceType, null);
    }

    public boolean hasCustomWriteTarget(Class<?> sourceType, Class<?> requestedTargetType) {
        Assert.notNull(sourceType, (String)"Source type must not be null!");
        return this.getCustomWriteTarget(sourceType, requestedTargetType) != null;
    }

    public boolean hasCustomReadTarget(Class<?> sourceType, Class<?> requestedTargetType) {
        Assert.notNull(sourceType, (String)"Source type must not be null!");
        Assert.notNull(requestedTargetType, (String)"Requested target type must not be null!");
        return this.getCustomReadTarget(sourceType, requestedTargetType) != null;
    }

    private Class<?> getCustomReadTarget(Class<?> sourceType, Class<?> requestedTargetType) {
        Assert.notNull(sourceType, (String)"Source type must not be null!");
        if (requestedTargetType == null) {
            return null;
        }
        GenericConverter.ConvertiblePair lookupKey = new GenericConverter.ConvertiblePair(sourceType, requestedTargetType);
        CacheValue readTargetTypeValue = (CacheValue)this.customReadTargetTypes.get(lookupKey);
        if (readTargetTypeValue != null) {
            return readTargetTypeValue.getType();
        }
        readTargetTypeValue = CacheValue.of(CustomConversions.getCustomTarget(sourceType, requestedTargetType, this.readingPairs));
        CacheValue cacheValue = this.customReadTargetTypes.putIfAbsent(lookupKey, readTargetTypeValue);
        return cacheValue != null ? cacheValue.getType() : readTargetTypeValue.getType();
    }

    private static Class<?> getCustomTarget(Class<?> sourceType, Class<?> requestedTargetType, Iterable<GenericConverter.ConvertiblePair> pairs) {
        Assert.notNull(sourceType, (String)"Source type must not be null!");
        Assert.notNull(pairs, (String)"Pairs must not be null!");
        for (GenericConverter.ConvertiblePair typePair : pairs) {
            if (!typePair.getSourceType().isAssignableFrom(sourceType)) continue;
            Class targetType = typePair.getTargetType();
            if (requestedTargetType != null && !targetType.isAssignableFrom(requestedTargetType)) continue;
            return targetType;
        }
        return null;
    }

    private static class CacheValue {
        private static final CacheValue ABSENT = new CacheValue(null);
        private final Class<?> type;

        public CacheValue(Class<?> type) {
            this.type = type;
        }

        public Class<?> getType() {
            return this.type;
        }

        static CacheValue of(Class<?> type) {
            return type == null ? ABSENT : new CacheValue(type);
        }
    }
}

