/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.convert;

import com.aerospike.client.Key;
import com.aerospike.client.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.aerospike.convert.AerospikeReadData;
import org.springframework.data.aerospike.convert.CustomConversions;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.utility.TimeUtils;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.convert.EntityReader;
import org.springframework.data.convert.TypeMapper;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class MappingAerospikeReadConverter
implements EntityReader<Object, AerospikeReadData> {
    private final EntityInstantiators entityInstantiators;
    private final TypeMapper<Map<String, Object>> typeMapper;
    private final AerospikeMappingContext mappingContext;
    private final CustomConversions conversions;
    private final GenericConversionService conversionService;

    public MappingAerospikeReadConverter(EntityInstantiators entityInstantiators, TypeMapper<Map<String, Object>> typeMapper, AerospikeMappingContext mappingContext, CustomConversions conversions, GenericConversionService conversionService) {
        this.entityInstantiators = entityInstantiators;
        this.typeMapper = typeMapper;
        this.mappingContext = mappingContext;
        this.conversions = conversions;
        this.conversionService = conversionService;
    }

    public <R> R read(Class<R> targetClass, AerospikeReadData data) {
        if (data == null) {
            return null;
        }
        Map<String, Object> record = data.getRecord();
        TypeInformation typeToUse = this.typeMapper.readType(record, (TypeInformation)ClassTypeInformation.from(targetClass));
        Class rawType = typeToUse.getType();
        if (this.conversions.hasCustomReadTarget(AerospikeReadData.class, rawType)) {
            return (R)this.conversionService.convert((Object)data, rawType);
        }
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(typeToUse);
        RecordReadingPropertyValueProvider propertyValueProvider = new RecordReadingPropertyValueProvider(data);
        ConvertingPropertyAccessor accessor = this.getConvertingPropertyAccessor(entity, propertyValueProvider);
        return this.convertProperties(entity, propertyValueProvider, (PersistentPropertyAccessor)accessor);
    }

    private <T> T getIdValue(Key key, Map<String, Object> data, AerospikePersistentProperty property) {
        Value userKey = key.userKey;
        Object value = userKey == null ? data.get("@user_key") : userKey.getObject();
        Assert.notNull((Object)value, (String)"Id must not be null!");
        return (T)this.convertIfNeeded(value, property.getType());
    }

    private <R> R convertProperties(AerospikePersistentEntity<?> entity, RecordReadingPropertyValueProvider propertyValueProvider, PersistentPropertyAccessor accessor) {
        entity.doWithProperties(persistentProperty -> {
            PreferredConstructor constructor = entity.getPersistenceConstructor();
            if (constructor.isConstructorParameter(persistentProperty)) {
                return;
            }
            Object value = propertyValueProvider.getPropertyValue((AerospikePersistentProperty)persistentProperty);
            if (persistentProperty.getType().isPrimitive() && value == null) {
                return;
            }
            accessor.setProperty(persistentProperty, value);
        });
        return (R)accessor.getBean();
    }

    private <T> T readValue(Object source, TypeInformation<?> propertyType) {
        Assert.notNull(propertyType, (String)"Target type must not be null!");
        if (source == null) {
            return null;
        }
        Class targetClass = propertyType.getType();
        if (this.conversions.hasCustomReadTarget(source.getClass(), targetClass)) {
            return (T)this.conversionService.convert(source, targetClass);
        }
        if (propertyType.isCollectionLike()) {
            return (T)this.convertCollection(MappingAerospikeReadConverter.asCollection(source), propertyType);
        }
        if (propertyType.isMap()) {
            return (T)this.convertMap((Map)source, propertyType);
        }
        if (source instanceof Map) {
            return this.convertCustomType((Map)source, propertyType);
        }
        return (T)this.convertIfNeeded(source, targetClass);
    }

    private static Collection<?> asCollection(Object source) {
        if (source instanceof Collection) {
            return (Collection)source;
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
    }

    private <T> T convertCustomType(Map<String, Object> source, TypeInformation<?> propertyType) {
        TypeInformation typeToUse = this.typeMapper.readType(source, propertyType);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getPersistentEntity(typeToUse);
        RecordReadingPropertyValueProvider propertyValueProvider = new RecordReadingPropertyValueProvider(source);
        ConvertingPropertyAccessor persistentPropertyAccessor = this.getConvertingPropertyAccessor(entity, propertyValueProvider);
        return (T)this.convertProperties(entity, propertyValueProvider, (PersistentPropertyAccessor)persistentPropertyAccessor);
    }

    private <R> R convertMap(Map<String, Object> source, TypeInformation<?> propertyType) {
        Class mapClass = propertyType.getType();
        TypeInformation keyType = propertyType.getComponentType();
        Class keyClass = keyType == null ? null : keyType.getType();
        TypeInformation mapValueType = propertyType.getMapValueType();
        Map converted = CollectionFactory.createMap((Class)mapClass, (Class)keyClass, (int)source.keySet().size());
        source.entrySet().forEach(e -> {
            Object key = keyClass != null ? this.conversionService.convert(e.getKey(), keyClass) : e.getKey();
            Object value = this.readValue(e.getValue(), mapValueType);
            converted.put(key, value);
        });
        return (R)this.convertIfNeeded(converted, propertyType.getType());
    }

    private <R> R convertCollection(Collection source, TypeInformation<?> propertyType) {
        Class collectionClass = propertyType.getType();
        TypeInformation elementType = propertyType.getComponentType();
        Class elementClass = elementType == null ? null : elementType.getType();
        ArrayList items = collectionClass.isArray() ? new ArrayList() : CollectionFactory.createCollection((Class)collectionClass, (Class)elementClass, (int)source.size());
        source.forEach(item -> items.add(this.readValue(item, elementType)));
        return (R)this.convertIfNeeded(items, propertyType.getType());
    }

    private Object convertIfNeeded(Object value, Class<?> targetClass) {
        if (Enum.class.isAssignableFrom(targetClass)) {
            return Enum.valueOf(targetClass, value.toString());
        }
        return targetClass.isAssignableFrom(value.getClass()) ? value : this.conversionService.convert(value, targetClass);
    }

    private ConvertingPropertyAccessor getConvertingPropertyAccessor(AerospikePersistentEntity<?> entity, RecordReadingPropertyValueProvider recordReadingPropertyValueProvider) {
        EntityInstantiator instantiator = this.entityInstantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, (ParameterValueProvider)new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)recordReadingPropertyValueProvider, null));
        return new ConvertingPropertyAccessor(entity.getPropertyAccessor(instance), (ConversionService)this.conversionService);
    }

    private <T> T getExpiration(int expiration, AerospikePersistentProperty property) {
        if (property.isExpirationSpecifiedAsUnixTime()) {
            return (T)this.convertIfNeeded(TimeUtils.offsetInSecondsToUnixTime(expiration), property.getType());
        }
        return (T)this.convertIfNeeded(expiration, property.getType());
    }

    private <T> T getVersion(int generation, AerospikePersistentProperty property) {
        return (T)this.convertIfNeeded(generation, property.getType());
    }

    private class RecordReadingPropertyValueProvider
    implements PropertyValueProvider<AerospikePersistentProperty> {
        private final Key key;
        private final Integer expiration;
        private final int generation;
        private final Map<String, Object> source;

        public RecordReadingPropertyValueProvider(AerospikeReadData readData) {
            this(readData.getKey(), readData.getExpiration(), readData.getVersion(), readData.getRecord());
        }

        public RecordReadingPropertyValueProvider(Map<String, Object> source) {
            this(null, null, 0, source);
        }

        public RecordReadingPropertyValueProvider(Key key, Integer expiration, int generation, Map<String, Object> source) {
            this.key = key;
            this.expiration = expiration;
            this.generation = generation;
            this.source = source;
        }

        public <T> T getPropertyValue(AerospikePersistentProperty property) {
            if (this.key != null && property.isIdProperty()) {
                return (T)MappingAerospikeReadConverter.this.getIdValue(this.key, this.source, property);
            }
            if (this.expiration != null && property.isExpirationProperty()) {
                return (T)MappingAerospikeReadConverter.this.getExpiration(this.expiration, property);
            }
            if (property.isVersionProperty()) {
                return (T)MappingAerospikeReadConverter.this.getVersion(this.generation, property);
            }
            Object value = this.source.get(property.getFieldName());
            return (T)MappingAerospikeReadConverter.this.readValue(value, property.getTypeInformation());
        }
    }
}

