/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Log;
import com.aerospike.client.Record;
import com.aerospike.client.policy.GenerationPolicy;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.helper.query.KeyRecordIterator;
import com.aerospike.helper.query.Qualifier;
import com.aerospike.helper.query.QueryEngine;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.support.PropertyComparator;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.aerospike.convert.AerospikeReadData;
import org.springframework.data.aerospike.convert.AerospikeTypeAliasAccessor;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.convert.CustomConversions;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.DefaultAerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.WritePolicyBuilder;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.AerospikeSimpleTypes;
import org.springframework.data.aerospike.mapping.BasicAerospikePersistentEntity;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.util.StreamUtils;
import org.springframework.util.Assert;
import org.springframework.util.comparator.CompoundComparator;

abstract class BaseAerospikeTemplate {
    private static final Logger log = LoggerFactory.getLogger(BaseAerospikeTemplate.class);
    protected final MappingContext<BasicAerospikePersistentEntity<?>, AerospikePersistentProperty> mappingContext;
    protected final AerospikeClient client;
    protected final MappingAerospikeConverter converter;
    protected final String namespace;
    protected final QueryEngine queryEngine;
    protected final AerospikeExceptionTranslator exceptionTranslator;

    BaseAerospikeTemplate(AerospikeClient client, String namespace, MappingAerospikeConverter converter, AerospikeMappingContext mappingContext, AerospikeExceptionTranslator exceptionTranslator) {
        Assert.notNull((Object)client, (String)"Aerospike client must not be null!");
        Assert.notNull((Object)namespace, (String)"Namespace cannot be null");
        Assert.hasLength((String)namespace, (String)"Namespace cannot be empty");
        this.client = client;
        this.converter = converter;
        this.exceptionTranslator = exceptionTranslator;
        this.namespace = namespace;
        this.mappingContext = mappingContext;
        this.queryEngine = new QueryEngine(this.client);
        this.loggerSetup();
    }

    BaseAerospikeTemplate(AerospikeClient client, String namespace) {
        Assert.notNull((Object)client, (String)"Aerospike client must not be null!");
        Assert.notNull((Object)namespace, (String)"Namespace cannot be null");
        Assert.hasLength((String)namespace, (String)"Namespace cannot be empty");
        CustomConversions customConversions = new CustomConversions(Collections.emptyList(), AerospikeSimpleTypes.HOLDER);
        AerospikeMappingContext asContext = new AerospikeMappingContext();
        asContext.setDefaultNameSpace(namespace);
        this.client = client;
        this.converter = new MappingAerospikeConverter(asContext, customConversions, new AerospikeTypeAliasAccessor());
        this.exceptionTranslator = new DefaultAerospikeExceptionTranslator();
        this.namespace = namespace;
        this.mappingContext = asContext;
        this.queryEngine = new QueryEngine(this.client);
        this.converter.afterPropertiesSet();
        this.loggerSetup();
    }

    private void loggerSetup() {
        Logger log = LoggerFactory.getLogger((String)"com.aerospike.client");
        Log.setCallback((level, message) -> {
            switch (level) {
                case INFO: {
                    log.info("{}", (Object)message);
                    break;
                }
                case DEBUG: {
                    log.debug("{}", (Object)message);
                    break;
                }
                case ERROR: {
                    log.error("{}", (Object)message);
                    break;
                }
                case WARN: {
                    log.warn("{}", (Object)message);
                }
            }
        });
    }

    public <T> String getSetName(Class<T> entityClass) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        return entity.getSetName();
    }

    public MappingContext<?, ?> getMappingContext() {
        return this.mappingContext;
    }

    public String getNamespace() {
        return this.namespace;
    }

    <T> Class<T> getEntityClass(T entity) {
        return entity.getClass();
    }

    <T> T mapToEntity(Key key, Class<T> type, Record record) {
        if (record == null) {
            return null;
        }
        AerospikeReadData data = AerospikeReadData.forRead(key, record);
        return this.converter.read(type, data);
    }

    <T> Stream<T> findAllUsingQuery(Class<T> type, Query query) {
        if ((query.getSort() == null || query.getSort().isUnsorted()) && query.getOffset() > 0L) {
            throw new IllegalArgumentException("Unsorted query must not have offset value. For retrieving paged results use sorted query.");
        }
        Qualifier qualifier = query.getCriteria().getCriteriaObject();
        Stream<?> results = this.findAllUsingQuery(type, null, qualifier);
        if (query.getSort() != null && query.getSort().isSorted()) {
            Comparator<?> comparator = this.getComparator(query);
            results = results.sorted(comparator);
        }
        if (query.hasOffset()) {
            results = results.skip(query.getOffset());
        }
        if (query.hasRows()) {
            results = results.limit(query.getRows());
        }
        return results;
    }

    <T> Stream<T> findAllUsingQuery(Class<T> type, Filter filter, Qualifier ... qualifiers) {
        return this.findAllRecordsUsingQuery(type, filter, qualifiers).map(keyRecord -> this.mapToEntity(keyRecord.key, type, keyRecord.record));
    }

    <T> Stream<KeyRecord> findAllRecordsUsingQuery(Class<T> type, Filter filter, Qualifier ... qualifiers) {
        String setName = this.getSetName(type);
        KeyRecordIterator recIterator = this.queryEngine.select(this.namespace, setName, filter, qualifiers);
        return (Stream)StreamUtils.createStreamFromIterator((Iterator)recIterator).onClose(() -> {
            try {
                recIterator.close();
            }
            catch (Exception e) {
                log.error("Caught exception while closing query", (Throwable)e);
            }
        });
    }

    <T> Stream<KeyRecord> findAllRecordsUsingQuery(Class<T> type, Query query) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        Qualifier qualifier = query.getCriteria().getCriteriaObject();
        return this.findAllRecordsUsingQuery(type, null, qualifier);
    }

    private Comparator<?> getComparator(Query query) {
        CompoundComparator compoundComperator = new CompoundComparator();
        for (Sort.Order order : query.getSort()) {
            if (Sort.Direction.DESC.equals((Object)order.getDirection())) {
                compoundComperator.addComparator((Comparator)new PropertyComparator(order.getProperty(), true, false));
                continue;
            }
            compoundComperator.addComparator((Comparator)new PropertyComparator(order.getProperty(), true, true));
        }
        return compoundComperator;
    }

    <T> ConvertingPropertyAccessor<T> getPropertyAccessor(AerospikePersistentEntity<?> entity, T source) {
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(source);
        return new ConvertingPropertyAccessor(accessor, this.converter.getConversionService());
    }

    <T> T updateVersion(T document, Record newRecord) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        ConvertingPropertyAccessor<T> propertyAccessor = this.getPropertyAccessor(entity, document);
        AerospikePersistentProperty versionProperty = (AerospikePersistentProperty)entity.getRequiredVersionProperty();
        propertyAccessor.setProperty((PersistentProperty)versionProperty, (Object)newRecord.generation);
        return document;
    }

    RuntimeException translateCasError(AerospikeException e) {
        int code = e.getResultCode();
        if (code == 5 || code == 3) {
            return new OptimisticLockingFailureException("Save document with version value failed", (Throwable)e);
        }
        return this.translateError(e);
    }

    RuntimeException translateError(AerospikeException e) {
        DataAccessException translated = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)e);
        return translated == null ? e : translated;
    }

    <T> AerospikeWriteData writeData(T document) {
        AerospikeWriteData data = AerospikeWriteData.forWrite();
        this.converter.write(document, data);
        return data;
    }

    WritePolicy expectGenerationCasAwareSavePolicy(AerospikeWriteData data) {
        RecordExistsAction recordExistsAction = data.getVersion().filter(v -> (long)v.intValue() > 0L).map(v -> RecordExistsAction.REPLACE_ONLY).orElse(RecordExistsAction.CREATE_ONLY);
        return this.expectGenerationSavePolicy(data, recordExistsAction);
    }

    WritePolicy expectGenerationSavePolicy(AerospikeWriteData data, RecordExistsAction recordExistsAction) {
        return WritePolicyBuilder.builder(this.client.writePolicyDefault).generationPolicy(GenerationPolicy.EXPECT_GEN_EQUAL).generation(data.getVersion().orElse(0)).sendKey(true).expiration(data.getExpiration()).recordExistsAction(recordExistsAction).build();
    }

    WritePolicy ignoreGenerationSavePolicy(AerospikeWriteData data, RecordExistsAction recordExistsAction) {
        return WritePolicyBuilder.builder(this.client.writePolicyDefault).generationPolicy(GenerationPolicy.NONE).sendKey(true).expiration(data.getExpiration()).recordExistsAction(recordExistsAction).build();
    }

    WritePolicy ignoreGenerationDeletePolicy() {
        return WritePolicyBuilder.builder(this.client.writePolicyDefault).generationPolicy(GenerationPolicy.NONE).build();
    }

    Key getKey(Object id, AerospikePersistentEntity<?> entity) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        return new Key(this.namespace, entity.getSetName(), id.toString());
    }
}

