/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.cache;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import java.util.concurrent.Callable;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

public class AerospikeCache
implements Cache {
    private static final String VALUE = "value";
    protected AerospikeClient client;
    protected String namespace;
    protected String set;
    protected WritePolicy createOnly;

    public AerospikeCache(String namespace, String set, AerospikeClient client, long expiration) {
        this.client = client;
        this.namespace = namespace;
        this.set = set;
        this.createOnly = new WritePolicy(client.writePolicyDefault);
        this.createOnly.recordExistsAction = RecordExistsAction.CREATE_ONLY;
    }

    protected Key getKey(Object key) {
        return new Key(this.namespace, this.set, key.toString());
    }

    private Cache.ValueWrapper toWrapper(Record record) {
        return record != null ? new SimpleValueWrapper(record.getValue(VALUE)) : null;
    }

    public void clear() {
    }

    public void evict(Object key) {
        this.client.delete(null, this.getKey(key));
    }

    public Cache.ValueWrapper get(Object key) {
        Record record = this.client.get(null, this.getKey(key));
        Cache.ValueWrapper vr = this.toWrapper(record);
        return vr;
    }

    public <T> T get(Object key, Class<T> type) {
        return (T)this.client.get(null, this.getKey(key));
    }

    public String getName() {
        return this.namespace + ":" + this.set;
    }

    public Object getNativeCache() {
        return this.client;
    }

    public void put(Object key, Object value) {
        this.client.put(null, this.getKey(key), new Bin[]{new Bin(VALUE, value)});
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        Record record = this.client.operate(this.createOnly, this.getKey(key), new Operation[]{Operation.put((Bin)new Bin(VALUE, value)), Operation.get((String)VALUE)});
        return this.toWrapper(record);
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        return null;
    }
}

