/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Info;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.IndexType;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.ResultSet;
import com.aerospike.client.query.Statement;
import com.aerospike.client.task.IndexTask;
import com.aerospike.helper.query.KeyRecordIterator;
import com.aerospike.helper.query.Qualifier;
import com.aerospike.helper.query.QueryEngine;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.AerospikeOperations;
import org.springframework.data.aerospike.core.BaseAerospikeTemplate;
import org.springframework.data.aerospike.core.OperationUtils;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.util.StreamUtils;
import org.springframework.util.Assert;

public class AerospikeTemplate
extends BaseAerospikeTemplate
implements AerospikeOperations {
    private static final Logger log = LoggerFactory.getLogger(AerospikeTemplate.class);
    private final AerospikeClient client;
    private final QueryEngine queryEngine;

    public AerospikeTemplate(AerospikeClient client, String namespace, MappingAerospikeConverter converter, AerospikeMappingContext mappingContext, AerospikeExceptionTranslator exceptionTranslator) {
        super(namespace, converter, mappingContext, exceptionTranslator, client.writePolicyDefault);
        this.client = client;
        this.queryEngine = new QueryEngine(this.client);
    }

    @Deprecated
    public AerospikeTemplate(AerospikeClient client, String namespace) {
        super(namespace, client.writePolicyDefault);
        this.client = client;
        this.queryEngine = new QueryEngine(this.client);
    }

    @Override
    public <T> void createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType) {
        Assert.notNull(entityClass, (String)"Type must not be null!");
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        try {
            String setName = this.getSetName((Class)entityClass);
            IndexTask task = this.client.createIndex(null, this.namespace, setName, indexName, binName, indexType);
            if (task != null) {
                task.waitTillComplete();
            }
            this.queryEngine.refreshIndexes();
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> void deleteIndex(Class<T> entityClass, String indexName) {
        Assert.notNull(entityClass, (String)"Type must not be null!");
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        try {
            String setName = this.getSetName((Class)entityClass);
            IndexTask task = this.client.dropIndex(null, this.namespace, setName, indexName);
            if (task != null) {
                task.waitTillComplete();
            }
            this.queryEngine.refreshIndexes();
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public boolean indexExists(String indexName) {
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        log.warn("`indexExists` operation is deprecated. Please stop using it as it will be removed in next major release.");
        try {
            Node[] nodes = this.client.getNodes();
            if (nodes.length == 0) {
                throw new AerospikeException(-8, "Command failed because cluster is empty.");
            }
            Node node = nodes[0];
            String response = Info.request((Node)node, (String)("sindex/" + this.namespace + '/' + indexName));
            return !response.startsWith("FAIL:201");
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> void save(T document) {
        Assert.notNull(document, (String)"Object to insert must not be null!");
        AerospikeWriteData data = this.writeData(document);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy policy = this.expectGenerationCasAwareSavePolicy(data);
            this.doPersistWithVersionAndHandleCasError(document, data, policy);
        } else {
            WritePolicy policy = this.ignoreGenerationSavePolicy(data, RecordExistsAction.REPLACE);
            this.doPersistAndHandleError(data, policy);
        }
    }

    @Override
    public <T> void persist(T document, WritePolicy policy) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)policy, (String)"Policy must not be null!");
        AerospikeWriteData data = this.writeData(document);
        this.doPersistAndHandleError(data, policy);
    }

    public <T> void insertAll(Collection<? extends T> documents) {
        Assert.notNull(documents, (String)"Documents must not be null!");
        documents.stream().filter(Objects::nonNull).forEach(this::insert);
    }

    @Override
    public <T> void insert(T document) {
        Assert.notNull(document, (String)"Document must not be null!");
        AerospikeWriteData data = this.writeData(document);
        WritePolicy policy = this.ignoreGenerationSavePolicy(data, RecordExistsAction.CREATE_ONLY);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            this.doPersistWithVersionAndHandleError(document, data, policy);
        } else {
            this.doPersistAndHandleError(data, policy);
        }
    }

    @Override
    public <T> void update(T document) {
        Assert.notNull(document, (String)"Document must not be null!");
        AerospikeWriteData data = this.writeData(document);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy policy = this.expectGenerationSavePolicy(data, RecordExistsAction.REPLACE_ONLY);
            this.doPersistWithVersionAndHandleCasError(document, data, policy);
        } else {
            WritePolicy policy = this.ignoreGenerationSavePolicy(data, RecordExistsAction.REPLACE_ONLY);
            this.doPersistAndHandleError(data, policy);
        }
    }

    @Override
    public <T> void delete(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Type must not be null!");
        try {
            String set = this.getSetName((Class)entityClass);
            this.client.truncate(null, this.getNamespace(), set, null);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> boolean delete(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Type must not be null!");
        try {
            AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
            Key key = this.getKey(id, entity);
            return this.client.delete(this.ignoreGenerationDeletePolicy(), key);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> boolean delete(T objectToDelete) {
        Assert.notNull(objectToDelete, (String)"Object to delete must not be null!");
        try {
            AerospikeWriteData data = this.writeData(objectToDelete);
            return this.client.delete(this.ignoreGenerationDeletePolicy(), data.getKey());
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> boolean exists(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Type must not be null!");
        try {
            AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
            Key key = this.getKey(id, entity);
            Record record = this.client.operate(null, key, new Operation[]{Operation.getHeader()});
            return record != null;
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> Stream<T> findAll(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Type must not be null!");
        return this.findAllUsingQuery(entityClass, null, null);
    }

    @Override
    public <T> T findById(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Type must not be null!");
        try {
            Record record;
            AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
            Key key = this.getKey(id, entity);
            if (entity.isTouchOnRead()) {
                Assert.state((!entity.hasExpirationProperty() ? 1 : 0) != 0, (String)"Touch on read is not supported for expiration property");
                record = this.getAndTouch(key, entity.getExpiration());
            } else {
                record = this.client.get(null, key);
            }
            return this.mapToEntity(key, entityClass, record);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    private Record getAndTouch(Key key, int expiration) {
        WritePolicy writePolicy = new WritePolicy(this.client.writePolicyDefault);
        writePolicy.expiration = expiration;
        if (this.client.exists(null, key)) {
            return this.client.operate(writePolicy, key, new Operation[]{Operation.touch(), Operation.get()});
        }
        return null;
    }

    @Override
    public <T> List<T> findByIds(Iterable<?> ids, Class<T> entityClass) {
        Assert.notNull(ids, (String)"List of ids must not be null!");
        Assert.notNull(entityClass, (String)"Type must not be null!");
        return this.findByIdsInternal(IterableConverter.toList(ids), entityClass);
    }

    private <T> List<T> findByIdsInternal(Collection<?> ids, Class<T> entityClass) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
            Key[] keys = (Key[])ids.stream().map(id -> this.getKey(id, entity)).toArray(Key[]::new);
            Record[] records = this.client.get(null, keys);
            return IntStream.range(0, keys.length).filter(index -> records[index] != null).mapToObj(index -> this.mapToEntity(keys[index], entityClass, records[index])).collect(Collectors.toList());
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> Iterable<T> aggregate(Filter filter, Class<T> entityClass, String module, String function, List<Value> arguments) {
        Assert.notNull(entityClass, (String)"Type must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        Statement statement = new Statement();
        if (filter != null) {
            statement.setFilter(filter);
        }
        statement.setSetName(entity.getSetName());
        statement.setNamespace(this.namespace);
        ResultSet resultSet = null;
        resultSet = arguments != null && arguments.size() > 0 ? this.client.queryAggregate(null, statement, module, function, arguments.toArray(new Value[0])) : this.client.queryAggregate(null, statement);
        return resultSet;
    }

    @Override
    public <T> Iterable<T> findAll(Sort sort, Class<T> entityClass) {
        throw new UnsupportedOperationException("not implemented");
    }

    public <T> boolean exists(Query query, Class<T> entityClass) {
        Assert.notNull((Object)query, (String)"Query passed in to exist can't be null");
        Assert.notNull(entityClass, (String)"Type must not be null!");
        return this.find(query, entityClass).findAny().isPresent();
    }

    @Override
    public <T> T execute(Supplier<T> supplier) {
        Assert.notNull(supplier, (String)"Supplier must not be null!");
        try {
            return supplier.get();
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> long count(Query query, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Type must not be null!");
        Stream<KeyRecord> results = this.findAllRecordsUsingQuery(entityClass, query);
        return results.count();
    }

    @Override
    public <T> Stream<T> find(Query query, Class<T> entityClass) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(entityClass, (String)"Type must not be null!");
        return this.findAllUsingQuery(entityClass, query);
    }

    @Override
    public <T> Stream<T> findInRange(long offset, long limit, Sort sort, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Type for count must not be null!");
        Stream<T> results = this.findAllUsingQuery(entityClass, null, null);
        return results.skip(offset).limit(limit);
    }

    @Override
    public <T> long count(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Type for count must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        return this.count(entityClass, entity.getSetName());
    }

    @Override
    public AerospikeClient getAerospikeClient() {
        return this.client;
    }

    @Override
    public <T> long count(Class<T> entityClass, String setName) {
        Assert.notNull(entityClass, (String)"Type for count must not be null!");
        Node[] nodes = this.client.getNodes();
        int replicationCount = 2;
        int nodeCount = nodes.length;
        int n_objects = 0;
        for (Node node : nodes) {
            String infoString = Info.request((Node)node, (String)("sets/" + this.namespace + "/" + setName));
            String n_objectsString = infoString.substring(infoString.indexOf("=") + 1, infoString.indexOf(":"));
            n_objects = Integer.parseInt(n_objectsString);
        }
        return nodeCount > 1 ? (long)(n_objects / replicationCount) : (long)n_objects;
    }

    @Override
    public <T> T prepend(T objectToPrependTo, String fieldName, String value) {
        Assert.notNull(objectToPrependTo, (String)"Object to prepend to must not be null!");
        try {
            AerospikeWriteData data = this.writeData(objectToPrependTo);
            Record record = this.client.operate(null, data.getKey(), new Operation[]{Operation.prepend((Bin)new Bin(fieldName, value)), Operation.get((String)fieldName)});
            return this.mapToEntity(data.getKey(), this.getEntityClass(objectToPrependTo), record);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> T prepend(T objectToPrependTo, Map<String, String> values) {
        Assert.notNull(objectToPrependTo, (String)"Object to prepend to must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        try {
            AerospikeWriteData data = this.writeData(objectToPrependTo);
            Operation[] ops = OperationUtils.operations(values, Operation.Type.PREPEND, Operation.get());
            Record record = this.client.operate(null, data.getKey(), ops);
            return this.mapToEntity(data.getKey(), this.getEntityClass(objectToPrependTo), record);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> T append(T objectToAppendTo, Map<String, String> values) {
        Assert.notNull(objectToAppendTo, (String)"Object to append to must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        try {
            AerospikeWriteData data = this.writeData(objectToAppendTo);
            Operation[] ops = OperationUtils.operations(values, Operation.Type.APPEND, Operation.get());
            Record record = this.client.operate(null, data.getKey(), ops);
            return this.mapToEntity(data.getKey(), this.getEntityClass(objectToAppendTo), record);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> T append(T objectToAppendTo, String binName, String value) {
        Assert.notNull(objectToAppendTo, (String)"Object to append to must not be null!");
        try {
            AerospikeWriteData data = this.writeData(objectToAppendTo);
            Record record = this.client.operate(null, data.getKey(), new Operation[]{Operation.append((Bin)new Bin(binName, value)), Operation.get((String)binName)});
            return this.mapToEntity(data.getKey(), this.getEntityClass(objectToAppendTo), record);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> T add(T objectToAddTo, Map<String, Long> values) {
        Assert.notNull(objectToAddTo, (String)"Object to add to must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        try {
            AerospikeWriteData data = this.writeData(objectToAddTo);
            Operation[] ops = OperationUtils.operations(values, Operation.Type.ADD, Operation.get());
            WritePolicy writePolicy = new WritePolicy(this.client.writePolicyDefault);
            writePolicy.expiration = data.getExpiration();
            Record record = this.client.operate(writePolicy, data.getKey(), ops);
            return this.mapToEntity(data.getKey(), this.getEntityClass(objectToAddTo), record);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> T add(T objectToAddTo, String binName, long value) {
        Assert.notNull(objectToAddTo, (String)"Object to add to must not be null!");
        Assert.notNull((Object)binName, (String)"Bin name must not be null!");
        try {
            AerospikeWriteData data = this.writeData(objectToAddTo);
            WritePolicy writePolicy = new WritePolicy(this.client.writePolicyDefault);
            writePolicy.expiration = data.getExpiration();
            Record record = this.client.operate(writePolicy, data.getKey(), new Operation[]{Operation.add((Bin)new Bin(binName, value)), Operation.get()});
            return this.mapToEntity(data.getKey(), this.getEntityClass(objectToAddTo), record);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    private void doPersistAndHandleError(AerospikeWriteData data, WritePolicy policy) {
        try {
            this.put(data, policy);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    private <T> void doPersistWithVersionAndHandleCasError(T document, AerospikeWriteData data, WritePolicy policy) {
        try {
            Record newRecord = this.putAndGetHeader(data, policy);
            this.updateVersion(document, newRecord);
        }
        catch (AerospikeException e) {
            throw this.translateCasError(e);
        }
    }

    private <T> void doPersistWithVersionAndHandleError(T document, AerospikeWriteData data, WritePolicy policy) {
        try {
            Record newRecord = this.putAndGetHeader(data, policy);
            this.updateVersion(document, newRecord);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    private void put(AerospikeWriteData data, WritePolicy policy) {
        Key key = data.getKey();
        Bin[] bins = data.getBinsAsArray();
        this.client.put(policy, key, bins);
    }

    private Record putAndGetHeader(AerospikeWriteData data, WritePolicy policy) {
        Key key = data.getKey();
        Bin[] bins = data.getBinsAsArray();
        Operation[] operations = OperationUtils.operations(bins, Operation::put, Operation.getHeader());
        return this.client.operate(policy, key, operations);
    }

    <T> Stream<T> findAllUsingQuery(Class<T> type, Query query) {
        if ((query.getSort() == null || query.getSort().isUnsorted()) && query.getOffset() > 0L) {
            throw new IllegalArgumentException("Unsorted query must not have offset value. For retrieving paged results use sorted query.");
        }
        Qualifier qualifier = query.getCriteria().getCriteriaObject();
        Stream<?> results = this.findAllUsingQuery(type, null, qualifier);
        if (query.getSort() != null && query.getSort().isSorted()) {
            Comparator<?> comparator = this.getComparator(query);
            results = results.sorted(comparator);
        }
        if (query.hasOffset()) {
            results = results.skip(query.getOffset());
        }
        if (query.hasRows()) {
            results = results.limit(query.getRows());
        }
        return results;
    }

    <T> Stream<T> findAllUsingQuery(Class<T> type, Filter filter, Qualifier ... qualifiers) {
        return this.findAllRecordsUsingQuery(type, filter, qualifiers).map(keyRecord -> this.mapToEntity(keyRecord.key, type, keyRecord.record));
    }

    <T> Stream<KeyRecord> findAllRecordsUsingQuery(Class<T> type, Filter filter, Qualifier ... qualifiers) {
        String setName = this.getSetName((Class)type);
        KeyRecordIterator recIterator = this.queryEngine.select(this.namespace, setName, filter, qualifiers);
        return (Stream)StreamUtils.createStreamFromIterator((Iterator)recIterator).onClose(() -> {
            try {
                recIterator.close();
            }
            catch (Exception e) {
                log.error("Caught exception while closing query", (Throwable)e);
            }
        });
    }

    <T> Stream<KeyRecord> findAllRecordsUsingQuery(Class<T> type, Query query) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        Qualifier qualifier = query.getCriteria().getCriteriaObject();
        return this.findAllRecordsUsingQuery(type, null, qualifier);
    }
}

