/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Log;
import com.aerospike.client.Record;
import com.aerospike.client.policy.GenerationPolicy;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import java.util.Collections;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.support.PropertyComparator;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.aerospike.convert.AerospikeCustomConversions;
import org.springframework.data.aerospike.convert.AerospikeReadData;
import org.springframework.data.aerospike.convert.AerospikeTypeAliasAccessor;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.DefaultAerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.WritePolicyBuilder;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.BasicAerospikePersistentEntity;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.util.Assert;
import org.springframework.util.comparator.CompoundComparator;

abstract class BaseAerospikeTemplate {
    private static final Logger log = LoggerFactory.getLogger(BaseAerospikeTemplate.class);
    protected final MappingContext<BasicAerospikePersistentEntity<?>, AerospikePersistentProperty> mappingContext;
    protected final MappingAerospikeConverter converter;
    protected final String namespace;
    protected final AerospikeExceptionTranslator exceptionTranslator;
    protected final WritePolicy writePolicyDefault;

    BaseAerospikeTemplate(String namespace, MappingAerospikeConverter converter, AerospikeMappingContext mappingContext, AerospikeExceptionTranslator exceptionTranslator, WritePolicy writePolicyDefault) {
        Assert.notNull((Object)writePolicyDefault, (String)"Write policy must not be null!");
        Assert.notNull((Object)namespace, (String)"Namespace cannot be null");
        Assert.hasLength((String)namespace, (String)"Namespace cannot be empty");
        this.converter = converter;
        this.exceptionTranslator = exceptionTranslator;
        this.namespace = namespace;
        this.mappingContext = mappingContext;
        this.writePolicyDefault = writePolicyDefault;
        this.loggerSetup();
    }

    BaseAerospikeTemplate(String namespace, WritePolicy writePolicyDefault) {
        Assert.notNull((Object)writePolicyDefault, (String)"Write policy must not be null!");
        Assert.notNull((Object)namespace, (String)"Namespace cannot be null");
        Assert.hasLength((String)namespace, (String)"Namespace cannot be empty");
        AerospikeCustomConversions customConversions = new AerospikeCustomConversions(Collections.emptyList());
        AerospikeMappingContext asContext = new AerospikeMappingContext();
        asContext.setDefaultNameSpace(namespace);
        this.converter = new MappingAerospikeConverter(asContext, customConversions, new AerospikeTypeAliasAccessor());
        this.exceptionTranslator = new DefaultAerospikeExceptionTranslator();
        this.namespace = namespace;
        this.mappingContext = asContext;
        this.writePolicyDefault = writePolicyDefault;
        this.converter.afterPropertiesSet();
        this.loggerSetup();
    }

    private void loggerSetup() {
        Logger log = LoggerFactory.getLogger((String)"com.aerospike.client");
        Log.setCallback((level, message) -> {
            switch (level) {
                case INFO: {
                    log.info("{}", (Object)message);
                    break;
                }
                case DEBUG: {
                    log.debug("{}", (Object)message);
                    break;
                }
                case ERROR: {
                    log.error("{}", (Object)message);
                    break;
                }
                case WARN: {
                    log.warn("{}", (Object)message);
                }
            }
        });
    }

    public <T> String getSetName(Class<T> entityClass) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        return entity.getSetName();
    }

    public MappingContext<?, ?> getMappingContext() {
        return this.mappingContext;
    }

    public String getNamespace() {
        return this.namespace;
    }

    <T> Class<T> getEntityClass(T entity) {
        return entity.getClass();
    }

    <T> T mapToEntity(Key key, Class<T> type, Record record) {
        if (record == null) {
            return null;
        }
        AerospikeReadData data = AerospikeReadData.forRead(key, record);
        return this.converter.read(type, data);
    }

    protected Comparator<?> getComparator(Query query) {
        CompoundComparator compoundComperator = new CompoundComparator();
        for (Sort.Order order : query.getSort()) {
            if (Sort.Direction.DESC.equals((Object)order.getDirection())) {
                compoundComperator.addComparator((Comparator)new PropertyComparator(order.getProperty(), true, false));
                continue;
            }
            compoundComperator.addComparator((Comparator)new PropertyComparator(order.getProperty(), true, true));
        }
        return compoundComperator;
    }

    <T> ConvertingPropertyAccessor<T> getPropertyAccessor(AerospikePersistentEntity<?> entity, T source) {
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(source);
        return new ConvertingPropertyAccessor(accessor, this.converter.getConversionService());
    }

    <T> T updateVersion(T document, Record newRecord) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        ConvertingPropertyAccessor<T> propertyAccessor = this.getPropertyAccessor(entity, document);
        AerospikePersistentProperty versionProperty = (AerospikePersistentProperty)entity.getRequiredVersionProperty();
        propertyAccessor.setProperty((PersistentProperty)versionProperty, (Object)newRecord.generation);
        return document;
    }

    RuntimeException translateCasError(AerospikeException e) {
        int code = e.getResultCode();
        if (code == 5 || code == 3) {
            return new OptimisticLockingFailureException("Save document with version value failed", (Throwable)e);
        }
        return this.translateError(e);
    }

    RuntimeException translateError(AerospikeException e) {
        DataAccessException translated = this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
        return translated == null ? e : translated;
    }

    <T> AerospikeWriteData writeData(T document) {
        AerospikeWriteData data = AerospikeWriteData.forWrite();
        this.converter.write(document, data);
        return data;
    }

    WritePolicy expectGenerationCasAwareSavePolicy(AerospikeWriteData data) {
        RecordExistsAction recordExistsAction = data.getVersion().filter(v -> (long)v.intValue() > 0L).map(v -> RecordExistsAction.REPLACE_ONLY).orElse(RecordExistsAction.CREATE_ONLY);
        return this.expectGenerationSavePolicy(data, recordExistsAction);
    }

    WritePolicy expectGenerationSavePolicy(AerospikeWriteData data, RecordExistsAction recordExistsAction) {
        return WritePolicyBuilder.builder(this.writePolicyDefault).generationPolicy(GenerationPolicy.EXPECT_GEN_EQUAL).generation(data.getVersion().orElse(0)).sendKey(true).expiration(data.getExpiration()).recordExistsAction(recordExistsAction).build();
    }

    WritePolicy ignoreGenerationSavePolicy(AerospikeWriteData data, RecordExistsAction recordExistsAction) {
        return WritePolicyBuilder.builder(this.writePolicyDefault).generationPolicy(GenerationPolicy.NONE).sendKey(true).expiration(data.getExpiration()).recordExistsAction(recordExistsAction).build();
    }

    WritePolicy ignoreGenerationDeletePolicy() {
        return WritePolicyBuilder.builder(this.writePolicyDefault).generationPolicy(GenerationPolicy.NONE).build();
    }

    Key getKey(Object id, AerospikePersistentEntity<?> entity) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        String userKey = this.convertIfNecessary(id, String.class);
        return new Key(this.namespace, entity.getSetName(), userKey);
    }

    private <S> S convertIfNecessary(Object source, Class<S> type) {
        return (S)(type.isAssignableFrom(source.getClass()) ? source : this.converter.getConversionService().convert(source, type));
    }
}

