/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.config;

import java.util.Map;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.aerospike.repository.query.AerospikeQueryCreator;
import org.springframework.data.keyvalue.repository.config.KeyValueRepositoryConfigurationExtension;
import org.springframework.data.keyvalue.repository.config.QueryCreatorType;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;

public abstract class BaseAerospikeRepositoryConfigurationExtension
extends KeyValueRepositoryConfigurationExtension {
    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyReference("operations", attributes.getString("keyValueTemplateRef"));
        builder.addPropertyValue("queryCreator", BaseAerospikeRepositoryConfigurationExtension.getQueryCreatorType(config));
        builder.addPropertyReference("mappingContext", "keyValueMappingContext");
    }

    private static Class<?> getQueryCreatorType(AnnotationRepositoryConfigurationSource config) {
        AnnotationMetadata metadata = config.getEnableAnnotationMetadata();
        Map queryCreatorFoo = metadata.getAnnotationAttributes(QueryCreatorType.class.getName());
        if (queryCreatorFoo == null) {
            return AerospikeQueryCreator.class;
        }
        AnnotationAttributes queryCreatorAttributes = new AnnotationAttributes(queryCreatorFoo);
        return queryCreatorAttributes.getClass("value");
    }
}

