/*******************************************************************************
 * Copyright (c) 2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 * 		https://www.apache.org/licenses/LICENSE-2.0
 *  	
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package org.springframework.data.aerospike.mapping;

import java.util.*;

import org.springframework.data.mapping.model.SimpleTypeHolder;

/**
 * Simple constant holder for a {@link SimpleTypeHolder} enriched with Aerospike specific simple types.
 * 
 * @author Oliver Gierke
 * @author Peter Milne
 */
public abstract class AerospikeSimpleTypes {

	public static final Set<Class<?>> AUTOGENERATED_ID_TYPES;

	static {
		Set<Class<?>> classes = new HashSet<Class<?>>();
		classes.add(String.class);
		classes.add(Integer.class);
		classes.add(Long.class);
		AUTOGENERATED_ID_TYPES = Collections.unmodifiableSet(classes);

		Set<Class<?>> simpleTypes = new HashSet<Class<?>>();
		simpleTypes.add(boolean.class);
		simpleTypes.add(boolean[].class);
		simpleTypes.add(long.class);
		simpleTypes.add(long[].class);
		simpleTypes.add(short.class);
		simpleTypes.add(short[].class);
		simpleTypes.add(int.class);
		simpleTypes.add(int[].class);
		simpleTypes.add(byte.class);
		simpleTypes.add(byte[].class);
		simpleTypes.add(float.class);
		simpleTypes.add(float[].class);
		simpleTypes.add(double.class);
		simpleTypes.add(double[].class);
		simpleTypes.add(char.class);
		simpleTypes.add(char[].class);
		simpleTypes.add(Boolean.class);
		simpleTypes.add(Long.class);
		simpleTypes.add(Short.class);
		simpleTypes.add(Integer.class);
		simpleTypes.add(Byte.class);
		simpleTypes.add(Float.class);
		simpleTypes.add(Double.class);
		simpleTypes.add(Character.class);
		simpleTypes.add(String.class);
		simpleTypes.add(Date.class);
		simpleTypes.add(Locale.class);
		simpleTypes.add(Class.class);
		simpleTypes.add(Enum.class);
		simpleTypes.add(Byte[].class);
		simpleTypes.add(UUID.class);
		AEROSPIKE_SIMPLE_TYPES = Collections.unmodifiableSet(simpleTypes);
	}

	private static final Set<Class<?>> AEROSPIKE_SIMPLE_TYPES;
	public static final SimpleTypeHolder HOLDER = new SimpleTypeHolder(AEROSPIKE_SIMPLE_TYPES, Boolean.FALSE);

	private AerospikeSimpleTypes() {}

}
