/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.cache;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.policy.WritePolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.cache.transaction.AbstractTransactionSupportingCacheManager;
import org.springframework.cache.transaction.TransactionAwareCacheDecorator;
import org.springframework.data.aerospike.cache.AerospikeCache;
import org.springframework.data.aerospike.convert.AerospikeConverter;
import org.springframework.data.aerospike.convert.AerospikeReadData;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.util.Assert;

public class AerospikeCacheManager
extends AbstractTransactionSupportingCacheManager {
    protected static final String DEFAULT_SET_NAME = "aerospike";
    private final AerospikeClient aerospikeClient;
    private final AerospikeConverter aerospikeConverter;
    private final String setName;
    private final Set<String> configuredCacheNames;

    public AerospikeCacheManager(AerospikeClient aerospikeClient, MappingAerospikeConverter aerospikeConverter) {
        this(aerospikeClient, Collections.emptyList(), aerospikeConverter);
    }

    public AerospikeCacheManager(AerospikeClient aerospikeClient, String setName, MappingAerospikeConverter aerospikeConverter) {
        this(aerospikeClient, Collections.emptyList(), setName, aerospikeConverter);
    }

    public AerospikeCacheManager(AerospikeClient aerospikeClient, Collection<String> cacheNames, MappingAerospikeConverter aerospikeConverter) {
        this(aerospikeClient, cacheNames, DEFAULT_SET_NAME, aerospikeConverter);
    }

    public AerospikeCacheManager(AerospikeClient aerospikeClient, Collection<String> cacheNames, String setName, MappingAerospikeConverter aerospikeConverter) {
        Assert.notNull((Object)aerospikeClient, (String)"AerospikeClient must not be null");
        Assert.notNull(cacheNames, (String)"Cache names must not be null");
        Assert.notNull((Object)setName, (String)"Set name must not be null");
        this.aerospikeClient = aerospikeClient;
        this.aerospikeConverter = aerospikeConverter;
        this.setName = setName;
        this.configuredCacheNames = new LinkedHashSet<String>(cacheNames);
    }

    protected Collection<? extends Cache> loadCaches() {
        ArrayList<AerospikeCache> caches = new ArrayList<AerospikeCache>();
        for (String cacheName : this.configuredCacheNames) {
            caches.add(this.createCache(cacheName));
        }
        return caches;
    }

    protected Cache getMissingCache(String cacheName) {
        return this.createCache(cacheName);
    }

    protected AerospikeCache createCache(String cacheName) {
        return new AerospikeSerializingCache(cacheName);
    }

    public Cache getCache(String name) {
        Cache cache = this.lookupAerospikeCache(name);
        if (cache != null) {
            return cache;
        }
        Cache missingCache = this.getMissingCache(name);
        if (missingCache != null) {
            this.addCache(missingCache);
            return this.lookupAerospikeCache(name);
        }
        return null;
    }

    protected Cache lookupAerospikeCache(String name) {
        return this.lookupCache(name + ":" + this.setName);
    }

    protected Cache decorateCache(Cache cache) {
        if (this.isCacheAlreadyDecorated(cache)) {
            return cache;
        }
        return super.decorateCache(cache);
    }

    protected boolean isCacheAlreadyDecorated(Cache cache) {
        return this.isTransactionAware() && cache instanceof TransactionAwareCacheDecorator;
    }

    public class AerospikeSerializingCache
    extends AerospikeCache {
        public AerospikeSerializingCache(String namespace) {
            super(namespace, AerospikeCacheManager.this.setName, AerospikeCacheManager.this.aerospikeClient, -1L);
        }

        @Override
        public <T> T get(Object key, Class<T> type) {
            Key dbKey = this.getKey(key);
            Record record = this.client.get(null, dbKey);
            if (record != null) {
                AerospikeReadData data = AerospikeReadData.forRead(dbKey, record);
                Object value = AerospikeCacheManager.this.aerospikeConverter.read(type, data);
                return (T)value;
            }
            return null;
        }

        @Override
        public Cache.ValueWrapper get(Object key) {
            Object value = this.get(key, Object.class);
            return value != null ? new SimpleValueWrapper(value) : null;
        }

        private void serializeAndPut(WritePolicy writePolicy, Object key, Object value) {
            AerospikeWriteData data = AerospikeWriteData.forWrite();
            AerospikeCacheManager.this.aerospikeConverter.write(value, data);
            this.client.put(writePolicy, this.getKey(key), data.getBinsAsArray());
        }

        @Override
        public void put(Object key, Object value) {
            this.serializeAndPut(null, key, value);
        }

        @Override
        public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
            this.serializeAndPut(this.createOnly, key, value);
            return this.get(key);
        }
    }
}

