/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.dao.RecoverableDataAccessException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.data.aerospike.IndexAlreadyExistsException;
import org.springframework.data.aerospike.IndexNotFoundException;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;

public class DefaultAerospikeExceptionTranslator
implements AerospikeExceptionTranslator {
    public DataAccessException translateExceptionIfPossible(RuntimeException cause) {
        if (cause instanceof AerospikeException) {
            int resultCode = ((AerospikeException)((Object)cause)).getResultCode();
            String msg = cause.getMessage();
            if (cause instanceof AerospikeException.Connection && resultCode == -8) {
                return new QueryTimeoutException(msg, (Throwable)cause);
            }
            switch (resultCode) {
                case 4: {
                    return new InvalidDataAccessApiUsageException(msg, (Throwable)cause);
                }
                case 5: {
                    return new DuplicateKeyException(msg, (Throwable)cause);
                }
                case 2: {
                    return new DataRetrievalFailureException(msg, (Throwable)cause);
                }
                case 201: {
                    return new IndexNotFoundException(msg, cause);
                }
                case 200: {
                    return new IndexAlreadyExistsException(msg, cause);
                }
                case 9: 
                case 212: {
                    return new QueryTimeoutException(msg, (Throwable)cause);
                }
                case -7: 
                case 14: 
                case 18: {
                    return new TransientDataAccessResourceException(msg, (Throwable)cause);
                }
            }
            return new RecoverableDataAccessException(msg, (Throwable)cause);
        }
        return null;
    }
}

