/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.index;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.data.aerospike.annotation.Indexed;
import org.springframework.data.aerospike.index.AerospikeIndexDefinition;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.BasicAerospikePersistentEntity;
import org.springframework.util.StringUtils;

public class AerospikeIndexResolver {
    public Set<AerospikeIndexDefinition> detectIndexes(BasicAerospikePersistentEntity<?> persistentEntity) {
        return StreamSupport.stream(persistentEntity.spliterator(), false).filter(property -> property.isAnnotationPresent(Indexed.class)).map(property -> this.convertToIndex(persistentEntity, (AerospikePersistentProperty)property)).collect(Collectors.toSet());
    }

    private AerospikeIndexDefinition convertToIndex(BasicAerospikePersistentEntity<?> persistentEntity, AerospikePersistentProperty property) {
        Indexed annotation = (Indexed)property.getRequiredAnnotation(Indexed.class);
        String indexName = StringUtils.isEmpty((Object)annotation.name()) ? this.getIndexName(persistentEntity, property, annotation) : annotation.name();
        return AerospikeIndexDefinition.builder().entityClass(persistentEntity.getType()).fieldName(property.getFieldName()).name(indexName).type(annotation.type()).collectionType(annotation.collectionType()).build();
    }

    private String getIndexName(BasicAerospikePersistentEntity<?> entity, AerospikePersistentProperty property, Indexed annotation) {
        return String.join((CharSequence)"_", entity.getSetName(), property.getFieldName(), annotation.type().name().toLowerCase(), annotation.collectionType().name().toLowerCase());
    }
}

