/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.Value;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.IndexCollectionType;
import com.aerospike.client.query.PredExp;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.aerospike.query.PredExpException;

public class Qualifier
implements Map<String, Object>,
Serializable {
    private static final long serialVersionUID = -2689196529952712849L;
    private static final String listIterVar = "listIterVar";
    private static final String mapIterVar = "mapIterVar";
    private static final String FIELD = "field";
    private static final String IGNORE_CASE = "ignoreCase";
    private static final String VALUE2 = "value2";
    private static final String VALUE1 = "value1";
    private static final String QUALIFIERS = "qualifiers";
    private static final String OPERATION = "operation";
    private static final String AS_FILTER = "queryAsFilter";
    protected Map<String, Object> internalMap = new HashMap<String, Object>();

    public Qualifier() {
    }

    public Qualifier(FilterOperation operation, Qualifier ... qualifiers) {
        this();
        this.internalMap.put(QUALIFIERS, qualifiers);
        this.internalMap.put(OPERATION, (Object)operation);
    }

    public Qualifier(String field, FilterOperation operation, Value value1) {
        this(field, operation, Boolean.FALSE, value1);
    }

    public Qualifier(String field, FilterOperation operation, Boolean ignoreCase, Value value1) {
        this();
        this.internalMap.put(FIELD, field);
        this.internalMap.put(OPERATION, (Object)operation);
        this.internalMap.put(VALUE1, value1);
        this.internalMap.put(IGNORE_CASE, ignoreCase);
    }

    public Qualifier(String field, FilterOperation operation, Value value1, Value value2) {
        this(field, operation, Boolean.FALSE, value1);
        this.internalMap.put(VALUE2, value2);
    }

    public FilterOperation getOperation() {
        return (FilterOperation)((Object)this.internalMap.get(OPERATION));
    }

    public String getField() {
        return (String)this.internalMap.get(FIELD);
    }

    public PredExp getFieldExpr(int valType) {
        switch (valType) {
            case 1: {
                return PredExp.integerBin((String)this.getField());
            }
            case 3: {
                return PredExp.stringBin((String)this.getField());
            }
            case 23: {
                return PredExp.geoJSONBin((String)this.getField());
            }
        }
        throw new PredExpException("PredExp Unsupported Particle Type: " + valType);
    }

    public void asFilter(Boolean queryAsFilter) {
        this.internalMap.put(AS_FILTER, queryAsFilter);
    }

    public Boolean queryAsFilter() {
        return this.internalMap.containsKey(AS_FILTER) && (Boolean)this.internalMap.get(AS_FILTER) != false;
    }

    public Qualifier[] getQualifiers() {
        return (Qualifier[])this.internalMap.get(QUALIFIERS);
    }

    public Value getValue1() {
        return (Value)this.internalMap.get(VALUE1);
    }

    public Value getValue2() {
        return (Value)this.internalMap.get(VALUE2);
    }

    public Filter asFilter() {
        FilterOperation op = this.getOperation();
        switch (op) {
            case EQ: {
                if (this.getValue1().getType() == 1) {
                    return Filter.equal((String)this.getField(), (long)this.getValue1().toLong());
                }
                if (this.ignoreCase().booleanValue()) {
                    return null;
                }
                return Filter.equal((String)this.getField(), (String)this.getValue1().toString());
            }
            case GTEQ: 
            case BETWEEN: {
                return Filter.range((String)this.getField(), (long)this.getValue1().toLong(), (long)(this.getValue2() == null ? Long.MAX_VALUE : this.getValue2().toLong()));
            }
            case GT: {
                return Filter.range((String)this.getField(), (long)(this.getValue1().toLong() + 1L), (long)(this.getValue2() == null ? Long.MAX_VALUE : this.getValue2().toLong()));
            }
            case LT: {
                return Filter.range((String)this.getField(), (long)Long.MIN_VALUE, (long)(this.getValue1().toLong() - 1L));
            }
            case LTEQ: {
                return Filter.range((String)this.getField(), (long)Long.MIN_VALUE, (long)this.getValue1().toLong());
            }
            case LIST_CONTAINS: {
                return this.collectionContains(IndexCollectionType.LIST);
            }
            case MAP_KEYS_CONTAINS: {
                return this.collectionContains(IndexCollectionType.MAPKEYS);
            }
            case MAP_VALUES_CONTAINS: {
                return this.collectionContains(IndexCollectionType.MAPVALUES);
            }
            case LIST_BETWEEN: {
                return this.collectionRange(IndexCollectionType.LIST);
            }
            case MAP_KEYS_BETWEEN: {
                return this.collectionRange(IndexCollectionType.MAPKEYS);
            }
            case MAP_VALUES_BETWEEN: {
                return this.collectionRange(IndexCollectionType.MAPVALUES);
            }
            case GEO_WITHIN: {
                return this.geoWithinRadius(IndexCollectionType.DEFAULT);
            }
        }
        return null;
    }

    private Filter geoWithinRadius(IndexCollectionType collectionType) {
        return Filter.geoContains((String)this.getField(), (String)this.getValue1().toString());
    }

    private Filter collectionContains(IndexCollectionType collectionType) {
        Value val = this.getValue1();
        int valType = val.getType();
        switch (valType) {
            case 1: {
                return Filter.contains((String)this.getField(), (IndexCollectionType)collectionType, (long)val.toLong());
            }
            case 3: {
                return Filter.contains((String)this.getField(), (IndexCollectionType)collectionType, (String)val.toString());
            }
        }
        return null;
    }

    private Filter collectionRange(IndexCollectionType collectionType) {
        return Filter.range((String)this.getField(), (IndexCollectionType)collectionType, (long)this.getValue1().toLong(), (long)this.getValue2().toLong());
    }

    public List<PredExp> toPredExp() {
        int regexFlags = this.ignoreCase() != false ? 2 : 0;
        ArrayList<PredExp> rs = new ArrayList<PredExp>();
        block0 : switch (this.getOperation()) {
            case AND: {
                Qualifier[] qs;
                for (Qualifier q : qs = (Qualifier[])this.get(QUALIFIERS)) {
                    rs.addAll(q.toPredExp());
                }
                rs.add(PredExp.and((int)qs.length));
                break;
            }
            case OR: {
                Qualifier[] qs;
                for (Qualifier q : qs = (Qualifier[])this.get(QUALIFIERS)) {
                    rs.addAll(q.toPredExp());
                }
                rs.add(PredExp.or((int)qs.length));
                break;
            }
            case IN: {
                Value val = this.getValue1();
                int valType = val.getType();
                if (valType != 20) {
                    throw new IllegalArgumentException("FilterOperation.IN expects List argument with type: 20, but got: " + valType);
                }
                List inList = (List)val.getObject();
                for (Object value : inList) {
                    rs.addAll(new Qualifier(this.getField(), FilterOperation.EQ, Value.get(value)).toPredExp());
                }
                rs.add(PredExp.or((int)inList.size()));
                break;
            }
            case EQ: {
                Value val = this.getValue1();
                int valType = val.getType();
                switch (valType) {
                    case 1: {
                        rs.add(this.getFieldExpr(valType));
                        rs.add(PredExp.integerValue((long)val.toLong()));
                        rs.add(PredExp.integerEqual());
                        break block0;
                    }
                    case 3: {
                        if (this.ignoreCase().booleanValue()) {
                            String equalsRegexp = QualifierRegexpBuilder.getStringEquals(this.getValue1().toString());
                            rs.add(this.getFieldExpr(this.getValue1().getType()));
                            rs.add(PredExp.stringValue((String)equalsRegexp));
                            rs.add(PredExp.stringRegex((int)2));
                            break block0;
                        }
                        rs.add(this.getFieldExpr(valType));
                        rs.add(PredExp.stringValue((String)val.toString()));
                        rs.add(PredExp.stringEqual());
                        break block0;
                    }
                }
                throw new PredExpException("PredExp Unsupported Particle Type: " + valType);
            }
            case NOTEQ: {
                rs.addAll(Arrays.asList(this.valToPredExp(this.getValue1())));
                rs.add(this.getValue1().getType() == 1 ? PredExp.integerUnequal() : PredExp.stringUnequal());
                break;
            }
            case GT: {
                rs.addAll(Arrays.asList(this.valToPredExp(this.getValue1())));
                rs.add(PredExp.integerGreater());
                break;
            }
            case GTEQ: {
                rs.addAll(Arrays.asList(this.valToPredExp(this.getValue1())));
                rs.add(PredExp.integerGreaterEq());
                break;
            }
            case LT: {
                rs.addAll(Arrays.asList(this.valToPredExp(this.getValue1())));
                rs.add(PredExp.integerLess());
                break;
            }
            case LTEQ: {
                rs.addAll(Arrays.asList(this.valToPredExp(this.getValue1())));
                rs.add(PredExp.integerLessEq());
                break;
            }
            case BETWEEN: {
                return new Qualifier(FilterOperation.AND, new Qualifier(this.getField(), FilterOperation.GTEQ, this.getValue1()), new Qualifier(this.getField(), FilterOperation.LTEQ, this.getValue2())).toPredExp();
            }
            case GEO_WITHIN: {
                rs.addAll(Arrays.asList(this.valToPredExp(this.getValue1())));
                rs.add(PredExp.geoJSONWithin());
                break;
            }
            case START_WITH: {
                String startWithRegexp = QualifierRegexpBuilder.getStartsWith(this.getValue1().toString());
                rs.add(this.getFieldExpr(this.getValue1().getType()));
                rs.add(PredExp.stringValue((String)startWithRegexp));
                rs.add(PredExp.stringRegex((int)regexFlags));
                break;
            }
            case ENDS_WITH: {
                String endWithRegexp = QualifierRegexpBuilder.getEndsWith(this.getValue1().toString());
                rs.add(this.getFieldExpr(this.getValue1().getType()));
                rs.add(PredExp.stringValue((String)endWithRegexp));
                rs.add(PredExp.stringRegex((int)regexFlags));
                break;
            }
            case CONTAINING: {
                String containingRegexp = QualifierRegexpBuilder.getContaining(this.getValue1().toString());
                rs.add(this.getFieldExpr(this.getValue1().getType()));
                rs.add(PredExp.stringValue((String)containingRegexp));
                rs.add(PredExp.stringRegex((int)regexFlags));
                break;
            }
            case LIST_CONTAINS: {
                if (this.getValue1().getType() == 3) {
                    rs.add(PredExp.stringVar((String)listIterVar));
                    rs.add(PredExp.stringValue((String)this.getValue1().toString()));
                    rs.add(PredExp.stringEqual());
                } else {
                    rs.add(PredExp.integerVar((String)listIterVar));
                    rs.add(PredExp.integerValue((long)this.getValue1().toLong()));
                    rs.add(PredExp.integerEqual());
                }
                rs.add(PredExp.listBin((String)this.getField()));
                rs.add(PredExp.listIterateOr((String)listIterVar));
                break;
            }
            case MAP_KEYS_CONTAINS: {
                if (this.getValue1().getType() == 3) {
                    rs.add(PredExp.stringVar((String)mapIterVar));
                    rs.add(PredExp.stringValue((String)this.getValue1().toString()));
                    rs.add(PredExp.stringEqual());
                } else {
                    rs.add(PredExp.integerVar((String)mapIterVar));
                    rs.add(PredExp.integerValue((long)this.getValue1().toLong()));
                    rs.add(PredExp.integerEqual());
                }
                rs.add(PredExp.mapBin((String)this.getField()));
                rs.add(PredExp.mapKeyIterateOr((String)mapIterVar));
                break;
            }
            case MAP_VALUES_CONTAINS: {
                if (this.getValue1().getType() == 3) {
                    rs.add(PredExp.stringVar((String)mapIterVar));
                    rs.add(PredExp.stringValue((String)this.getValue1().toString()));
                    rs.add(PredExp.stringEqual());
                } else {
                    rs.add(PredExp.integerVar((String)mapIterVar));
                    rs.add(PredExp.integerValue((long)this.getValue1().toLong()));
                    rs.add(PredExp.integerEqual());
                }
                rs.add(PredExp.mapBin((String)this.getField()));
                rs.add(PredExp.mapValIterateOr((String)mapIterVar));
                break;
            }
            case LIST_BETWEEN: {
                rs.add(PredExp.integerVar((String)listIterVar));
                rs.add(PredExp.integerValue((long)this.getValue1().toLong()));
                rs.add(PredExp.integerGreaterEq());
                rs.add(PredExp.integerVar((String)listIterVar));
                rs.add(PredExp.integerValue((long)this.getValue2().toLong()));
                rs.add(PredExp.integerLessEq());
                rs.add(PredExp.and((int)2));
                rs.add(PredExp.listBin((String)this.getField()));
                rs.add(PredExp.listIterateOr((String)listIterVar));
                break;
            }
            case MAP_KEYS_BETWEEN: {
                rs.add(PredExp.integerVar((String)mapIterVar));
                rs.add(PredExp.integerValue((long)this.getValue1().toLong()));
                rs.add(PredExp.integerGreaterEq());
                rs.add(PredExp.integerVar((String)mapIterVar));
                rs.add(PredExp.integerValue((long)this.getValue2().toLong()));
                rs.add(PredExp.integerLessEq());
                rs.add(PredExp.and((int)2));
                rs.add(PredExp.mapBin((String)this.getField()));
                rs.add(PredExp.mapKeyIterateOr((String)mapIterVar));
                break;
            }
            case MAP_VALUES_BETWEEN: {
                rs.add(PredExp.integerVar((String)mapIterVar));
                rs.add(PredExp.integerValue((long)this.getValue1().toLong()));
                rs.add(PredExp.integerGreaterEq());
                rs.add(PredExp.integerVar((String)mapIterVar));
                rs.add(PredExp.integerValue((long)this.getValue2().toLong()));
                rs.add(PredExp.integerLessEq());
                rs.add(PredExp.and((int)2));
                rs.add(PredExp.mapBin((String)this.getField()));
                rs.add(PredExp.mapValIterateOr((String)mapIterVar));
                break;
            }
            default: {
                throw new PredExpException("PredExp Unsupported Operation: " + (Object)((Object)this.getOperation()));
            }
        }
        return rs;
    }

    private PredExp[] valToPredExp(Value val) {
        int valType = val.getType();
        switch (valType) {
            case 1: {
                return new PredExp[]{this.getFieldExpr(valType), PredExp.integerValue((long)val.toLong())};
            }
            case 3: {
                return new PredExp[]{this.getFieldExpr(valType), PredExp.stringValue((String)val.toString())};
            }
            case 23: {
                return new PredExp[]{this.getFieldExpr(valType), PredExp.geoJSONValue((String)val.toString())};
            }
        }
        throw new PredExpException("PredExp Unsupported Particle Type: " + val.getType());
    }

    private Boolean ignoreCase() {
        Boolean ignoreCase = (Boolean)this.internalMap.get(IGNORE_CASE);
        return ignoreCase == null ? false : ignoreCase;
    }

    protected String luaFieldString(String field) {
        return String.format("rec['%s']", field);
    }

    protected String luaValueString(Value value) {
        String res = null;
        if (null == value) {
            return res;
        }
        int type = value.getType();
        switch (type) {
            case 3: {
                res = String.format("'%s'", value.toString());
                break;
            }
            case 23: {
                res = String.format("'%s'", value.toString());
                break;
            }
            default: {
                res = value.toString();
            }
        }
        return res;
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.internalMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.internalMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.internalMap.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.internalMap.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.internalMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.internalMap.putAll(m);
    }

    @Override
    public void clear() {
        this.internalMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.internalMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.internalMap.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.internalMap.entrySet();
    }

    public String toString() {
        String output = String.format("%s:%s:%s:%s", new Object[]{this.getField(), this.getOperation(), this.getValue1(), this.getValue2()});
        return output;
    }

    public static enum FilterOperation {
        EQ,
        GT,
        GTEQ,
        LT,
        LTEQ,
        NOTEQ,
        BETWEEN,
        START_WITH,
        ENDS_WITH,
        CONTAINING,
        IN,
        LIST_CONTAINS,
        MAP_KEYS_CONTAINS,
        MAP_VALUES_CONTAINS,
        LIST_BETWEEN,
        MAP_KEYS_BETWEEN,
        MAP_VALUES_BETWEEN,
        GEO_WITHIN,
        OR,
        AND;

    }

    public static class QualifierRegexpBuilder {
        private static Character BACKSLASH = Character.valueOf('\\');
        private static Character DOT = Character.valueOf('.');
        private static Character ASTERISK = Character.valueOf('*');
        private static Character DOLLAR = Character.valueOf('$');
        private static Character OPEN_BRACKET = Character.valueOf('[');
        private static Character CIRCUMFLEX = Character.valueOf('^');

        public static String escapeBRERegexp(String base) {
            StringBuilder builder = new StringBuilder();
            for (char stringChar : base.toCharArray()) {
                if (stringChar == BACKSLASH.charValue() || stringChar == DOT.charValue() || stringChar == ASTERISK.charValue() || stringChar == DOLLAR.charValue() || stringChar == OPEN_BRACKET.charValue() || stringChar == CIRCUMFLEX.charValue()) {
                    builder.append(BACKSLASH);
                }
                builder.append(stringChar);
            }
            return builder.toString();
        }

        private static String getRegexp(String base, FilterOperation op) {
            String escapedBase = QualifierRegexpBuilder.escapeBRERegexp(base);
            if (op == FilterOperation.START_WITH) {
                return "^" + escapedBase;
            }
            if (op == FilterOperation.ENDS_WITH) {
                return escapedBase + "$";
            }
            if (op == FilterOperation.EQ) {
                return "^" + escapedBase + "$";
            }
            return escapedBase;
        }

        public static String getStartsWith(String base) {
            return QualifierRegexpBuilder.getRegexp(base, FilterOperation.START_WITH);
        }

        public static String getEndsWith(String base) {
            return QualifierRegexpBuilder.getRegexp(base, FilterOperation.ENDS_WITH);
        }

        public static String getContaining(String base) {
            return QualifierRegexpBuilder.getRegexp(base, FilterOperation.CONTAINING);
        }

        public static String getStringEquals(String base) {
            return QualifierRegexpBuilder.getRegexp(base, FilterOperation.EQ);
        }
    }
}

