/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import com.aerospike.client.Value;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.CachingAerospikePersistentProperty;
import org.springframework.data.aerospike.query.Qualifier;
import org.springframework.data.aerospike.repository.query.AerospikeCriteria;
import org.springframework.data.aerospike.repository.query.CriteriaDefinition;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.TypeInformation;

public class AerospikeQueryCreator
extends AbstractQueryCreator<Query, AerospikeCriteria> {
    private static final Logger LOG = LoggerFactory.getLogger(AerospikeQueryCreator.class);
    private MappingContext<?, AerospikePersistentProperty> context;

    public AerospikeQueryCreator(PartTree tree, ParameterAccessor parameters) {
        super(tree, parameters);
        this.context = new AerospikeMappingContext();
    }

    public AerospikeQueryCreator(PartTree tree, ParameterAccessor parameters, MappingContext<?, AerospikePersistentProperty> context) {
        super(tree, parameters);
        this.context = context;
    }

    protected AerospikeCriteria create(Part part, Iterator<Object> iterator) {
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        AerospikePersistentProperty property = (AerospikePersistentProperty)path.getLeafProperty();
        return this.create(part, property, iterator);
    }

    private AerospikeCriteria create(Part part, AerospikePersistentProperty property, Iterator<?> parameters) {
        Qualifier.FilterOperation op;
        String fieldName = ((CachingAerospikePersistentProperty)property).getFieldName();
        Part.IgnoreCaseType ignoreCase = part.shouldIgnoreCase();
        Object v1 = parameters.next();
        Object v2 = null;
        switch (part.getType()) {
            case AFTER: 
            case GREATER_THAN: {
                op = Qualifier.FilterOperation.GT;
                break;
            }
            case GREATER_THAN_EQUAL: {
                op = Qualifier.FilterOperation.GTEQ;
                break;
            }
            case BEFORE: 
            case LESS_THAN: {
                op = Qualifier.FilterOperation.LT;
                break;
            }
            case LESS_THAN_EQUAL: {
                op = Qualifier.FilterOperation.LTEQ;
                break;
            }
            case BETWEEN: {
                op = Qualifier.FilterOperation.BETWEEN;
                v2 = parameters.next();
                break;
            }
            case LIKE: 
            case STARTING_WITH: {
                op = Qualifier.FilterOperation.START_WITH;
                break;
            }
            case ENDING_WITH: {
                op = Qualifier.FilterOperation.ENDS_WITH;
                break;
            }
            case CONTAINING: {
                op = Qualifier.FilterOperation.CONTAINING;
                break;
            }
            case WITHIN: {
                op = Qualifier.FilterOperation.GEO_WITHIN;
                v1 = Value.get((String)String.format("{ \"type\": \"AeroCircle\", \"coordinates\": [[%.8f, %.8f], %f] }", v1, parameters.next(), parameters.next()));
                break;
            }
            case SIMPLE_PROPERTY: {
                op = Qualifier.FilterOperation.EQ;
                break;
            }
            case NEGATING_SIMPLE_PROPERTY: {
                op = Qualifier.FilterOperation.NOTEQ;
                break;
            }
            case IN: {
                op = Qualifier.FilterOperation.IN;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported keyword!");
            }
        }
        TypeInformation propertyType = property.getTypeInformation();
        if (propertyType.isCollectionLike()) {
            if (op == Qualifier.FilterOperation.CONTAINING) {
                op = Qualifier.FilterOperation.LIST_CONTAINS;
            } else if (op == Qualifier.FilterOperation.BETWEEN) {
                op = Qualifier.FilterOperation.LIST_BETWEEN;
            }
        } else if (propertyType.isMap()) {
            CriteriaDefinition.AerospikeMapCriteria onMap = (CriteriaDefinition.AerospikeMapCriteria)((Object)parameters.next());
            switch (onMap) {
                case KEY: {
                    if (op != Qualifier.FilterOperation.CONTAINING) break;
                    op = Qualifier.FilterOperation.MAP_KEYS_CONTAINS;
                    break;
                }
                case VALUE: {
                    if (op != Qualifier.FilterOperation.CONTAINING) break;
                    op = Qualifier.FilterOperation.MAP_VALUES_CONTAINS;
                }
            }
        }
        if (null == v2) {
            return new AerospikeCriteria(fieldName, op, ignoreCase == Part.IgnoreCaseType.ALWAYS, Value.get(v1));
        }
        return new AerospikeCriteria(fieldName, op, Value.get(v1), Value.get(v2));
    }

    protected AerospikeCriteria and(Part part, AerospikeCriteria base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, (Iterator)iterator);
        }
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        AerospikePersistentProperty property = (AerospikePersistentProperty)path.getLeafProperty();
        return new AerospikeCriteria(Qualifier.FilterOperation.AND, base, this.create(part, property, iterator));
    }

    protected AerospikeCriteria or(AerospikeCriteria base, AerospikeCriteria criteria) {
        return new AerospikeCriteria(Qualifier.FilterOperation.OR, base, criteria);
    }

    protected Query complete(AerospikeCriteria criteria, Sort sort) {
        Query query = (criteria == null ? null : new Query(criteria)).with(sort);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created query " + query);
        }
        return query;
    }

    private boolean isSimpleComparisionPossible(Part part) {
        switch (part.shouldIgnoreCase()) {
            case NEVER: {
                return true;
            }
            case WHEN_POSSIBLE: {
                return part.getProperty().getType() != String.class;
            }
            case ALWAYS: {
                return false;
            }
        }
        return true;
    }
}

