/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.RecordSet;
import com.aerospike.client.query.Statement;
import org.springframework.data.aerospike.query.KeyQualifier;
import org.springframework.data.aerospike.query.KeyRecordIterator;
import org.springframework.data.aerospike.query.Qualifier;
import org.springframework.data.aerospike.query.StatementBuilder;

public class QueryEngine {
    public static final String SCANS_DISABLED_MESSAGE = "Query without a filter will initiate a scan. Since scans are potentially dangerous operations, they are disabled by default in spring-data-aerospike. If you still need to use them, enable them via `scansEnabled` property in `org.springframework.data.aerospike.config.AerospikeDataSettings`.";
    private boolean scansEnabled = false;
    private final IAerospikeClient client;
    private final StatementBuilder statementBuilder;
    private final QueryPolicy queryPolicy;

    public QueryEngine(IAerospikeClient client, StatementBuilder statementBuilder, QueryPolicy queryPolicy) {
        this.client = client;
        this.statementBuilder = statementBuilder;
        this.queryPolicy = queryPolicy;
    }

    public KeyRecordIterator select(String namespace, String set, Filter filter, Qualifier ... qualifiers) {
        if (qualifiers != null && qualifiers.length == 1 && qualifiers[0] instanceof KeyQualifier) {
            KeyQualifier kq = (KeyQualifier)qualifiers[0];
            Key key = kq.makeKey(namespace, set);
            Record record = this.client.get(null, key);
            if (record == null) {
                return new KeyRecordIterator(namespace);
            }
            KeyRecord keyRecord = new KeyRecord(key, record);
            return new KeyRecordIterator(namespace, keyRecord);
        }
        Statement statement = this.statementBuilder.build(namespace, set, filter, qualifiers);
        if (!this.scansEnabled && statement.getFilter() == null) {
            throw new IllegalStateException(SCANS_DISABLED_MESSAGE);
        }
        RecordSet rs = this.client.query(this.queryPolicy, statement);
        return new KeyRecordIterator(namespace, rs);
    }

    public void setScansEnabled(boolean scansEnabled) {
        this.scansEnabled = scansEnabled;
    }

    public static enum Meta {
        KEY,
        TTL,
        EXPIRATION,
        GENERATION;


        public String toString() {
            switch (this) {
                case KEY: {
                    return "__key";
                }
                case EXPIRATION: {
                    return "__Expiration";
                }
                case GENERATION: {
                    return "__generation";
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

