/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.convert;

import com.aerospike.client.Bin;
import com.aerospike.client.Value;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.util.StringUtils;

abstract class AerospikeConverters {
    private AerospikeConverters() {
    }

    static Collection<Object> getConvertersToRegister() {
        ArrayList<Object> converters = new ArrayList<Object>();
        converters.add((Object)BigDecimalToStringConverter.INSTANCE);
        converters.add((Object)StringToBigDecimalConverter.INSTANCE);
        converters.add((Object)LongToBooleanConverter.INSTANCE);
        converters.add((Object)EnumToStringConverter.INSTANCE);
        return converters;
    }

    public static enum StringToAerospikeGeoJSONValueConverter implements Converter<String, Value.GeoJSONValue>
    {
        INSTANCE;


        public Value.GeoJSONValue convert(String source) {
            return new Value.GeoJSONValue(source);
        }
    }

    public static enum BytesToValueConverter implements Converter<Byte[], Value>
    {
        INSTANCE;


        public Value convert(Byte[] source) {
            return Value.get((Object)source);
        }
    }

    public static enum MapToValueConverter implements Converter<Map<?, ?>, Value>
    {
        INSTANCE;


        public Value convert(Map<?, ?> source) {
            return Value.get(source);
        }
    }

    public static enum ListToValueConverter implements Converter<List<?>, Value>
    {
        INSTANCE;


        public Value convert(List<?> source) {
            return Value.get(source);
        }
    }

    public static enum BinToStringConverter implements Converter<Bin, String>
    {
        INSTANCE;


        public String convert(Bin source) {
            return source.value.toString();
        }
    }

    public static enum StringToValueConverter implements Converter<String, Value>
    {
        INSTANCE;


        public Value convert(String source) {
            return Value.get((String)source);
        }
    }

    public static enum BinToLongConverter implements Converter<Bin, Long>
    {
        INSTANCE;


        public Long convert(Bin source) {
            return source.value.toLong();
        }
    }

    public static enum LongToValueConverter implements Converter<Long, Value>
    {
        INSTANCE;


        public Value convert(Long source) {
            return Value.get((Object)source);
        }
    }

    @WritingConverter
    public static enum EnumToStringConverter implements Converter<Enum<?>, String>
    {
        INSTANCE;


        public String convert(Enum<?> source) {
            return source.name();
        }
    }

    @ReadingConverter
    public static enum LongToBooleanConverter implements Converter<Long, Boolean>
    {
        INSTANCE;


        public Boolean convert(Long source) {
            return source != 0L;
        }
    }

    public static enum StringToBigDecimalConverter implements Converter<String, BigDecimal>
    {
        INSTANCE;


        public BigDecimal convert(String source) {
            return StringUtils.hasText((String)source) ? new BigDecimal(source) : null;
        }
    }

    public static enum BigDecimalToStringConverter implements Converter<BigDecimal, String>
    {
        INSTANCE;


        public String convert(BigDecimal source) {
            return source.toString();
        }
    }
}

