/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.IndexCollectionType;
import com.aerospike.client.query.IndexType;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.reactor.AerospikeReactorClient;
import com.aerospike.client.reactor.IAerospikeReactorClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.BaseAerospikeTemplate;
import org.springframework.data.aerospike.core.EntitiesKeys;
import org.springframework.data.aerospike.core.OperationUtils;
import org.springframework.data.aerospike.core.ReactiveAerospikeOperations;
import org.springframework.data.aerospike.core.model.GroupedEntities;
import org.springframework.data.aerospike.core.model.GroupedKeys;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.query.Qualifier;
import org.springframework.data.aerospike.query.ReactorQueryEngine;
import org.springframework.data.aerospike.query.cache.ReactorIndexRefresher;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.aerospike.utility.Utils;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveAerospikeTemplate
extends BaseAerospikeTemplate
implements ReactiveAerospikeOperations {
    private static final Logger log = LoggerFactory.getLogger(ReactiveAerospikeTemplate.class);
    private final AerospikeReactorClient reactorClient;
    private final ReactorQueryEngine queryEngine;
    private final ReactorIndexRefresher reactorIndexRefresher;

    public ReactiveAerospikeTemplate(AerospikeReactorClient reactorClient, String namespace, MappingAerospikeConverter converter, AerospikeMappingContext mappingContext, AerospikeExceptionTranslator exceptionTranslator, ReactorQueryEngine queryEngine, ReactorIndexRefresher reactorIndexRefresher) {
        super(namespace, converter, mappingContext, exceptionTranslator, reactorClient.getWritePolicyDefault());
        Assert.notNull((Object)reactorClient, (String)"Aerospike reactor client must not be null!");
        this.reactorClient = reactorClient;
        this.queryEngine = queryEngine;
        this.reactorIndexRefresher = reactorIndexRefresher;
    }

    @Override
    public <T> Mono<T> save(T document) {
        Assert.notNull(document, (String)"Object to save must not be null!");
        AerospikeWriteData data = this.writeData(document);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy policy = this.expectGenerationCasAwareSavePolicy(data);
            return this.doPersistWithVersionAndHandleCasError(document, data, policy);
        }
        WritePolicy policy = this.ignoreGenerationSavePolicy(data, RecordExistsAction.REPLACE);
        return this.doPersistAndHandleError(document, data, policy);
    }

    @Override
    public <T> Flux<T> insertAll(Collection<? extends T> documents) {
        return Flux.fromIterable(documents).flatMap(this::insert);
    }

    @Override
    public <T> Mono<T> insert(T document) {
        Assert.notNull(document, (String)"Document must not be null!");
        AerospikeWriteData data = this.writeData(document);
        WritePolicy policy = this.ignoreGenerationSavePolicy(data, RecordExistsAction.CREATE_ONLY);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            return this.doPersistWithVersionAndHandleError(document, data, policy);
        }
        return this.doPersistAndHandleError(document, data, policy);
    }

    @Override
    public <T> Mono<T> update(T document) {
        Assert.notNull(document, (String)"Document must not be null!");
        AerospikeWriteData data = this.writeData(document);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy policy = this.expectGenerationSavePolicy(data, RecordExistsAction.REPLACE_ONLY);
            return this.doPersistWithVersionAndHandleCasError(document, data, policy);
        }
        WritePolicy policy = this.ignoreGenerationSavePolicy(data, RecordExistsAction.REPLACE_ONLY);
        return this.doPersistAndHandleError(document, data, policy);
    }

    @Override
    public <T> Flux<T> findAll(Class<T> entityClass) {
        return this.findAllUsingQuery(entityClass, null, null);
    }

    @Override
    public <T> Mono<T> add(T objectToAddTo, Map<String, Long> values) {
        Assert.notNull(objectToAddTo, (String)"Object to add to must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        AerospikeWriteData data = this.writeData(objectToAddTo);
        Operation[] operations = new Operation[values.size() + 1];
        int x = 0;
        for (Map.Entry<String, Long> entry : values.entrySet()) {
            operations[x] = new Operation(Operation.Type.ADD, entry.getKey(), Value.get((Object)entry.getValue()));
            ++x;
        }
        operations[x] = Operation.get();
        WritePolicy writePolicy = new WritePolicy(this.writePolicyDefault);
        writePolicy.expiration = data.getExpiration();
        return this.executeOperationsOnValue(objectToAddTo, data, operations, writePolicy);
    }

    @Override
    public <T> Mono<T> add(T objectToAddTo, String binName, long value) {
        Assert.notNull(objectToAddTo, (String)"Object to add to must not be null!");
        Assert.notNull((Object)binName, (String)"Bin name must not be null!");
        AerospikeWriteData data = this.writeData(objectToAddTo);
        WritePolicy writePolicy = new WritePolicy(this.writePolicyDefault);
        writePolicy.expiration = data.getExpiration();
        Operation[] operations = new Operation[]{Operation.add((Bin)new Bin(binName, value)), Operation.get((String)binName)};
        return this.executeOperationsOnValue(objectToAddTo, data, operations, writePolicy);
    }

    @Override
    public <T> Mono<T> append(T objectToAppendTo, Map<String, String> values) {
        Assert.notNull(objectToAppendTo, (String)"Object to append to must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        AerospikeWriteData data = this.writeData(objectToAppendTo);
        Operation[] operations = OperationUtils.operations(values, Operation.Type.APPEND, Operation.get());
        return this.executeOperationsOnValue(objectToAppendTo, data, operations, null);
    }

    @Override
    public <T> Mono<T> append(T objectToAppendTo, String binName, String value) {
        Assert.notNull(objectToAppendTo, (String)"Object to append to must not be null!");
        AerospikeWriteData data = this.writeData(objectToAppendTo);
        Operation[] operations = new Operation[]{Operation.append((Bin)new Bin(binName, value)), Operation.get((String)binName)};
        return this.executeOperationsOnValue(objectToAppendTo, data, operations, null);
    }

    @Override
    public <T> Mono<T> prepend(T objectToPrependTo, Map<String, String> values) {
        Assert.notNull(objectToPrependTo, (String)"Object to prepend to must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        AerospikeWriteData data = this.writeData(objectToPrependTo);
        Operation[] operations = OperationUtils.operations(values, Operation.Type.PREPEND, Operation.get());
        return this.executeOperationsOnValue(objectToPrependTo, data, operations, null);
    }

    @Override
    public <T> Mono<T> prepend(T objectToPrependTo, String binName, String value) {
        Assert.notNull(objectToPrependTo, (String)"Object to prepend to must not be null!");
        AerospikeWriteData data = this.writeData(objectToPrependTo);
        Operation[] operations = new Operation[]{Operation.prepend((Bin)new Bin(binName, value)), Operation.get((String)binName)};
        return this.executeOperationsOnValue(objectToPrependTo, data, operations, null);
    }

    private <T> Mono<T> executeOperationsOnValue(T entity, AerospikeWriteData data, Operation[] operations, WritePolicy writePolicy) {
        return this.reactorClient.operate(writePolicy, data.getKey(), operations).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, this.getEntityClass(entity), keyRecord.record)).onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<T> findById(Object id, Class<T> entityClass) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        Key key = this.getKey(id, entity);
        if (entity.isTouchOnRead()) {
            Assert.state((!entity.hasExpirationProperty() ? 1 : 0) != 0, (String)"Touch on read is not supported for entity without expiration property");
            return this.getAndTouch(key, entity.getExpiration()).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, entityClass, keyRecord.record)).onErrorResume(th -> th instanceof AerospikeException && ((AerospikeException)th).getResultCode() == 2, th -> Mono.empty()).onErrorMap(this::translateError);
        }
        return this.reactorClient.get(key).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, entityClass, keyRecord.record)).onErrorMap(this::translateError);
    }

    @Override
    public <T> Flux<T> findByIds(Iterable<?> ids, Class<T> entityClass) {
        Assert.notNull(ids, (String)"List of ids must not be null!");
        Assert.notNull(entityClass, (String)"Type must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        return Flux.fromIterable(ids).map(id -> this.getKey(id, entity)).flatMap(arg_0 -> ((AerospikeReactorClient)this.reactorClient).get(arg_0)).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, entityClass, keyRecord.record));
    }

    @Override
    public Mono<GroupedEntities> findByIds(GroupedKeys groupedKeys) {
        Assert.notNull((Object)groupedKeys, (String)"Grouped keys must not be null!");
        if (groupedKeys.getEntitiesKeys().isEmpty()) {
            return Mono.just((Object)GroupedEntities.builder().build());
        }
        return this.findEntitiesByIdsInternal(groupedKeys);
    }

    private Mono<GroupedEntities> findEntitiesByIdsInternal(GroupedKeys groupedKeys) {
        EntitiesKeys entitiesKeys = EntitiesKeys.of(this.toEntitiesKeyMap(groupedKeys));
        return this.reactorClient.get(null, entitiesKeys.getKeys()).map(item -> this.toGroupedEntities(entitiesKeys, item.records)).onErrorMap(this::translateError);
    }

    @Override
    public <T> Flux<T> find(Query query, Class<T> entityClass) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(entityClass, (String)"Type must not be null!");
        return this.findAllUsingQuery(entityClass, query);
    }

    @Override
    public <T> Flux<T> findInRange(long offset, long limit, Sort sort, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Type for count must not be null!");
        Assert.notNull(entityClass, (String)"Type must not be null!");
        return this.findAllUsingQuery(entityClass, null, null).skip(offset).take(limit);
    }

    @Override
    public <T> Mono<Long> count(Query query, Class<T> entityClass) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(entityClass, (String)"Type must not be null!");
        return this.findAllRecordsUsingQuery(entityClass, query).count();
    }

    @Override
    public Mono<Long> count(String setName) {
        Assert.notNull((Object)setName, (String)"Set for count must not be null!");
        try {
            return Mono.fromCallable(() -> this.countSet(setName));
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> Mono<Long> count(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Type must not be null!");
        String setName = this.getSetName((Class)entityClass);
        return this.count(setName);
    }

    private long countSet(String setName) {
        Node[] nodes = this.reactorClient.getAerospikeClient().getNodes();
        int replicationFactor = Utils.getReplicationFactor(nodes, this.namespace);
        long totalObjects = Arrays.stream(nodes).mapToLong(node -> Utils.getObjectsCount(node, this.namespace, setName)).sum();
        return nodes.length > 1 ? totalObjects / (long)replicationFactor : totalObjects;
    }

    @Override
    public <T> Mono<T> execute(Supplier<T> supplier) {
        Assert.notNull(supplier, (String)"Supplier must not be null!");
        return Mono.fromSupplier(supplier).onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<Boolean> exists(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Type must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        Key key = this.getKey(id, entity);
        return this.reactorClient.exists(key).map(Objects::nonNull).defaultIfEmpty((Object)false).onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<Void> delete(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Type must not be null!");
        try {
            String set = this.getSetName((Class)entityClass);
            return Mono.fromRunnable(() -> this.reactorClient.getAerospikeClient().truncate(null, this.namespace, set, null));
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> Mono<Boolean> delete(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Type must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        return this.reactorClient.delete(this.ignoreGenerationDeletePolicy(), this.getKey(id, entity)).map(k -> true).onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<Boolean> delete(T objectToDelete) {
        Assert.notNull(objectToDelete, (String)"Object to delete must not be null!");
        AerospikeWriteData data = this.writeData(objectToDelete);
        return this.reactorClient.delete(this.ignoreGenerationDeletePolicy(), data.getKey()).map(key -> true).onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<Void> createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType) {
        return this.createIndex(entityClass, indexName, binName, indexType, IndexCollectionType.DEFAULT);
    }

    @Override
    public <T> Mono<Void> createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType) {
        Assert.notNull(entityClass, (String)"Type must not be null!");
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        Assert.notNull((Object)binName, (String)"Bin name must not be null!");
        Assert.notNull((Object)indexType, (String)"Index type must not be null!");
        Assert.notNull((Object)indexCollectionType, (String)"Index collection type must not be null!");
        String setName = this.getSetName((Class)entityClass);
        return this.reactorClient.createIndex(null, this.namespace, setName, indexName, binName, indexType, indexCollectionType).then(this.reactorIndexRefresher.refreshIndexes()).onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<Void> deleteIndex(Class<T> entityClass, String indexName) {
        Assert.notNull(entityClass, (String)"Type must not be null!");
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        String setName = this.getSetName((Class)entityClass);
        return this.reactorClient.dropIndex(null, this.namespace, setName, indexName).then(this.reactorIndexRefresher.refreshIndexes()).onErrorMap(this::translateError);
    }

    @Override
    public IAerospikeReactorClient getAerospikeReactorClient() {
        return this.reactorClient;
    }

    private <T> Mono<T> doPersistAndHandleError(T document, AerospikeWriteData data, WritePolicy policy) {
        return this.reactorClient.put(policy, data.getKey(), data.getBinsAsArray()).map(docKey -> document).onErrorMap(this::translateError);
    }

    private <T> Mono<T> doPersistWithVersionAndHandleCasError(T document, AerospikeWriteData data, WritePolicy policy) {
        return this.putAndGetHeader(data, policy).map(newRecord -> this.updateVersion(document, (Record)newRecord)).onErrorMap(AerospikeException.class, this::translateCasError);
    }

    private <T> Mono<T> doPersistWithVersionAndHandleError(T document, AerospikeWriteData data, WritePolicy policy) {
        return this.putAndGetHeader(data, policy).map(newRecord -> this.updateVersion(document, (Record)newRecord)).onErrorMap(AerospikeException.class, this::translateError);
    }

    private <T> Mono<Record> putAndGetHeader(AerospikeWriteData data, WritePolicy policy) {
        Operation[] operations = OperationUtils.operations(data.getBinsAsArray(), Operation::put, Operation.getHeader());
        return this.reactorClient.operate(policy, data.getKey(), operations).map(keyRecord -> keyRecord.record);
    }

    private Mono<KeyRecord> getAndTouch(Key key, int expiration) {
        WritePolicy policy = new WritePolicy(this.writePolicyDefault);
        policy.expiration = expiration;
        return this.reactorClient.operate(policy, key, new Operation[]{Operation.touch(), Operation.get()});
    }

    private Throwable translateError(Throwable e) {
        if (e instanceof AerospikeException) {
            return this.translateError((AerospikeException)e);
        }
        return e;
    }

    <T> Flux<T> findAllUsingQuery(Class<T> type, Query query) {
        if ((query.getSort() == null || query.getSort().isUnsorted()) && query.getOffset() > 0L) {
            throw new IllegalArgumentException("Unsorted query must not have offset value. For retrieving paged results use sorted query.");
        }
        Qualifier qualifier = query.getCriteria().getCriteriaObject();
        Flux results = this.findAllUsingQuery(type, null, qualifier);
        if (query.getSort() != null && query.getSort().isSorted()) {
            Comparator comparator = this.getComparator(query);
            results = results.sort(comparator);
        }
        if (query.hasOffset()) {
            results = results.skip(query.getOffset());
        }
        if (query.hasRows()) {
            results = results.take((long)query.getRows());
        }
        return results;
    }

    <T> Flux<T> findAllUsingQuery(Class<T> type, Filter filter, Qualifier ... qualifiers) {
        return this.findAllRecordsUsingQuery(type, filter, qualifiers).map(keyRecord -> this.mapToEntity(keyRecord.key, type, keyRecord.record));
    }

    <T> Flux<KeyRecord> findAllRecordsUsingQuery(Class<T> type, Query query) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        Qualifier qualifier = query.getCriteria().getCriteriaObject();
        return this.findAllRecordsUsingQuery(type, null, qualifier);
    }

    <T> Flux<KeyRecord> findAllRecordsUsingQuery(Class<T> type, Filter filter, Qualifier ... qualifiers) {
        String setName = this.getSetName((Class)type);
        return this.queryEngine.select(this.namespace, setName, filter, qualifiers);
    }
}

