/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.index;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.SmartLifecycle;
import org.springframework.data.aerospike.index.AerospikeIndexDefinition;
import org.springframework.data.aerospike.index.AerospikeIndexResolver;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.BasicAerospikePersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.MappingContextEvent;

public abstract class BaseAerospikePersistenceEntityIndexCreator
implements ApplicationListener<MappingContextEvent<?, ?>>,
SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(BaseAerospikePersistenceEntityIndexCreator.class);
    private final AerospikeIndexResolver aerospikeIndexDetector = new AerospikeIndexResolver();
    private final AerospikeMappingContext aerospikeMappingContext;
    private final Set<AerospikeIndexDefinition> initialIndexes = new HashSet<AerospikeIndexDefinition>();
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    public void onApplicationEvent(MappingContextEvent<?, ?> event) {
        if (!this.aerospikeMappingContext.isCreateIndexesOnStartup()) {
            return;
        }
        if (!event.wasEmittedBy((MappingContext)this.aerospikeMappingContext)) {
            return;
        }
        this.aerospikeMappingContext.setAerospikeIndexResolverEnvironment(this.aerospikeIndexDetector);
        BasicAerospikePersistentEntity persistentEntity = (BasicAerospikePersistentEntity)event.getPersistentEntity();
        Set<AerospikeIndexDefinition> indexes = this.aerospikeIndexDetector.detectIndexes(persistentEntity);
        if (!indexes.isEmpty()) {
            if (!this.initialized.get()) {
                this.initialIndexes.addAll(indexes);
                return;
            }
            log.debug("Creating {} indexes for entity[{}]...", indexes, (Object)event.getPersistentEntity().getName());
            this.installIndexes(indexes);
        }
    }

    public void start() {
        this.initialized.set(true);
        this.installIndexes(this.initialIndexes);
        this.initialIndexes.clear();
    }

    protected abstract void installIndexes(Set<AerospikeIndexDefinition> var1);

    public void stop() {
    }

    public boolean isRunning() {
        return this.initialized.get();
    }

    public BaseAerospikePersistenceEntityIndexCreator(AerospikeMappingContext aerospikeMappingContext) {
        this.aerospikeMappingContext = aerospikeMappingContext;
    }
}

