/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.mapping;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.aerospike.convert.AerospikeReadData;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.mapping.model.SimpleTypeHolder;

public abstract class AerospikeSimpleTypes {
    public static final Set<Class<?>> AUTOGENERATED_ID_TYPES;
    private static final Set<Class<?>> AEROSPIKE_SIMPLE_TYPES;
    public static final SimpleTypeHolder HOLDER;

    private AerospikeSimpleTypes() {
    }

    static {
        HashSet<Class<Long>> classes = new HashSet<Class<Long>>();
        classes.add(String.class);
        classes.add(Integer.class);
        classes.add(Long.class);
        AUTOGENERATED_ID_TYPES = Collections.unmodifiableSet(classes);
        HashSet<Class<Object>> simpleTypes = new HashSet<Class<Object>>();
        simpleTypes.add(Boolean.TYPE);
        simpleTypes.add(boolean[].class);
        simpleTypes.add(Long.TYPE);
        simpleTypes.add(long[].class);
        simpleTypes.add(Short.TYPE);
        simpleTypes.add(short[].class);
        simpleTypes.add(Integer.TYPE);
        simpleTypes.add(int[].class);
        simpleTypes.add(Byte.TYPE);
        simpleTypes.add(byte[].class);
        simpleTypes.add(Float.TYPE);
        simpleTypes.add(float[].class);
        simpleTypes.add(Double.TYPE);
        simpleTypes.add(double[].class);
        simpleTypes.add(Character.TYPE);
        simpleTypes.add(char[].class);
        simpleTypes.add(Boolean.class);
        simpleTypes.add(Long.class);
        simpleTypes.add(Short.class);
        simpleTypes.add(Integer.class);
        simpleTypes.add(Byte.class);
        simpleTypes.add(Float.class);
        simpleTypes.add(Double.class);
        simpleTypes.add(Character.class);
        simpleTypes.add(String.class);
        simpleTypes.add(Date.class);
        simpleTypes.add(Locale.class);
        simpleTypes.add(Class.class);
        simpleTypes.add(Enum.class);
        simpleTypes.add(Byte[].class);
        simpleTypes.add(UUID.class);
        simpleTypes.add(AerospikeReadData.class);
        simpleTypes.add(AerospikeWriteData.class);
        AEROSPIKE_SIMPLE_TYPES = Collections.unmodifiableSet(simpleTypes);
        HOLDER = new SimpleTypeHolder(AEROSPIKE_SIMPLE_TYPES, Boolean.FALSE.booleanValue());
    }
}

