/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.config;

public final class AerospikeDataSettings {
    private final boolean scansEnabled;
    private final boolean sendKey;

    private static boolean $default$scansEnabled() {
        return false;
    }

    private static boolean $default$sendKey() {
        return true;
    }

    AerospikeDataSettings(boolean scansEnabled, boolean sendKey) {
        this.scansEnabled = scansEnabled;
        this.sendKey = sendKey;
    }

    public static AerospikeDataSettingsBuilder builder() {
        return new AerospikeDataSettingsBuilder();
    }

    public boolean isScansEnabled() {
        return this.scansEnabled;
    }

    public boolean isSendKey() {
        return this.sendKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AerospikeDataSettings)) {
            return false;
        }
        AerospikeDataSettings other = (AerospikeDataSettings)o;
        if (this.isScansEnabled() != other.isScansEnabled()) {
            return false;
        }
        return this.isSendKey() == other.isSendKey();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isScansEnabled() ? 79 : 97);
        result = result * 59 + (this.isSendKey() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "AerospikeDataSettings(scansEnabled=" + this.isScansEnabled() + ", sendKey=" + this.isSendKey() + ")";
    }

    public static class AerospikeDataSettingsBuilder {
        private boolean scansEnabled$set;
        private boolean scansEnabled$value;
        private boolean sendKey$set;
        private boolean sendKey$value;

        AerospikeDataSettingsBuilder() {
        }

        public AerospikeDataSettingsBuilder scansEnabled(boolean scansEnabled) {
            this.scansEnabled$value = scansEnabled;
            this.scansEnabled$set = true;
            return this;
        }

        public AerospikeDataSettingsBuilder sendKey(boolean sendKey) {
            this.sendKey$value = sendKey;
            this.sendKey$set = true;
            return this;
        }

        public AerospikeDataSettings build() {
            boolean scansEnabled$value = this.scansEnabled$value;
            if (!this.scansEnabled$set) {
                scansEnabled$value = AerospikeDataSettings.$default$scansEnabled();
            }
            boolean sendKey$value = this.sendKey$value;
            if (!this.sendKey$set) {
                sendKey$value = AerospikeDataSettings.$default$sendKey();
            }
            return new AerospikeDataSettings(scansEnabled$value, sendKey$value);
        }

        public String toString() {
            return "AerospikeDataSettings.AerospikeDataSettingsBuilder(scansEnabled$value=" + this.scansEnabled$value + ", sendKey$value=" + this.sendKey$value + ")";
        }
    }
}

