/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.index;

import com.aerospike.client.query.IndexCollectionType;
import com.aerospike.client.query.IndexType;
import lombok.NonNull;

public final class AerospikeIndexDefinition {
    @NonNull
    private final String name;
    @NonNull
    private final String fieldName;
    @NonNull
    private final IndexType type;
    @NonNull
    private final IndexCollectionType collectionType;
    @NonNull
    private final Class<?> entityClass;

    AerospikeIndexDefinition(@NonNull String name, @NonNull String fieldName, @NonNull IndexType type, @NonNull IndexCollectionType collectionType, @NonNull Class<?> entityClass) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (collectionType == null) {
            throw new NullPointerException("collectionType is marked non-null but is null");
        }
        if (entityClass == null) {
            throw new NullPointerException("entityClass is marked non-null but is null");
        }
        this.name = name;
        this.fieldName = fieldName;
        this.type = type;
        this.collectionType = collectionType;
        this.entityClass = entityClass;
    }

    public static AerospikeIndexDefinitionBuilder builder() {
        return new AerospikeIndexDefinitionBuilder();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getFieldName() {
        return this.fieldName;
    }

    @NonNull
    public IndexType getType() {
        return this.type;
    }

    @NonNull
    public IndexCollectionType getCollectionType() {
        return this.collectionType;
    }

    @NonNull
    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AerospikeIndexDefinition)) {
            return false;
        }
        AerospikeIndexDefinition other = (AerospikeIndexDefinition)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        IndexType this$type = this.getType();
        IndexType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        IndexCollectionType this$collectionType = this.getCollectionType();
        IndexCollectionType other$collectionType = other.getCollectionType();
        if (this$collectionType == null ? other$collectionType != null : !this$collectionType.equals(other$collectionType)) {
            return false;
        }
        Class<?> this$entityClass = this.getEntityClass();
        Class<?> other$entityClass = other.getEntityClass();
        return !(this$entityClass == null ? other$entityClass != null : !this$entityClass.equals(other$entityClass));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        IndexType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        IndexCollectionType $collectionType = this.getCollectionType();
        result = result * 59 + ($collectionType == null ? 43 : $collectionType.hashCode());
        Class<?> $entityClass = this.getEntityClass();
        result = result * 59 + ($entityClass == null ? 43 : $entityClass.hashCode());
        return result;
    }

    public String toString() {
        return "AerospikeIndexDefinition(name=" + this.getName() + ", fieldName=" + this.getFieldName() + ", type=" + this.getType() + ", collectionType=" + this.getCollectionType() + ", entityClass=" + this.getEntityClass() + ")";
    }

    public static class AerospikeIndexDefinitionBuilder {
        private String name;
        private String fieldName;
        private IndexType type;
        private IndexCollectionType collectionType;
        private Class<?> entityClass;

        AerospikeIndexDefinitionBuilder() {
        }

        public AerospikeIndexDefinitionBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public AerospikeIndexDefinitionBuilder fieldName(@NonNull String fieldName) {
            if (fieldName == null) {
                throw new NullPointerException("fieldName is marked non-null but is null");
            }
            this.fieldName = fieldName;
            return this;
        }

        public AerospikeIndexDefinitionBuilder type(@NonNull IndexType type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        public AerospikeIndexDefinitionBuilder collectionType(@NonNull IndexCollectionType collectionType) {
            if (collectionType == null) {
                throw new NullPointerException("collectionType is marked non-null but is null");
            }
            this.collectionType = collectionType;
            return this;
        }

        public AerospikeIndexDefinitionBuilder entityClass(@NonNull Class<?> entityClass) {
            if (entityClass == null) {
                throw new NullPointerException("entityClass is marked non-null but is null");
            }
            this.entityClass = entityClass;
            return this;
        }

        public AerospikeIndexDefinition build() {
            return new AerospikeIndexDefinition(this.name, this.fieldName, this.type, this.collectionType, this.entityClass);
        }

        public String toString() {
            return "AerospikeIndexDefinition.AerospikeIndexDefinitionBuilder(name=" + this.name + ", fieldName=" + this.fieldName + ", type=" + this.type + ", collectionType=" + this.collectionType + ", entityClass=" + this.entityClass + ")";
        }
    }
}

