/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.query.Filter;
import com.aerospike.client.query.PredExp;
import com.aerospike.client.query.Statement;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.aerospike.query.Qualifier;
import org.springframework.data.aerospike.query.QualifierException;
import org.springframework.data.aerospike.query.cache.IndexesCache;
import org.springframework.data.aerospike.query.model.IndexedField;

public class StatementBuilder {
    private final IndexesCache indexesCache;

    public StatementBuilder(IndexesCache indexesCache) {
        this.indexesCache = indexesCache;
    }

    public Statement build(String namespace, String set, Filter filter, Qualifier[] qualifiers) {
        Statement stmt = new Statement();
        stmt.setNamespace(namespace);
        stmt.setSetName(set);
        if (filter != null) {
            stmt.setFilter(filter);
        }
        if (qualifiers != null && qualifiers.length != 0) {
            this.updateStatement(stmt, qualifiers);
        }
        return stmt;
    }

    private void updateStatement(Statement stmt, Qualifier[] qualifiers) {
        PredExp[] predexps;
        block0: for (int i = 0; i < qualifiers.length; ++i) {
            Filter filter;
            Qualifier qualifier = qualifiers[i];
            if (qualifier == null) continue;
            if (qualifier.getOperation() == Qualifier.FilterOperation.AND) {
                for (Qualifier q : qualifier.getQualifiers()) {
                    Filter filter2;
                    if (q == null || !this.isIndexedBin(stmt, q) || (filter2 = q.asFilter()) == null) continue;
                    stmt.setFilter(filter2);
                    q.asFilter(true);
                    continue block0;
                }
                continue;
            }
            if (!this.isIndexedBin(stmt, qualifier) || (filter = qualifier.asFilter()) == null) continue;
            stmt.setFilter(filter);
            qualifier.asFilter(true);
            qualifiers[i] = null;
            if (qualifiers.length != 1) break;
            return;
        }
        if ((predexps = StatementBuilder.buildPredExp(qualifiers).toArray(new PredExp[0])).length <= 0) {
            throw new QualifierException("Failed to build Query");
        }
        stmt.setPredExp(predexps);
    }

    private boolean isIndexedBin(Statement stmt, Qualifier qualifier) {
        if (qualifier.getField() == null) {
            return false;
        }
        return this.indexesCache.hasIndexFor(new IndexedField(stmt.getNamespace(), stmt.getSetName(), qualifier.getField()));
    }

    private static List<PredExp> buildPredExp(Qualifier[] qualifiers) {
        ArrayList<PredExp> pes = new ArrayList<PredExp>();
        int qCount = 0;
        for (Qualifier q : qualifiers) {
            List<PredExp> tpes;
            if (null == q || q.queryAsFilter().booleanValue() || (tpes = q.toPredExp()).size() <= 0) continue;
            pes.addAll(tpes);
            ++qCount;
            q = null;
        }
        if (qCount > 1) {
            pes.add(PredExp.and((int)qCount));
        }
        return pes;
    }
}

