/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.convert;

import com.aerospike.client.Key;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.utility.TimeUtils;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.convert.TypeMapper;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class MappingAerospikeWriteConverter
implements EntityWriter<Object, AerospikeWriteData> {
    private final TypeMapper<Map<String, Object>> typeMapper;
    private final AerospikeMappingContext mappingContext;
    private final CustomConversions conversions;
    private final GenericConversionService conversionService;

    public MappingAerospikeWriteConverter(TypeMapper<Map<String, Object>> typeMapper, AerospikeMappingContext mappingContext, CustomConversions conversions, GenericConversionService conversionService) {
        this.typeMapper = typeMapper;
        this.mappingContext = mappingContext;
        this.conversions = conversions;
        this.conversionService = conversionService;
    }

    public void write(Object source, AerospikeWriteData data) {
        AerospikePersistentProperty versionProperty;
        if (source == null) {
            return;
        }
        boolean hasCustomConverter = this.conversions.hasCustomWriteTarget(source.getClass(), AerospikeWriteData.class);
        if (hasCustomConverter) {
            this.convertToAerospikeWriteData(source, data);
            return;
        }
        ClassTypeInformation type = ClassTypeInformation.from(source.getClass());
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getPersistentEntity(source.getClass());
        ConvertingPropertyAccessor accessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(source), (ConversionService)this.conversionService);
        AerospikePersistentProperty idProperty = (AerospikePersistentProperty)entity.getIdProperty();
        if (idProperty != null) {
            String id = (String)accessor.getProperty((PersistentProperty)idProperty, String.class);
            Assert.notNull((Object)id, (String)"Id must not be null!");
            data.setKey(new Key(data.getKey().namespace, entity.getSetName(), id));
        }
        if ((versionProperty = (AerospikePersistentProperty)entity.getVersionProperty()) != null) {
            Integer version = (Integer)accessor.getProperty((PersistentProperty)versionProperty, Integer.class);
            data.setVersion(version);
        }
        data.setExpiration(this.getExpiration(entity, accessor));
        Map<String, Object> convertedProperties = this.convertProperties((TypeInformation<?>)type, entity, (ConvertingPropertyAccessor<?>)accessor);
        convertedProperties.forEach(data::addBin);
    }

    private void convertToAerospikeWriteData(Object source, AerospikeWriteData data) {
        AerospikeWriteData converted = (AerospikeWriteData)this.conversionService.convert(source, AerospikeWriteData.class);
        data.setBins(converted.getBins());
        data.setKey(converted.getKey());
        data.setExpiration(converted.getExpiration());
    }

    private Map<String, Object> convertProperties(TypeInformation<?> type, AerospikePersistentEntity<?> entity, ConvertingPropertyAccessor<?> accessor) {
        HashMap<String, Object> target = new HashMap<String, Object>();
        this.typeMapper.writeType(type, target);
        entity.doWithProperties(property -> {
            Object value = accessor.getProperty(property);
            if (this.isNotWritable((AerospikePersistentProperty)property)) {
                return;
            }
            Object valueToWrite = this.getValueToWrite(value, property.getTypeInformation());
            if (valueToWrite != null) {
                target.put(property.getFieldName(), valueToWrite);
            }
        });
        return target;
    }

    private boolean isNotWritable(AerospikePersistentProperty property) {
        return property.isIdProperty() || property.isExpirationProperty() || property.isVersionProperty() || !property.isWritable();
    }

    private Object getValueToWrite(Object value, TypeInformation<?> type) {
        if (value == null) {
            return null;
        }
        if (type == null || this.conversions.isSimpleType(value.getClass())) {
            return this.getSimpleValueToWrite(value);
        }
        return this.getNonSimpleValueToWrite(value, type);
    }

    private Object getSimpleValueToWrite(Object value) {
        Optional customTarget = this.conversions.getCustomWriteTarget(value.getClass());
        return customTarget.map(aClass -> this.conversionService.convert(value, aClass)).orElse(value);
    }

    private Object getNonSimpleValueToWrite(Object value, TypeInformation<?> type) {
        ClassTypeInformation valueType = ClassTypeInformation.from(value.getClass());
        if (valueType.isCollectionLike()) {
            return this.convertCollection(MappingAerospikeWriteConverter.asCollection(value), type);
        }
        if (valueType.isMap()) {
            return this.convertMap(this.asMap(value), type);
        }
        Optional basicTargetType = this.conversions.getCustomWriteTarget(value.getClass());
        return basicTargetType.map(aClass -> this.conversionService.convert(value, aClass)).orElseGet(() -> this.lambda$getNonSimpleValueToWrite$3(value, (TypeInformation)valueType));
    }

    private List<Object> convertCollection(Collection<?> source, TypeInformation<?> type) {
        Assert.notNull(source, (String)"Given collection must not be null!");
        Assert.notNull(type, (String)"Given type must not be null!");
        TypeInformation componentType = type.getComponentType();
        return source.stream().map(element -> this.getValueToWrite(element, componentType)).collect(Collectors.toList());
    }

    private Map<String, Object> convertMap(Map<Object, Object> source, TypeInformation<?> type) {
        Assert.notNull(source, (String)"Given map must not be null!");
        Assert.notNull(type, (String)"Given type must not be null!");
        return source.entrySet().stream().collect(HashMap::new, (m, e) -> {
            Object key = e.getKey();
            Object value = e.getValue();
            if (!this.conversions.isSimpleType(key.getClass())) {
                throw new MappingException("Cannot use a complex object as a key value.");
            }
            String simpleKey = key.toString();
            Object convertedValue = this.getValueToWrite(value, type.getMapValueType());
            m.put(simpleKey, convertedValue);
        }, HashMap::putAll);
    }

    private Map<String, Object> convertCustomType(Object source, TypeInformation<?> type) {
        Assert.notNull((Object)source, (String)"Given map must not be null!");
        Assert.notNull(type, (String)"Given type must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getPersistentEntity(source.getClass());
        ConvertingPropertyAccessor accessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(source), (ConversionService)this.conversionService);
        return this.convertProperties(type, entity, accessor);
    }

    private Map<Object, Object> asMap(Object value) {
        return (Map)value;
    }

    private static Collection<?> asCollection(Object source) {
        if (source instanceof Collection) {
            return (Collection)source;
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
    }

    private int getExpiration(AerospikePersistentEntity<?> entity, ConvertingPropertyAccessor<?> accessor) {
        AerospikePersistentProperty expirationProperty = entity.getExpirationProperty();
        if (expirationProperty != null) {
            return this.getExpirationFromProperty(accessor, expirationProperty);
        }
        return entity.getExpiration();
    }

    private int getExpirationFromProperty(ConvertingPropertyAccessor<?> accessor, AerospikePersistentProperty expirationProperty) {
        if (expirationProperty.isExpirationSpecifiedAsUnixTime()) {
            Long unixTime = (Long)accessor.getProperty((PersistentProperty)expirationProperty, Long.class);
            Assert.notNull((Object)unixTime, (String)"Expiration must not be null!");
            int inSeconds = TimeUtils.unixTimeToOffsetInSeconds(unixTime);
            Assert.isTrue((inSeconds > 0 ? 1 : 0) != 0, (String)("Expiration value must be greater than zero, but was: " + inSeconds + " seconds (unix time: " + unixTime + ")"));
            return inSeconds;
        }
        Integer expirationInSeconds = (Integer)accessor.getProperty((PersistentProperty)expirationProperty, Integer.class);
        Assert.notNull((Object)expirationInSeconds, (String)"Expiration must not be null!");
        return expirationInSeconds;
    }

    private /* synthetic */ Object lambda$getNonSimpleValueToWrite$3(Object value, TypeInformation valueType) {
        return this.convertCustomType(value, valueType);
    }
}

