/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.mapping;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.aerospike.annotation.Expiration;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.Field;
import org.springframework.data.annotation.Id;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BasicAerospikePersistentProperty
extends AnnotationBasedPersistentProperty<AerospikePersistentProperty>
implements AerospikePersistentProperty {
    private static final Set<Class<?>> SUPPORTED_ID_TYPES = new HashSet();
    private final FieldNamingStrategy fieldNamingStrategy;

    public BasicAerospikePersistentProperty(Property property, PersistentEntity<?, AerospikePersistentProperty> owner, SimpleTypeHolder simpleTypeHolder, FieldNamingStrategy fieldNamingStrategy) {
        super(property, owner, simpleTypeHolder);
        this.fieldNamingStrategy = fieldNamingStrategy == null ? PropertyNameFieldNamingStrategy.INSTANCE : fieldNamingStrategy;
    }

    @Override
    public boolean isExplicitIdProperty() {
        return this.isAnnotationPresent(Id.class);
    }

    @Override
    public boolean isExpirationProperty() {
        return this.isAnnotationPresent(Expiration.class);
    }

    @Override
    public boolean isExpirationSpecifiedAsUnixTime() {
        Expiration expiration = (Expiration)this.findAnnotation(Expiration.class);
        Assert.state((expiration != null ? 1 : 0) != 0, (String)("Property " + this.getName() + " is not expiration property"));
        return expiration.unixTime();
    }

    @Override
    public String getFieldName() {
        Field annotation = (Field)this.findAnnotation(Field.class);
        if (annotation != null && StringUtils.hasText((String)annotation.value())) {
            return annotation.value();
        }
        String fieldName = this.fieldNamingStrategy.getFieldName((PersistentProperty)this);
        if (!StringUtils.hasText((String)fieldName)) {
            throw new MappingException(String.format("Invalid (null or empty) field name returned for property %s by %s!", this, this.fieldNamingStrategy.getClass()));
        }
        return fieldName;
    }

    protected Association<AerospikePersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    static {
        SUPPORTED_ID_TYPES.add(String.class);
        SUPPORTED_ID_TYPES.add(Integer.class);
        SUPPORTED_ID_TYPES.add(Long.class);
        SUPPORTED_ID_TYPES.add(byte[].class);
        SUPPORTED_ID_TYPES.add(Map.class);
        SUPPORTED_ID_TYPES.add(List.class);
    }
}

