/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.exp.Exp;
import com.aerospike.client.exp.Expression;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.aerospike.query.Qualifier;

public class FilterExpressionsBuilder {
    public Expression build(Qualifier[] qualifiers) {
        if (qualifiers != null && qualifiers.length != 0) {
            List relevantQualifiers = Arrays.stream(qualifiers).filter(q -> q != null && q.queryAsFilter() == false).collect(Collectors.toList());
            if (relevantQualifiers.size() > 1) {
                Exp[] exps = (Exp[])relevantQualifiers.stream().map(Qualifier::toFilterExp).toArray(Exp[]::new);
                Exp finalExp = Exp.and((Exp[])exps);
                return Exp.build((Exp)finalExp);
            }
            if (relevantQualifiers.size() == 1) {
                return Exp.build((Exp)((Qualifier)relevantQualifiers.get(0)).toFilterExp());
            }
        }
        return null;
    }
}

